/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.controller;

import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.common.util.RedisUtil;
import com.els.modules.system.entity.PersonalSetting;
import com.els.modules.system.service.ElsSubAccountService;
import com.els.modules.system.service.PersonalSettingService;
import java.util.List;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/account/personalSetting"})
public class PersonalSettingController
extends BaseController<PersonalSetting, PersonalSettingService> {
    private static final Logger log = LoggerFactory.getLogger(PersonalSettingController.class);
    @Autowired
    private PersonalSettingService personalSettingService;
    @Autowired
    private ElsSubAccountService accountService;
    @Autowired
    @Lazy
    private RedisUtil redisUtil;

    @SrmValidated
    @AutoLog(value="\u4e2a\u4eba\u8bbe\u7f6e-\u4fdd\u5b58\u63a5\u53d7\u8bbe\u7f6e", logType=2, operateType=3)
    @PostMapping(value={"/saveSetting"})
    @RequiresPermissions(value={"account#personalSetting:set"})
    public Result<?> saveSetting(@RequestBody PersonalSetting personalSetting) {
        String elsAccount = this.getTenantId();
        String subAccount = this.getCurrentUser().getSubAccount();
        log.info("PersonalSettingController->saveSetting: personalSetting: " + personalSetting + ", elsAccount: " + elsAccount + ", subAccount: " + subAccount);
        this.personalSettingService.saveNewSetting(elsAccount, subAccount, personalSetting);
        return Result.ok();
    }

    @GetMapping(value={"/querySetting"})
    @RequiresPermissions(value={"account#personalSetting:set"})
    public Result<?> querySetting() {
        String elsAccount = this.getTenantId();
        String subAccount = this.getCurrentUser().getSubAccount();
        log.info("PersonalSettingController->querySetting: elsAccount: " + elsAccount + ",subAccount: " + subAccount);
        List<PersonalSetting> personalSetting = this.personalSettingService.querySettingBySubAccount(elsAccount, subAccount);
        return Result.ok(personalSetting);
    }

    @GetMapping(value={"/getOtpQr"})
    @RequiresPermissions(value={"account#personalSetting:set"})
    public Result<?> getOtpQr() {
        return Result.ok((String)this.accountService.getOtpQr(this.getTenantId(), this.getCurrentUser().getSubAccount()));
    }

    @GetMapping(value={"/resetOtpQr"})
    @RequiresPermissions(value={"account#personalSetting:set"})
    public Result<?> resetOtpQr() {
        return Result.ok((String)this.accountService.resetOtpQr(this.getTenantId(), this.getCurrentUser().getSubAccount()));
    }
}

