/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.controller;

import com.els.common.api.vo.Result;
import com.els.common.util.RedisUtil;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/redis"})
@Tag(name="redis")
public class RedisController {
    private static final Logger log = LoggerFactory.getLogger(RedisController.class);
    @Autowired
    private RedisUtil redisUtil;

    @GetMapping(value={"/getKeys"})
    public Result<Object> getKeys(@RequestParam(name="key", required=true) String key) {
        Set keySet = this.redisUtil.getKeys(key);
        return Result.ok((Object)keySet);
    }

    @GetMapping(value={"/getValue"})
    public Result<Object> getValue(@RequestParam(name="key", required=true) String key) {
        Object obj = this.redisUtil.get(key);
        return Result.ok((Object)obj);
    }

    @GetMapping(value={"/delKeyFuzzy"})
    public Result<?> delKeyFuzzy(@RequestParam(name="key", required=true) String key) {
        this.redisUtil.dels(key);
        return Result.ok();
    }

    @GetMapping(value={"/delKey"})
    public Result<?> delKey(@RequestParam(name="key", required=true) String key) {
        this.redisUtil.del(new String[]{key});
        return Result.ok();
    }
}

