/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.template.controller;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.FormCommit;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.AdminFlagUtil;
import com.els.common.util.I18nUtil;
import com.els.common.util.ListColumnQueryBuilder;
import com.els.common.util.LoginUserContext;
import com.els.common.util.RedisKeyUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SrmRpcUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.account.api.dto.SubAccountOrgDTO;
import com.els.modules.attachment.storage.service.FileStoreSignService;
import com.els.modules.base.api.dto.TemplateConfigHeadDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.org.api.dto.PurchaseOrganizationInfoDTO;
import com.els.modules.org.api.enumrate.PurchaseOrgCategoryStatus;
import com.els.modules.org.api.service.PurchaseOrganizationInfoRpcService;
import com.els.modules.system.entity.DictItem;
import com.els.modules.system.service.impl.DictServiceImpl;
import com.els.modules.template.entity.TemplateConfigHead;
import com.els.modules.template.entity.TemplateConfigItem;
import com.els.modules.template.entity.TemplateGroup;
import com.els.modules.template.entity.TemplateHead;
import com.els.modules.template.enumerate.TemplateStatusEnum;
import com.els.modules.template.excel.TemplateHeadExportServiceImpl;
import com.els.modules.template.excel.TemplateItemExportServiceImpl;
import com.els.modules.template.service.TemplateConfigHeadService;
import com.els.modules.template.service.TemplateConfigItemService;
import com.els.modules.template.service.TemplateGroupService;
import com.els.modules.template.service.TemplateHeadService;
import com.els.modules.template.util.ConfigPageGeneJsUtil;
import com.els.modules.template.vo.TemplateHeadVO;
import com.els.rpc.service.CoreInvokeMainDataRpcService;
import com.els.rpc.service.InvokeAccountRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import com.google.common.collect.Lists;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/template/templateHead"})
@Tag(name="\u4e1a\u52a1\u6a21\u677f\u914d\u7f6e")
public class TemplateHeadController
extends BaseController<TemplateHead, TemplateHeadService> {
    private static final Logger log = LoggerFactory.getLogger(TemplateHeadController.class);
    @Autowired
    private TemplateHeadService templateHeadService;
    @Autowired
    private TemplateGroupService templateGroupService;
    @Autowired
    private TemplateConfigHeadService templateConfigHeadService;
    @Autowired
    private TemplateConfigItemService templateConfigItemService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private InvokeAccountRpcService invokeAccountRpcService;
    @Autowired
    private CoreInvokeMainDataRpcService coreInvokeMainDataRpcService;
    @Autowired
    private RedisUtil redisUtil;
    @Value(value="${els.path.upload}")
    private String uploadpath;
    private String fileServerType = "local";
    private Pattern pattern = Pattern.compile("\\$\\{([^}]+)}");
    @Resource(name="fileStoreSignServiceImpl")
    private FileStoreSignService fileStoreSignServiceImpl;

    @Operation(summary="\u5206\u9875\u5217\u8868\u67e5\u8be2", description="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @PermissionDataView(businessType="busTemplate")
    @RequiresPermissions(value={"template#templateHead:list"})
    public Result<?> queryPageList(TemplateHead templateHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)templateHead), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        String elsAccount = StrUtil.isNotBlank((CharSequence)templateHead.getElsAccount()) ? templateHead.getElsAccount() : TenantContext.getTenant();
        queryWrapper.eq((Object)"els_account", (Object)elsAccount);
        IPage pageList = this.templateHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @Operation(summary="\u5206\u9875\u5217\u8868\u67e5\u8be2", description="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/noToken/listByBusiness"})
    public Result<?> queryPageList(@RequestParam(name="businessType") String businessType, @RequestParam(name="elsAccount", required=false) String elsAccount, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize) {
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"els_account", (Object)(StrUtil.isNotBlank((CharSequence)elsAccount) ? elsAccount : SysUtil.getLoginUser().getElsAccount()));
        queryWrapper.eq((Object)"business_type", (Object)businessType);
        queryWrapper.eq((Object)"template_status", (Object)TemplateStatusEnum.GENERATED.getValue());
        queryWrapper.lambda().orderByAsc(TemplateHead::getSortOrder);
        queryWrapper.lambda().orderByDesc(BaseEntity::getCreateTime);
        IPage pageList = this.templateHeadService.page((IPage)page, (Wrapper)queryWrapper);
        if (pageList.getRecords().isEmpty()) {
            queryWrapper.clear();
            queryWrapper.eq((Object)"els_account", (Object)SysUtil.getPurchaseAccount());
            queryWrapper.eq((Object)"business_type", (Object)businessType);
            queryWrapper.eq((Object)"template_status", (Object)TemplateStatusEnum.GENERATED.getValue());
            queryWrapper.lambda().orderByAsc(TemplateHead::getSortOrder);
            queryWrapper.lambda().orderByDesc(BaseEntity::getCreateTime);
            pageList = this.templateHeadService.page((IPage)page, (Wrapper)queryWrapper);
        }
        if (pageList.getRecords().isEmpty()) {
            queryWrapper.clear();
            queryWrapper.eq((Object)"els_account", (Object)"100000");
            queryWrapper.eq((Object)"business_type", (Object)businessType);
            queryWrapper.eq((Object)"template_status", (Object)TemplateStatusEnum.GENERATED.getValue());
            queryWrapper.lambda().orderByAsc(TemplateHead::getSortOrder);
            queryWrapper.lambda().orderByDesc(BaseEntity::getCreateTime);
            pageList = this.templateHeadService.page((IPage)page, (Wrapper)queryWrapper);
        }
        return Result.ok((Object)pageList);
    }

    @Operation(summary="\u6839\u636e\u4e1a\u52a1\u7c7b\u578b\u83b7\u53d6\u6a21\u677f\u5217\u8868", description="\u6839\u636e\u4e1a\u52a1\u7c7b\u578b\u83b7\u53d6\u6a21\u677f\u5217\u8868")
    @GetMapping(value={"/getListByType"})
    @PermissionDataView(businessType="busTemplate")
    @RequiresPermissions(value={"template#templateHead:base"})
    public Result<?> queryList(TemplateHead templateHead, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)templateHead), (Map)req.getParameterMap());
        String elsAccount = StrUtil.isNotBlank((CharSequence)templateHead.getElsAccount()) ? templateHead.getElsAccount() : TenantContext.getTenant();
        queryWrapper.eq((Object)"els_account", (Object)elsAccount);
        queryWrapper.eq((Object)"business_type", (Object)templateHead.getBusinessType());
        queryWrapper.eq((Object)"template_status", (Object)TemplateStatusEnum.GENERATED.getValue());
        queryWrapper.lambda().orderByAsc(TemplateHead::getSortOrder);
        queryWrapper.lambda().orderByDesc(BaseEntity::getCreateTime);
        List list = this.templateHeadService.list((Wrapper)queryWrapper);
        if (list.isEmpty()) {
            queryWrapper.clear();
            queryWrapper.eq((Object)"els_account", (Object)SysUtil.getPurchaseAccount());
            queryWrapper.eq((Object)"business_type", (Object)templateHead.getBusinessType());
            queryWrapper.eq((Object)"template_status", (Object)TemplateStatusEnum.GENERATED.getValue());
            queryWrapper.lambda().orderByAsc(TemplateHead::getSortOrder);
            queryWrapper.lambda().orderByDesc(BaseEntity::getCreateTime);
            list = this.templateHeadService.list((Wrapper)queryWrapper);
        }
        if (list.isEmpty()) {
            queryWrapper.clear();
            queryWrapper.eq((Object)"els_account", (Object)"100000");
            queryWrapper.eq((Object)"business_type", (Object)templateHead.getBusinessType());
            queryWrapper.eq((Object)"template_status", (Object)TemplateStatusEnum.GENERATED.getValue());
            queryWrapper.lambda().orderByAsc(TemplateHead::getSortOrder);
            queryWrapper.lambda().orderByDesc(BaseEntity::getCreateTime);
            list = this.templateHeadService.list((Wrapper)queryWrapper);
        }
        return Result.ok((Object)list);
    }

    @Operation(summary="\u6839\u636e\u4e1a\u52a1\u7c7b\u578b\u83b7\u53d6\u6a21\u677f\u5217\u8868", description="\u6839\u636e\u4e1a\u52a1\u7c7b\u578b\u83b7\u53d6\u6a21\u677f\u5217\u8868")
    @GetMapping(value={"/getListByTypeDefault"})
    @PermissionDataView(businessType="busTemplate")
    @RequiresPermissions(value={"template#templateHead:base"})
    public Result<?> queryListDefault(TemplateHead templateHead, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)templateHead), (Map)req.getParameterMap());
        String elsAccount = StrUtil.isNotBlank((CharSequence)templateHead.getElsAccount()) ? templateHead.getElsAccount() : TenantContext.getTenant();
        queryWrapper.eq((Object)"els_account", (Object)elsAccount);
        queryWrapper.eq((Object)"business_type", (Object)templateHead.getBusinessType());
        queryWrapper.eq((Object)"template_status", (Object)TemplateStatusEnum.GENERATED.getValue());
        queryWrapper.lambda().eq(TemplateHead::getDefaultType, (Object)"1");
        queryWrapper.lambda().orderByAsc(TemplateHead::getSortOrder);
        queryWrapper.lambda().orderByDesc(BaseEntity::getCreateTime);
        List list = this.templateHeadService.list((Wrapper)queryWrapper);
        if (list.isEmpty()) {
            queryWrapper.clear();
            queryWrapper.eq((Object)"els_account", (Object)SysUtil.getPurchaseAccount());
            queryWrapper.eq((Object)"business_type", (Object)templateHead.getBusinessType());
            queryWrapper.eq((Object)"template_status", (Object)TemplateStatusEnum.GENERATED.getValue());
            queryWrapper.lambda().orderByAsc(TemplateHead::getSortOrder);
            queryWrapper.lambda().orderByDesc(BaseEntity::getCreateTime);
            list = this.templateHeadService.list((Wrapper)queryWrapper);
        }
        if (list.isEmpty()) {
            queryWrapper.clear();
            queryWrapper.eq((Object)"els_account", (Object)"100000");
            queryWrapper.eq((Object)"business_type", (Object)templateHead.getBusinessType());
            queryWrapper.eq((Object)"template_status", (Object)TemplateStatusEnum.GENERATED.getValue());
            queryWrapper.lambda().orderByAsc(TemplateHead::getSortOrder);
            queryWrapper.lambda().orderByDesc(BaseEntity::getCreateTime);
            list = this.templateHeadService.list((Wrapper)queryWrapper);
        }
        return Result.ok((Object)list);
    }

    @Operation(summary="\u6839\u636e\u4e1a\u52a1\u7c7b\u578b\u83b7\u53d6\u6240\u6709\u6a21\u677f\u5217\u8868", description="\u6839\u636e\u4e1a\u52a1\u7c7b\u578b\u83b7\u53d6\u6240\u6709\u6a21\u677f\u5217\u8868")
    @GetMapping(value={"/all/getListByType"})
    @PermissionDataView(businessType="busTemplate")
    @RequiresPermissions(value={"template#templateHead:base"})
    public Result<?> queryAllList(TemplateHead templateHead, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)templateHead), (Map)req.getParameterMap());
        String elsAccount = StrUtil.isNotBlank((CharSequence)templateHead.getElsAccount()) ? templateHead.getElsAccount() : TenantContext.getTenant();
        queryWrapper.clear();
        queryWrapper.in((Object)"els_account", Arrays.asList(elsAccount, "100000"));
        queryWrapper.eq((Object)"business_type", (Object)templateHead.getBusinessType());
        queryWrapper.eq((Object)"template_status", (Object)TemplateStatusEnum.GENERATED.getValue());
        queryWrapper.lambda().orderByAsc(TemplateHead::getSortOrder);
        queryWrapper.lambda().orderByDesc(BaseEntity::getCreateTime);
        List list = this.templateHeadService.list((Wrapper)queryWrapper);
        return Result.ok((Object)list);
    }

    @Operation(summary="100000\u6570\u636e\u5206\u9875\u5217\u8868\u67e5\u8be2", description="100000\u6570\u636e\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/sysList"})
    @RequiresPermissions(value={"template#templateHead:sysList"})
    public Result<?> querySysPageList(TemplateHead templateHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)templateHead), (Map)req.getParameterMap());
        queryWrapper.eq((Object)"els_account", (Object)"100000");
        queryWrapper.lambda().eq(TemplateHead::getTemplateStatus, (Object)TemplateStatusEnum.GENERATED.getValue());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.templateHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @SrmValidated
    @AutoLog(value="\u4e1a\u52a1\u6a21\u677f-\u6dfb\u52a0")
    @Operation(summary="\u6dfb\u52a0", description="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"template#templateHead:add"})
    public Result<?> add(@RequestBody TemplateHeadVO headVO) {
        TemplateHead templateHead = new TemplateHead();
        BeanUtils.copyProperties((Object)((Object)headVO), (Object)((Object)templateHead));
        this.templateHeadService.saveMain(templateHead, headVO.getTemplateGroupList(), headVO.getTemplateConfigHeadList(), headVO.getTemplateConfigItemList());
        return Result.ok((Object)((Object)templateHead));
    }

    @AutoLog(value="\u4e1a\u52a1\u6a21\u677f-\u9009\u62e9100000\u6570\u636e\u6dfb\u52a0\u6a21\u677f")
    @Operation(summary="\u9009\u62e9100000\u6570\u636e\u6dfb\u52a0\u6a21\u677f", description="\u9009\u62e9100000\u6570\u636e\u6dfb\u52a0\u6a21\u677f")
    @GetMapping(value={"/addBy100000"})
    @RequiresPermissions(value={"template#templateHead:addBy100000"})
    public Result<?> addBy100000(@RequestParam(name="id") String id) {
        this.templateHeadService.copyById(id);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u4e1a\u52a1\u6a21\u677f-\u590d\u5236\u6a21\u677f")
    @Operation(summary="\u590d\u5236\u6a21\u677f", description="\u590d\u5236\u6a21\u677f")
    @GetMapping(value={"/copyById"})
    @RequiresPermissions(value={"template#templateHead:copyById"})
    public Result<?> copyById(@RequestParam(name="id") String id) {
        this.templateHeadService.copyById(id);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u4e1a\u52a1\u6a21\u677f-\u4f5c\u5e9f")
    @Operation(summary="\u4f5c\u5e9f", description="\u4f5c\u5e9f")
    @GetMapping(value={"/cancel"})
    @RequiresPermissions(value={"template#templateHead:cancel"})
    public Result<?> cancel(@RequestParam(name="id") String id) {
        if (!"1".equals(AdminFlagUtil.getAdminFlag())) {
            TemplateHead dbHead = (TemplateHead)((Object)this.templateHeadService.getById((Serializable)((Object)id)));
            String subAccount = this.getCurrentUser().getSubAccount();
            if (StrUtil.isNotBlank((CharSequence)dbHead.getCreateBy()) && !dbHead.getCreateBy().contains(subAccount)) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_ROkuJtcIjIr_5c8c4c66", (String)"\u53ea\u80fd\u4f5c\u5e9f\u81ea\u5df1\u521b\u5efa\u7684\u6a21\u677f!"));
            }
        }
        TemplateHead templateHead = new TemplateHead();
        templateHead.setId(id);
        templateHead.setTemplateStatus(TemplateStatusEnum.CANCEL.getValue());
        this.templateHeadService.updateById((Object)templateHead);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u4e1a\u52a1\u6a21\u677f-\u6279\u91cf\u751f\u6210\u914d\u7f6e")
    @Operation(summary="\u6279\u91cf\u751f\u6210\u914d\u7f6e", description="\u6279\u91cf\u751f\u6210\u914d\u7f6e")
    @PostMapping(value={"/batchGenerateConfig"})
    @RequiresPermissions(value={"template#templateHead:batchGenerateConfig"})
    public Result<?> batchGenerateConfig(@RequestBody List<String> templateIds) {
        Assert.isTrue((!CollectionUtil.isEmpty(templateIds) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_VRRiFImCrHcERbLW_3e9c0018", (String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u6a21\u7248\u8fdb\u884c\u914d\u7f6e\u751f\u6210\uff01"));
        List templateHeadList = this.templateHeadService.listByIds(templateIds);
        List cancelList = templateHeadList.stream().filter(x -> TemplateStatusEnum.CANCEL.getValue().equals(x.getTemplateStatus())).collect(Collectors.toList());
        templateHeadList.removeAll(cancelList);
        List newTemplateIds = templateHeadList.stream().map(ParentEntity::getId).collect(Collectors.toList());
        String cancelNumber = cancelList.stream().map(TemplateHead::getTemplateNumber).collect(Collectors.joining(","));
        if (CollUtil.isEmpty(newTemplateIds)) {
            throw new ELSBootException(cancelNumber + I18nUtil.translate((String)"i18n_alert_IrIOkur_28cc9928", (String)"\u6a21\u677f\u5df2\u7ecf\u4f5c\u5e9f\u4e86"));
        }
        Map templateGroupMap = ListColumnQueryBuilder.batchQueryByColumnListToMap(newTemplateIds, Function.identity(), TemplateGroup::getHeadId, wrapper -> this.templateGroupService.list((Wrapper)wrapper), null, (List)Lists.newArrayList((Object[])new ListColumnQueryBuilder.SortColumn[]{ListColumnQueryBuilder.SortColumn.builder(TemplateGroup::getSortOrder, (boolean)false)}));
        Map templateConfigHeadMap = ListColumnQueryBuilder.batchQueryByColumnListToMap(newTemplateIds, Function.identity(), TemplateConfigHead::getHeadId, wrapper -> this.templateConfigHeadService.list((Wrapper)wrapper), null, (List)Lists.newArrayList((Object[])new ListColumnQueryBuilder.SortColumn[]{ListColumnQueryBuilder.SortColumn.builder(TemplateConfigHead::getSortOrder, (boolean)false)}));
        Map templateConfigItemMap = ListColumnQueryBuilder.batchQueryByColumnListToMap(newTemplateIds, Function.identity(), TemplateConfigItem::getHeadId, wrapper -> this.templateConfigItemService.list((Wrapper)wrapper), null, (List)Lists.newArrayList((Object[])new ListColumnQueryBuilder.SortColumn[]{ListColumnQueryBuilder.SortColumn.builder(TemplateConfigItem::getSortOrder, (boolean)false)}));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"business_type", (Object)"enterprise");
        queryWrapper.eq((Object)"els_account", (Object)"100000");
        queryWrapper.eq((Object)"is_default_type", (Object)"1");
        List headList = this.templateHeadService.list((Wrapper)queryWrapper);
        ArrayList successIds = Lists.newArrayList();
        ArrayList cacheKeys = Lists.newArrayList();
        for (TemplateHead templateHead : templateHeadList) {
            TemplateHeadVO headVO = new TemplateHeadVO();
            BeanUtils.copyProperties((Object)((Object)templateHead), (Object)((Object)headVO));
            headVO.setTemplateConfigHeadList((List)ObjectUtil.defaultIfNull((Object)((List)templateConfigHeadMap.get(templateHead.getId())), (Object)Lists.newArrayList()));
            headVO.setTemplateConfigItemList((List)ObjectUtil.defaultIfNull((Object)((List)templateConfigItemMap.get(templateHead.getId())), (Object)Lists.newArrayList()));
            headVO.setTemplateGroupList((List)ObjectUtil.defaultIfNull((Object)((List)templateGroupMap.get(templateHead.getId())), (Object)Lists.newArrayList()));
            if ("supplierMasterData".equals(headVO.getBusinessType())) {
                List<TemplateGroup> supplierMasterDataTemplateGroupList = headVO.getTemplateGroupList();
                if (!supplierMasterDataTemplateGroupList.isEmpty() && supplierMasterDataTemplateGroupList.size() > 0) {
                    Object trag = false;
                    for (TemplateGroup group : supplierMasterDataTemplateGroupList) {
                        if (!"enterpriseForm".equals(group.getGroupCode())) continue;
                        trag = true;
                        break;
                    }
                    if (!((Boolean)trag).booleanValue()) {
                        this.supplierMasterDataTemplateDealOnBatch(headList, headVO);
                    }
                } else {
                    this.supplierMasterDataTemplateDealOnBatch(headList, headVO);
                }
                for (TemplateConfigHead templateConfigHead : headVO.getTemplateConfigHeadList()) {
                    if (!"enterpriseForm".equals(templateConfigHead.getGroupCode())) continue;
                    if ("elsAccount".equals(templateConfigHead.getFieldName())) {
                        templateConfigHead.setFieldName("toElsAccount");
                    }
                    if (!"toElsAccount".equals(templateConfigHead.getFieldName()) && !"name".equals(templateConfigHead.getFieldName())) continue;
                    templateConfigHead.setPurchaseEdit("0");
                    templateConfigHead.setSaleEdit("0");
                }
            }
            this.setCompute(headVO.getTemplateConfigItemList());
            String savePathDir = this.uploadpath + File.separator + "js" + File.separator + TenantContext.getTenant();
            try {
                ConfigPageGeneJsUtil.generatorJs(savePathDir, headVO);
                successIds.add(headVO.getId());
                StringBuilder redisKey = new StringBuilder("srm:template:").append(this.getTenantId()).append(":").append(headVO.getTemplateNumber()).append(":").append(headVO.getTemplateVersion());
                cacheKeys.add(redisKey.toString());
            }
            catch (Exception e) {
                log.error(":::\u4e1a\u52a1\u6a21\u677f\u751f\u6210\u5f02\u5e38,id:{}===>{}", (Object)headVO.getId(), (Object)e.getMessage());
            }
        }
        if (CollUtil.isEmpty((Collection)successIds)) {
            throw new ELSBootException(cancelNumber + I18nUtil.translate((String)"i18n_alert_IrbLKm_32d4d23", (String)"\u6a21\u677f\u751f\u6210\u5931\u8d25!"));
        }
        LambdaUpdateWrapper updateWrapper = Wrappers.lambdaUpdate();
        ((LambdaUpdateWrapper)updateWrapper.set(TemplateHead::getTemplateStatus, (Object)TemplateStatusEnum.GENERATED.getValue())).in(ParentEntity::getId, (Collection)successIds);
        this.templateHeadService.update((Wrapper)updateWrapper);
        this.redisUtil.del(cacheKeys.toArray(new String[0]));
        Object msg = "\u6279\u91cf\u751f\u6210\u914d\u7f6e\u6210\u529f";
        if (StrUtil.isNotEmpty((CharSequence)cancelNumber)) {
            msg = (String)msg + "\uff0c\u5176\u4e2d" + cancelNumber + "\u5df2\u7ecf\u4f5c\u5e9f";
        }
        return Result.ok((String)msg);
    }

    @AutoLog(value="\u4e1a\u52a1\u6a21\u677f-\u751f\u6210\u914d\u7f6e")
    @SrmValidated
    @Operation(summary="\u751f\u6210\u914d\u7f6e", description="\u751f\u6210\u914d\u7f6e")
    @PostMapping(value={"/generateConfig"})
    @RequiresPermissions(value={"template#templateHead:generateConfig"})
    public Result<?> generateConfig(@RequestBody TemplateHeadVO headVO) {
        TemplateHead templateHead = new TemplateHead();
        BeanUtils.copyProperties((Object)((Object)headVO), (Object)((Object)templateHead));
        templateHead.setTemplateStatus(TemplateStatusEnum.GENERATED.getValue());
        if (StrUtil.isBlank((CharSequence)templateHead.getId())) {
            templateHead.setTemplateStatus(TemplateStatusEnum.GENERATED.getValue());
            this.templateHeadService.saveMain(templateHead, headVO.getTemplateGroupList(), headVO.getTemplateConfigHeadList(), headVO.getTemplateConfigItemList());
            headVO.setTemplateNumber(templateHead.getTemplateNumber());
            headVO.setTemplateVersion(templateHead.getTemplateVersion());
        } else {
            templateHead.setTemplateStatus(TemplateStatusEnum.GENERATED.getValue());
            this.templateHeadService.updateMain(templateHead, headVO.getTemplateGroupList(), headVO.getTemplateConfigHeadList(), headVO.getTemplateConfigItemList());
        }
        if ("supplierMasterData".equals(headVO.getBusinessType())) {
            List<TemplateGroup> supplierMasterDataTemplateGroupList = headVO.getTemplateGroupList();
            if (!supplierMasterDataTemplateGroupList.isEmpty() && supplierMasterDataTemplateGroupList.size() > 0) {
                Object trag = false;
                for (TemplateGroup group : supplierMasterDataTemplateGroupList) {
                    if (!"enterpriseForm".equals(group.getGroupCode())) continue;
                    trag = true;
                    break;
                }
                if (!((Boolean)trag).booleanValue()) {
                    this.supplierMasterDataTemplateDeal(headVO);
                }
            } else {
                this.supplierMasterDataTemplateDeal(headVO);
            }
            for (TemplateConfigHead templateConfigHead : headVO.getTemplateConfigHeadList()) {
                if (!"enterpriseForm".equals(templateConfigHead.getGroupCode())) continue;
                if ("elsAccount".equals(templateConfigHead.getFieldName())) {
                    templateConfigHead.setFieldName("toElsAccount");
                }
                if (!"toElsAccount".equals(templateConfigHead.getFieldName()) && !"name".equals(templateConfigHead.getFieldName())) continue;
                templateConfigHead.setPurchaseEdit("0");
                templateConfigHead.setSaleEdit("0");
            }
        }
        this.setCompute(headVO.getTemplateConfigItemList());
        String savePathDir = this.uploadpath + File.separator + "js" + File.separator + TenantContext.getTenant();
        if (headVO.getTemplateVersion() == null) {
            headVO.setTemplateVersion(1);
        }
        this.fileStoreSignServiceImpl.generatorJs(savePathDir, headVO, this.fileServerType);
        if (this.redisUtil.hasKey("dictTemplate_" + templateHead.getElsAccount() + "_" + templateHead.getTemplateNumber() + "_" + templateHead.getTemplateVersion() + "_head")) {
            this.redisUtil.del(new String[]{"dictTemplate_" + templateHead.getElsAccount() + "_" + templateHead.getTemplateNumber() + "_" + templateHead.getTemplateVersion() + "_head"});
            this.redisUtil.del(new String[]{"dictTemplate_" + templateHead.getElsAccount() + "_" + templateHead.getTemplateNumber() + "_" + templateHead.getTemplateVersion() + "_item"});
        }
        StringBuilder redisKey = new StringBuilder("srm:template:").append(this.getTenantId()).append(":").append(headVO.getTemplateNumber()).append(":").append(headVO.getTemplateVersion());
        this.redisUtil.del(new String[]{redisKey.toString()});
        return Result.ok((Object)((Object)templateHead));
    }

    public void supplierMasterDataTemplateDeal(@RequestBody TemplateHeadVO headVO) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"business_type", (Object)"enterprise");
        queryWrapper.eq((Object)"els_account", (Object)"100000");
        queryWrapper.eq((Object)"is_default_type", (Object)"1");
        List headList = this.templateHeadService.list((Wrapper)queryWrapper);
        if (!headList.isEmpty()) {
            String id = ((TemplateHead)((Object)headList.get(0))).getId();
            List<TemplateGroup> templateGroupList = this.templateGroupService.selectByMainId(id);
            templateGroupList.addAll(headVO.getTemplateGroupList());
            headVO.setTemplateGroupList(templateGroupList);
            List<TemplateConfigHead> templateConfigHeadList = this.templateConfigHeadService.selectByMainId(id);
            for (TemplateConfigHead templateConfigHead : templateConfigHeadList) {
                if (templateConfigHead.getFieldName().equals("elsAccount")) {
                    templateConfigHead.setFieldName("toElsAccount");
                }
                templateConfigHead.setPurchaseEdit("0");
                templateConfigHead.setSaleEdit("0");
            }
            templateConfigHeadList.addAll(headVO.getTemplateConfigHeadList());
            headVO.setTemplateConfigHeadList(templateConfigHeadList);
        }
    }

    public void supplierMasterDataTemplateDealOnBatch(List<TemplateHead> headList, TemplateHeadVO headVO) {
        if (!headList.isEmpty()) {
            String id = headList.get(0).getId();
            ArrayList templateGroupList = Lists.newArrayList(this.templateGroupService.selectByMainId(id));
            templateGroupList.addAll(headVO.getTemplateGroupList());
            headVO.setTemplateGroupList(templateGroupList);
            ArrayList templateConfigHeadList = Lists.newArrayList(this.templateConfigHeadService.selectByMainId(id));
            for (TemplateConfigHead templateConfigHead : templateConfigHeadList) {
                if (templateConfigHead.getFieldName().equals("elsAccount")) {
                    templateConfigHead.setFieldName("toElsAccount");
                }
                templateConfigHead.setPurchaseEdit("0");
                templateConfigHead.setSaleEdit("0");
            }
            templateConfigHeadList.addAll(headVO.getTemplateConfigHeadList());
            headVO.setTemplateConfigHeadList(templateConfigHeadList);
        }
    }

    private void setCompute(List<TemplateConfigItem> itemList) {
        if (CollectionUtil.isNotEmpty(itemList)) {
            List formulaList = itemList.stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getFormula())).collect(Collectors.toList());
            HashMap<String, Boolean> computeMap = new HashMap<String, Boolean>();
            for (TemplateConfigItem item2 : formulaList) {
                Matcher matcher = this.pattern.matcher(item2.getFormula());
                while (matcher.find()) {
                    computeMap.put(matcher.group(1), true);
                }
            }
            for (TemplateConfigItem item2 : itemList) {
                if (computeMap.get(item2.getFieldName()) == null || !((Boolean)computeMap.get(item2.getFieldName())).booleanValue()) continue;
                item2.setCompute("1");
            }
        }
    }

    @FormCommit
    @AutoLog(value="\u4e1a\u52a1\u6a21\u677f-\u5347\u7ea7\u7248\u672c")
    @Operation(summary="\u5347\u7ea7\u7248\u672c", description="\u5347\u7ea7\u7248\u672c")
    @GetMapping(value={"/upgradeVersion"})
    @RequiresPermissions(value={"template#templateHead:upgradeVersion"})
    public Result<?> upgradeVersion(@RequestParam(name="id") String id) {
        this.templateHeadService.upgradeVersion(id);
        return this.commonSuccessResult(3);
    }

    @SrmValidated
    @AutoLog(value="\u4e1a\u52a1\u6a21\u677f-\u7f16\u8f91")
    @Operation(summary="\u7f16\u8f91", description="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"template#templateHead:edit"})
    public Result<?> edit(@RequestBody TemplateHeadVO templateHeadPage) {
        TemplateHead templateHead = new TemplateHead();
        BeanUtils.copyProperties((Object)((Object)templateHeadPage), (Object)((Object)templateHead));
        this.templateHeadService.updateMain(templateHead, templateHeadPage.getTemplateGroupList(), templateHeadPage.getTemplateConfigHeadList(), templateHeadPage.getTemplateConfigItemList());
        return Result.ok((Object)((Object)templateHead));
    }

    @AutoLog(value="\u4e1a\u52a1\u6a21\u677f-\u901a\u8fc7id\u5220\u9664")
    @Operation(summary="\u901a\u8fc7id\u5220\u9664", description="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"template#templateHead:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.templateHeadService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @Operation(summary="\u901a\u8fc7id\u67e5\u8be2", description="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"template#templateHead:queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        TemplateHead templateHead = (TemplateHead)((Object)this.templateHeadService.getById((Serializable)((Object)id)));
        TemplateHeadVO templateHeadVO = new TemplateHeadVO();
        BeanUtils.copyProperties((Object)((Object)templateHead), (Object)((Object)templateHeadVO));
        List<TemplateGroup> templateGroupList = this.templateGroupService.selectByMainId(id);
        templateHeadVO.setTemplateGroupList(templateGroupList);
        List<TemplateConfigHead> templateConfigHeadList = this.templateConfigHeadService.selectByMainId(id);
        templateHeadVO.setTemplateConfigHeadList(templateConfigHeadList);
        List<TemplateConfigItem> templateConfigItemList = this.templateConfigItemService.selectByMainId(id);
        templateHeadVO.setTemplateConfigItemList(templateConfigItemList);
        List purchaseAttachmentList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id);
        templateHeadVO.setPurchaseAttachmentList(purchaseAttachmentList);
        return Result.ok((Object)((Object)templateHeadVO));
    }

    @AutoLog(value="\u4e1a\u52a1\u6a21\u677f-\u5bfc\u51fa")
    @GetMapping(value={"/exportJson"})
    @RequiresPermissions(value={"template#templateHead:exportJson"})
    public Result<?> exportJson(TemplateHead templateHead, HttpServletRequest req, HttpServletResponse res) throws Exception {
        this.templateHeadService.exportJson(templateHead, req, res);
        return Result.ok((String)"\u5bfc\u51fa\u6210\u529f");
    }

    @AutoLog(value="\u4e1a\u52a1\u6a21\u677f-\u5bfc\u5165")
    @PostMapping(value={"/importJson"})
    @RequiresPermissions(value={"template#templateHead:importJson"})
    public Result<?> importJson(HttpServletRequest req) {
        try {
            int ch;
            MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)req;
            Map fileMap = multipartRequest.getFileMap();
            MultipartFile file = (MultipartFile)fileMap.get("file");
            InputStream inputStream = file.getInputStream();
            InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
            StringBuffer stringBuffer = new StringBuffer();
            while ((ch = ((Reader)reader).read()) != -1) {
                stringBuffer.append((char)ch);
            }
            ((Reader)reader).close();
            int length = stringBuffer.length();
            if (length == 0) {
                return Result.error((String)I18nUtil.translate((String)"i18n_alert_uNWFxOLV_bb53e337", (String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a!"));
            }
            String jsonString = stringBuffer.toString();
            List headVOList = JSON.parseArray((String)jsonString, TemplateHeadVO.class);
            if (headVOList.isEmpty()) {
                return Result.error((String)I18nUtil.translate((String)"i18n_alert_uNWFxOLV_bb53e337", (String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a!"));
            }
            this.templateHeadService.importJson(headVOList);
        }
        catch (Exception e) {
            log.error("\u5bfc\u5165Json\u6570\u636e\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
            return Result.error((String)I18nUtil.translate((String)"i18n_alert_importJson_errorText", (String)"\u6587\u4ef6\u683c\u5f0f\u6709\u8bef\u6216\u8005\u6587\u4ef6\u7684json\u6570\u636e\u538b\u7f29\u6709\u8bef\uff0cjson\u8f6c\u4e49\u5931\u8d25!"));
        }
        return Result.ok();
    }

    @Operation(summary="\u901a\u8fc7\u4e1a\u52a1\u7f16\u7801\u67e5\u8be2100000\u53f7\u914d\u7f6e\u7cfb\u7edf\u7ea7\u4fe1\u606f", description="\u901a\u8fc7\u4e1a\u52a1\u7f16\u7801\u67e5\u8be2100000\u53f7\u914d\u7f6e\u7cfb\u7edf\u7ea7\u4fe1\u606f")
    @GetMapping(value={"/querySysByBusinessType"})
    @RequiresPermissions(value={"template#templateHead:add"})
    public Result<?> querySysByBusinessType(@RequestParam(name="businessType") String businessType) {
        List<TemplateConfigItem> templateConfigItemList;
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"business_type", (Object)businessType);
        queryWrapper.eq((Object)"els_account", (Object)"100000");
        queryWrapper.eq((Object)"is_default_type", (Object)"1");
        List headList = this.templateHeadService.list((Wrapper)queryWrapper);
        if (headList.isEmpty()) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_LYuWWWWWWERAcWWWWWWWjWF_504c6e16", (String)"\u672a\u627e\u5230100000\u914d\u7f6e\u7c7b\u578b\uff1a[${0}]\u7684\u6570\u636e", (String[])new String[]{businessType}));
        }
        String id = ((TemplateHead)((Object)headList.get(0))).getId();
        TemplateHead templateHead = (TemplateHead)((Object)this.templateHeadService.getById((Serializable)((Object)id)));
        TemplateHeadVO templateHeadVO = new TemplateHeadVO();
        BeanUtils.copyProperties((Object)((Object)templateHead), (Object)((Object)templateHeadVO));
        List<TemplateGroup> templateGroupList = this.templateGroupService.selectByMainId(id);
        templateHeadVO.setTemplateGroupList(templateGroupList);
        List<TemplateConfigHead> templateConfigHeadList = this.templateConfigHeadService.selectByMainId(id);
        if (!templateConfigHeadList.isEmpty()) {
            List<TemplateConfigHead> configHeadList = templateConfigHeadList.parallelStream().filter(vo -> "1".equals(vo.getSys())).collect(Collectors.toList());
            templateHeadVO.setTemplateConfigHeadList(configHeadList);
        }
        if (!(templateConfigItemList = this.templateConfigItemService.selectByMainId(id)).isEmpty()) {
            List<TemplateConfigItem> configItemList = templateConfigItemList.parallelStream().filter(vo -> "1".equals(vo.getSys())).collect(Collectors.toList());
            templateHeadVO.setTemplateConfigItemList(configItemList);
        }
        return Result.ok((Object)((Object)templateHeadVO));
    }

    @Operation(summary="\u901a\u8fc7\u4e1a\u52a1\u7f16\u7801\u67e5\u8be2100000\u53f7\u914d\u7f6e\u8868\u5934\u5b57\u6bb5\uff08\u9664\u7cfb\u7edf\u7ea7\u5b57\u6bb5\u5916\uff09", description="\u901a\u8fc7\u4e1a\u52a1\u7f16\u7801\u67e5\u8be2100000\u53f7\u914d\u7f6e\u8868\u5934\u5b57\u6bb5\uff08\u9664\u7cfb\u7edf\u7ea7\u5b57\u6bb5\u5916\uff09")
    @GetMapping(value={"/queryHeadFieldsByBusinessType"})
    @RequiresPermissions(value={"template#templateHead:base"})
    public Result<?> queryHeadFieldsByBusinessType(@RequestParam(name="businessType") String businessType) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"business_type", (Object)businessType);
        queryWrapper.eq((Object)"is_default_type", (Object)"1");
        queryWrapper.eq((Object)"els_account", (Object)"100000");
        List headList = this.templateHeadService.list((Wrapper)queryWrapper);
        if (headList.isEmpty()) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_LYuWWWWWWERAcWWWWWWWjWF_504c6e16", (String)"\u672a\u627e\u5230100000\u914d\u7f6e\u7c7b\u578b\uff1a[${0}],\u6a21\u677f\u540d\u4e3a\uff1a\u6807\u51c6\u7c7b\u578b\u7684\u914d\u7f6e", (String[])new String[]{businessType}));
        }
        String id = ((TemplateHead)((Object)headList.get(0))).getId();
        TemplateHead templateHead = (TemplateHead)((Object)this.templateHeadService.getById((Serializable)((Object)id)));
        TemplateHeadVO templateHeadVO = new TemplateHeadVO();
        BeanUtils.copyProperties((Object)((Object)templateHead), (Object)((Object)templateHeadVO));
        List<TemplateConfigHead> templateConfigHeadList = this.templateConfigHeadService.selectByMainId(id);
        if (!templateConfigHeadList.isEmpty()) {
            List<TemplateConfigHead> configHeadList = templateConfigHeadList.parallelStream().filter(vo -> !"1".equals(vo.getSys())).collect(Collectors.toList());
            templateHeadVO.setTemplateConfigHeadList(configHeadList);
        }
        return Result.ok((Object)((Object)templateHeadVO));
    }

    @Operation(summary="\u901a\u8fc7\u4e1a\u52a1\u7f16\u7801\u67e5\u8be2100000\u53f7\u914d\u7f6e\u8868\u884c\u5b57\u6bb5\uff08\u9664\u7cfb\u7edf\u7ea7\u5b57\u6bb5\u5916\uff09", description="\u901a\u8fc7\u4e1a\u52a1\u7f16\u7801\u67e5\u8be2100000\u53f7\u914d\u7f6e\u8868\u884c\u5b57\u6bb5\uff08\u9664\u7cfb\u7edf\u7ea7\u5b57\u6bb5\u5916\uff09")
    @GetMapping(value={"/queryItemFieldsByBusinessType"})
    @RequiresPermissions(value={"template#templateHead:base"})
    public Result<?> queryItemFieldsByBusinessType(@RequestParam(name="businessType") String businessType) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"business_type", (Object)businessType);
        queryWrapper.eq((Object)"is_default_type", (Object)"1");
        queryWrapper.eq((Object)"els_account", (Object)"100000");
        List headList = this.templateHeadService.list((Wrapper)queryWrapper);
        if (headList.isEmpty()) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_LYu100000ERAc[0]IrRLBrAcjER_f16379c7", (String)"\u672a\u627e\u5230100000\u914d\u7f6e\u7c7b\u578b\uff1a[${0}],\u6a21\u677f\u540d\u4e3a\uff1a\u6807\u51c6\u7c7b\u578b\u7684\u914d\u7f6e", (String[])new String[]{businessType}));
        }
        String id = ((TemplateHead)((Object)headList.get(0))).getId();
        TemplateHead templateHead = (TemplateHead)((Object)this.templateHeadService.getById((Serializable)((Object)id)));
        TemplateHeadVO templateHeadVO = new TemplateHeadVO();
        BeanUtils.copyProperties((Object)((Object)templateHead), (Object)((Object)templateHeadVO));
        List<TemplateConfigItem> templateConfigItemList = this.templateConfigItemService.selectByMainId(id);
        templateHeadVO.setTemplateConfigItemList(templateConfigItemList);
        return Result.ok((Object)((Object)templateHeadVO));
    }

    @Operation(summary="\u901a\u8fc7\u4e1a\u52a1\u6a21\u677f\u914d\u7f6eid\u67e5\u8be2\u4e1a\u52a1\u6a21\u677f\u5206\u7ec4", description="\u901a\u8fc7\u4e1a\u52a1\u6a21\u677f\u914d\u7f6eid\u67e5\u8be2\u4e1a\u52a1\u6a21\u677f\u5206\u7ec4")
    @GetMapping(value={"/queryTemplateGroupByMainId"})
    @RequiresPermissions(value={"template#templateHead:base"})
    public Result<?> queryTemplateGroupListByMainId(@RequestParam(name="id") String id) {
        List<TemplateGroup> templateGroupList = this.templateGroupService.selectByMainId(id);
        return Result.ok(templateGroupList);
    }

    @Operation(summary="\u901a\u8fc7\u4e1a\u52a1\u6a21\u677f\u914d\u7f6eid\u67e5\u8be2\u4e1a\u52a1\u6a21\u677f\u914d\u7f6e\u4fe1\u606f\u8868", description="\u901a\u8fc7\u4e1a\u52a1\u6a21\u677f\u914d\u7f6eid\u67e5\u8be2\u4e1a\u52a1\u6a21\u677f\u914d\u7f6e\u4fe1\u606f\u8868")
    @GetMapping(value={"/queryTemplateConfigHeadByMainId"})
    @RequiresPermissions(value={"template#templateHead:base"})
    public Result<?> queryTemplateConfigHeadListByMainId(@RequestParam(name="id") String id) {
        List<TemplateConfigHead> templateConfigHeadList = this.templateConfigHeadService.selectByMainId(id);
        return Result.ok(templateConfigHeadList);
    }

    @Operation(summary="\u901a\u8fc7\u4e1a\u52a1\u6a21\u677f\u914d\u7f6eid\u67e5\u8be2\u4e1a\u52a1\u6a21\u677f\u914d\u7f6e\u884c\u4fe1\u606f\u8868", description="\u901a\u8fc7\u4e1a\u52a1\u6a21\u677f\u914d\u7f6eid\u67e5\u8be2\u4e1a\u52a1\u6a21\u677f\u914d\u7f6e\u884c\u4fe1\u606f\u8868")
    @GetMapping(value={"/queryTemplateConfigItemByMainId"})
    @RequiresPermissions(value={"template#templateHead:base"})
    public Result<?> queryTemplateConfigItemListByMainId(@RequestParam(name="id") String id) {
        List<TemplateConfigItem> templateConfigItemList = this.templateConfigItemService.selectByMainId(id);
        return Result.ok(templateConfigItemList);
    }

    @GetMapping(value={"/addTempleI18nKey"})
    @RequiresPermissions(value={"template#templateHead:addTempleI18nKey"})
    public Result<?> addTempleI18nKey() {
        this.templateHeadService.addTempleI18nKey();
        return this.commonSuccessResult(3);
    }

    @PostMapping(value={"/exportTemplateColumnConfig"})
    @RequiresPermissions(value={"template#templateHead:exportJson"})
    public ModelAndView exportHead(@RequestParam(value="headId") String headId, @RequestParam(value="type") String type, HttpServletRequest req, HttpServletResponse res) throws Exception {
        HashMap<String, String> object = new HashMap<String, String>();
        object.put("headId", headId);
        if ("head".equals(type)) {
            return super.exportXls(req, object, TemplateHeadExportServiceImpl.class);
        }
        return super.exportXls(req, object, TemplateItemExportServiceImpl.class);
    }

    @Operation(summary="\u83b7\u53d6\u6a21\u677fjs", description="\u83b7\u53d6\u6a21\u677fjs")
    @GetMapping(value={"/getTemplate.js"})
    public void getTemplate(@RequestParam(name="templateNumber") String templateNumber, @RequestParam(name="templateVersion") String templateVersion, @RequestParam(name="templateType") String templateType, @RequestParam(name="businessType") String businessType, @RequestParam(name="purchaseAccount") String purchaseAccount, @RequestParam(name="templateAccount") String templateAccount, HttpServletResponse response) {
        String savePathDir = this.uploadpath + File.separator + "js" + File.separator + templateAccount;
        String jsPath = savePathDir + File.separator + templateType + "_" + businessType + "_" + templateNumber + "_" + templateVersion + ".js";
        try (ServletOutputStream outputStream = response.getOutputStream();
             BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(jsPath));){
            response.setContentType("application/javascript; charset=utf-8");
            response.setHeader("X-Content-Type-Options", "nosniff");
            response.setHeader("X-Frame-Options", "SAMEORIGIN");
            response.setHeader("X-Xss-Protection", "1; mode=block");
            String jsContent = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            TemplateHeadVO template = ((TemplateHeadService)this.service).getAllConfig(templateAccount, templateNumber, templateVersion);
            List<TemplateConfigHead> templateConfigHeadList = template.getTemplateConfigHeadList();
            List<TemplateConfigItem> templateConfigItemList = template.getTemplateConfigItemList();
            List<String> headDictCodeList = templateConfigHeadList.parallelStream().map(TemplateConfigHead::getDictCode).filter(CharSequenceUtil::isNotBlank).distinct().toList();
            List<String> itemDictCodeList = templateConfigItemList.parallelStream().map(TemplateConfigItem::getDictCode).filter(CharSequenceUtil::isNotBlank).distinct().toList();
            List allDictCodeList = Stream.concat(headDictCodeList.stream(), itemDictCodeList.stream()).distinct().toList();
            if (CollectionUtil.isNotEmpty(allDictCodeList)) {
                for (String dictCode : allDictCodeList) {
                    String target = "[" + dictCode + "]";
                    JSONArray replacement = new JSONArray();
                    if (PurchaseOrgCategoryStatus.isOrg((String)dictCode)) {
                        List orgInfoList = ((PurchaseOrganizationInfoRpcService)SrmRpcUtil.getExecuteServiceImpl(PurchaseOrganizationInfoRpcService.class)).listByCategoryCode(purchaseAccount, dictCode);
                        for (PurchaseOrganizationInfoDTO info : orgInfoList) {
                            object = new JSONObject();
                            object.put("value", (Object)info.getOrgCode());
                            object.put("label", (Object)I18nUtil.translate((String)"", (String)info.getOrgName()));
                            replacement.add((Object)object);
                        }
                    } else {
                        List<DictItem> dictItemList = ((DictServiceImpl)SpringContextUtils.getBean(DictServiceImpl.class)).getItemListByCode(purchaseAccount, dictCode);
                        for (DictItem item : dictItemList) {
                            object = new JSONObject();
                            object.put("value", (Object)item.getItemValue());
                            object.put("label", (Object)I18nUtil.translate((String)item.getItemTextI18nKey(), (String)item.getItemText()));
                            replacement.add((Object)object);
                        }
                    }
                    jsContent = jsContent.replace(target, replacement.toJSONString());
                }
            }
            List<String> headDefaultValueList = templateConfigHeadList.parallelStream().map(TemplateConfigHead::getDefaultValue).filter(CharSequenceUtil::isNotBlank).filter(defaultValue -> defaultValue.startsWith("{{") && defaultValue.endsWith("}}")).distinct().toList();
            List<String> itemDefaultValueList = templateConfigItemList.parallelStream().map(TemplateConfigItem::getDefaultValue).filter(CharSequenceUtil::isNotBlank).filter(defaultValue -> defaultValue.startsWith("{{") && defaultValue.endsWith("}}")).distinct().toList();
            List allDefaultValueList = Stream.concat(headDefaultValueList.stream(), itemDefaultValueList.stream()).distinct().toList();
            LoginUserDTO user = LoginUserContext.getUser();
            if (user != null) {
                List<SubAccountOrgDTO> accountOrgList = this.getAccountOrgList(user.getId());
                for (String defaultValue2 : allDefaultValueList) {
                    String trim = defaultValue2.substring(2, defaultValue2.length() - 2).trim();
                    Optional<SubAccountOrgDTO> first = accountOrgList.stream().filter(accountOrg -> trim.equals(accountOrg.getOrgCategoryCode())).findFirst();
                    jsContent = jsContent.replace(defaultValue2, first.isPresent() ? first.get().getOrgCode() : "");
                }
            } else {
                for (String defaultValue3 : allDefaultValueList) {
                    jsContent = jsContent.replace(defaultValue3, "");
                }
            }
            outputStream.write(jsContent.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6js\u6a21\u677f\u5931\u8d25", (Throwable)e);
            throw new ELSBootException("\u83b7\u53d6js\u6a21\u677f\u5931\u8d25:" + e.getMessage());
        }
    }

    private List<SubAccountOrgDTO> getAccountOrgList(String id) {
        String redisKey = RedisKeyUtil.getAccountOrgListRedisKey((String)id);
        List<Object> accountOrgList = (ArrayList<SubAccountOrgDTO>)this.redisUtil.get(redisKey);
        if (accountOrgList != null) {
            return accountOrgList;
        }
        accountOrgList = this.invokeAccountRpcService.getSubAccountOrgList(id);
        if (CollectionUtil.isEmpty((Collection)accountOrgList)) {
            accountOrgList = new ArrayList<SubAccountOrgDTO>();
        }
        this.redisUtil.set(redisKey, accountOrgList);
        return accountOrgList;
    }

    @Operation(summary="\u83b7\u53d6\u6a21\u677fjs", description="\u83b7\u53d6\u6a21\u677fjs")
    @GetMapping(value={"/noToken/getTemplate.js"})
    public void getNoTokenTemplate(@RequestParam(name="templateNumber") String templateNumber, @RequestParam(name="templateVersion") String templateVersion, @RequestParam(name="templateType") String templateType, @RequestParam(name="businessType") String businessType, @RequestParam(name="purchaseAccount") String purchaseAccount, @RequestParam(name="templateAccount") String templateAccount, HttpServletResponse response) {
        ArrayList businessTypeList = Lists.newArrayList((Object[])new String[]{"enquiry", "ebidding", "bidding"});
        Assert.isTrue((boolean)businessTypeList.contains(businessType), (String)I18nUtil.translate((String)"\u8be5\u6a21\u677f\u4e0d\u53ef\u7528"));
        this.getTemplate(templateNumber, templateVersion, templateType, businessType, purchaseAccount, templateAccount, response);
    }

    @GetMapping(value={"/modelTemplateList/{businessType}"})
    public Result<?> modelTemplateList(@PathVariable(value="businessType") String businessType) throws Exception {
        List templateList = this.invokeBaseRpcService.getDefaultTemplateByType(businessType);
        Assert.notEmpty((Collection)templateList, (String)I18nUtil.translate((String)"", (String)"\u8bf7\u5148\u914d\u7f6e\u4e1a\u52a1\u6a21\u677f\u3002"));
        TemplateHeadDTO templateHeadDTO = (TemplateHeadDTO)templateList.get(0);
        templateHeadDTO = this.invokeBaseRpcService.getTemplateConfig(templateHeadDTO.getElsAccount(), templateHeadDTO.getTemplateNumber(), "" + templateHeadDTO.getTemplateVersion());
        List templateConfigHeadList = templateHeadDTO.getTemplateConfigHeadList();
        List templateConfigItemList = templateHeadDTO.getTemplateConfigItemList();
        List templateConfigHeadDTOS = Convert.toList(TemplateConfigHeadDTO.class, (Object)templateConfigItemList);
        templateConfigHeadList.addAll(templateConfigHeadDTOS);
        templateConfigHeadList = templateConfigHeadList.stream().filter(x -> !x.getFieldName().contains("fbk")).collect(Collectors.collectingAndThen(Collectors.toMap(TemplateConfigHeadDTO::getFieldName, Function.identity(), (v1, v2) -> v1, LinkedHashMap::new), map -> new ArrayList(map.values())));
        return Result.ok((Object)templateConfigHeadList);
    }
}

