/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ai.core.helper;

import com.els.modules.ai.core.helper.AiChatResponseHelper;
import com.els.modules.ai.pojo.AiChatExamplarPojo;
import com.els.modules.ai.pojo.LlmChatResponsePojo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SimpleResponseHelper
extends AiChatResponseHelper {
    private static final Logger log = LoggerFactory.getLogger(SimpleResponseHelper.class);

    @Override
    public String responseHelperType() {
        return "simpleResponseHelper";
    }

    @Override
    public Pair<String, Map<String, Double>> selfConsistencyVote(List<String> outputList) {
        HashMap<String, Integer> inputCounts = new HashMap<String, Integer>();
        for (String input : outputList) {
            inputCounts.put(input, inputCounts.getOrDefault(input, 0) + 1);
        }
        String inputMax = null;
        int maxCount = 0;
        int inputSize = outputList.size();
        HashMap<String, Double> votePercentage = new HashMap<String, Double>();
        for (Map.Entry entry : inputCounts.entrySet()) {
            String input = (String)entry.getKey();
            int count = (Integer)entry.getValue();
            if (count > maxCount) {
                inputMax = input;
                maxCount = count;
            }
            double percentage = (double)count / (double)inputSize;
            votePercentage.put(input, percentage);
        }
        return Pair.of(inputMax, votePercentage);
    }

    @Override
    public Map<String, LlmChatResponsePojo> buildResponseMap(List<AiChatExamplarPojo> sqlExamples, Map<String, Double> outputMap) {
        if (outputMap == null) {
            return new HashMap<String, LlmChatResponsePojo>();
        }
        return outputMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> LlmChatResponsePojo.builder().weight(((Double)entry.getValue()).doubleValue()).fewShots(sqlExamples).build()));
    }
}

