/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ai.core.modelStrategy;

import cn.hutool.core.util.StrUtil;
import com.els.common.exception.ELSBootException;
import com.els.modules.ai.core.helper.AiChatPromptHelper;
import com.els.modules.ai.core.provider.AiModelFactory;
import com.els.modules.ai.core.util.AiBeanFactory;
import com.els.modules.ai.pojo.AiChatModelConfigPojo;
import com.els.modules.ai.pojo.LlmRequestPojo;
import com.els.modules.ai.pojo.LlmResponsePojo;
import dev.langchain4j.model.chat.ChatLanguageModel;
import javax.annotation.Resource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public abstract class AiLogicRunStrategy
implements InitializingBean {
    @Resource
    protected AiChatPromptHelper promptHelper;
    protected static final String _SYS_INPUT_REPLACE_ = "_SYS_INPUT_REPLACE_";

    abstract String modelRunStrategy();

    public void afterPropertiesSet() throws Exception {
        AiBeanFactory.registerAiLogicRunStrategy(this.modelRunStrategy(), this);
    }

    protected ChatLanguageModel getChatLanguageModel(AiChatModelConfigPojo modelConfig) {
        if (modelConfig == null || StrUtil.isBlank((CharSequence)modelConfig.getProvider()) || StrUtil.isBlank((CharSequence)modelConfig.getBaseUrl())) {
            throw new ELSBootException("\u8bf7\u5148\u8bbe\u7f6e\u597dAI\u6a21\u578b\u914d\u7f6e");
        }
        AiModelFactory modelFactory = AiBeanFactory.getModelFactories(modelConfig.getProvider().toUpperCase());
        if (modelFactory != null) {
            return modelFactory.createChatModel(modelConfig);
        }
        throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u6a21\u578b" + modelConfig.getProvider());
    }

    @Transactional(rollbackFor={Exception.class}, readOnly=true)
    public abstract LlmResponsePojo generate(LlmRequestPojo var1);

    public abstract String getInstruction();
}

