/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ai.core.modelStrategy;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.els.common.exception.ELSBootException;
import com.els.common.util.SpringContextUtils;
import com.els.modules.ai.core.helper.AiChatResponseHelper;
import com.els.modules.ai.core.modelStrategy.SimpleAiLogicRunStrategy;
import com.els.modules.ai.core.modelStrategy.dync.AiEnhanceBeanHolder;
import com.els.modules.ai.core.modelStrategy.dync.AiEnhanceGroovyFactory;
import com.els.modules.ai.core.modelStrategy.dync.AiEnhanceService;
import com.els.modules.ai.core.util.AiBeanFactory;
import com.els.modules.ai.pojo.AiChatAppPojo;
import com.els.modules.ai.pojo.AiChatExamplarPojo;
import com.els.modules.ai.pojo.AiChatModelConfigPojo;
import com.els.modules.ai.pojo.AiChatPojo;
import com.els.modules.ai.pojo.LlmRequestPojo;
import com.els.modules.ai.pojo.LlmResponsePojo;
import com.els.modules.ai.pojo.QuestionInfoPojo;
import com.google.common.collect.Lists;
import dev.langchain4j.model.input.Prompt;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Service;

@Service
public class PostConfigAiLogicRunStrategy
extends SimpleAiLogicRunStrategy
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(PostConfigAiLogicRunStrategy.class);

    @Override
    String modelRunStrategy() {
        return "postConfigAiLogicRunStrategy";
    }

    protected String runAiRequestParamBuilder(AiChatPojo aiChatPojo, AiChatAppPojo aiChatAppPojo, Prompt prompt) {
        AiEnhanceService service;
        String aiInnerEnhanceServiceBeanName = aiChatAppPojo.getAiInnerEnhanceServiceBeanName();
        if (CharSequenceUtil.isNotEmpty((CharSequence)aiInnerEnhanceServiceBeanName)) {
            try {
                AiEnhanceService bean = (AiEnhanceService)SpringContextUtils.getBean((String)aiInnerEnhanceServiceBeanName, AiEnhanceService.class);
                return bean.runAiRequestParamBuilder(aiChatPojo, aiChatAppPojo, prompt);
            }
            catch (Exception e) {
                throw new ELSBootException(aiInnerEnhanceServiceBeanName + "\u5b9e\u4f8b\u4e0d\u5b58\u5728");
            }
        }
        String aiEnhanceServiceBean = aiChatAppPojo.getAiEnhanceServiceBean();
        if (CharSequenceUtil.isNotEmpty((CharSequence)aiEnhanceServiceBean) && (service = AiEnhanceGroovyFactory.getInstance().getEnhanceServiceFromCode(aiEnhanceServiceBean)) != null) {
            AiEnhanceBeanHolder.set(service);
            return service.runAiRequestParamBuilder(aiChatPojo, aiChatAppPojo, prompt);
        }
        return null;
    }

    protected Map<String, String> runAiRequestHeadBuilder(AiChatPojo aiChatPojo, AiChatAppPojo aiChatAppPojo, Prompt prompt) {
        String aiInnerEnhanceServiceBeanName = aiChatAppPojo.getAiInnerEnhanceServiceBeanName();
        if (CharSequenceUtil.isNotEmpty((CharSequence)aiInnerEnhanceServiceBeanName)) {
            try {
                AiEnhanceService bean = (AiEnhanceService)SpringContextUtils.getBean((String)aiInnerEnhanceServiceBeanName, AiEnhanceService.class);
                return bean.runAiRequestHeadBuilder(aiChatPojo, aiChatAppPojo, prompt);
            }
            catch (Exception e) {
                throw new ELSBootException(aiInnerEnhanceServiceBeanName + "\u5b9e\u4f8b\u4e0d\u5b58\u5728");
            }
        }
        String aiEnhanceServiceBean = aiChatAppPojo.getAiEnhanceServiceBean();
        if (CharSequenceUtil.isNotEmpty((CharSequence)aiEnhanceServiceBean)) {
            AiEnhanceService service = AiEnhanceBeanHolder.get();
            if (null != service) {
                return service.runAiRequestHeadBuilder(aiChatPojo, aiChatAppPojo, prompt);
            }
            service = AiEnhanceGroovyFactory.getInstance().getEnhanceServiceFromCode(aiEnhanceServiceBean);
            if (service != null) {
                AiEnhanceBeanHolder.set(service);
                return service.runAiRequestHeadBuilder(aiChatPojo, aiChatAppPojo, prompt);
            }
        }
        return new HashMap<String, String>();
    }

    protected LlmResponsePojo runAiSelfConsistencyVoteBuilder(AiChatPojo aiChatPojo, AiChatAppPojo aiChatAppPojo, LlmResponsePojo llmResponse, Map<String, Prompt> output2Prompt) {
        String aiEnhanceServiceBean;
        String aiInnerEnhanceServiceBeanName = aiChatAppPojo.getAiInnerEnhanceServiceBeanName();
        if (CharSequenceUtil.isNotEmpty((CharSequence)aiInnerEnhanceServiceBeanName)) {
            try {
                AiEnhanceService bean = (AiEnhanceService)SpringContextUtils.getBean((String)aiInnerEnhanceServiceBeanName, AiEnhanceService.class);
                bean.runAiSelfConsistencyVoteBuilder(aiChatPojo, aiChatAppPojo, llmResponse, output2Prompt);
            }
            catch (Exception e) {
                throw new ELSBootException(aiInnerEnhanceServiceBeanName + "\u5b9e\u4f8b\u4e0d\u5b58\u5728");
            }
        }
        if (CharSequenceUtil.isNotEmpty((CharSequence)(aiEnhanceServiceBean = aiChatAppPojo.getAiEnhanceServiceBean()))) {
            AiEnhanceService service = AiEnhanceBeanHolder.get();
            if (null != service) {
                return service.runAiSelfConsistencyVoteBuilder(aiChatPojo, aiChatAppPojo, llmResponse, output2Prompt);
            }
            service = AiEnhanceGroovyFactory.getInstance().getEnhanceServiceFromCode(aiEnhanceServiceBean);
            if (service != null) {
                AiEnhanceBeanHolder.set(service);
                return service.runAiSelfConsistencyVoteBuilder(aiChatPojo, aiChatAppPojo, llmResponse, output2Prompt);
            }
        } else {
            AiChatResponseHelper responseHelper = AiBeanFactory.getAiChatResponseHelper(aiChatAppPojo.getModelRunResponseHelper());
            Pair<String, Map<String, Double>> sqlMapPair = responseHelper.selfConsistencyVote(Lists.newArrayList(output2Prompt.keySet()));
            llmResponse.setResultText((String)sqlMapPair.getLeft());
        }
        return llmResponse;
    }

    @Override
    public LlmResponsePojo generate(LlmRequestPojo llmRequest) {
        LlmResponsePojo llmResponse = new LlmResponsePojo();
        AiChatPojo chatChatConfig = llmRequest.getAiChatPojo();
        AiChatAppPojo chatAppConfig = llmRequest.getAiChatAppPojo();
        if (CollectionUtil.isEmpty((Collection)chatChatConfig.getFileList())) {
            throw new ELSBootException("\u6587\u4ef6\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
        QuestionInfoPojo question = chatChatConfig.getQuestion();
        String questionText = CharSequenceUtil.isEmpty((CharSequence)question.getQuestion()) ? chatAppConfig.getQuestion() : question.getQuestion();
        llmResponse.setQuestion(questionText);
        List<List<AiChatExamplarPojo>> exemplarsList = this.promptHelper.getFewShotExemplars(llmRequest);
        AiChatAppPojo chatApp = llmRequest.getAiChatAppPojo();
        if (StrUtil.isBlank((CharSequence)chatApp.getPromptTemplate())) {
            throw new ELSBootException("\u5e94\u7528\u95ee\u9898\u6a21\u677f\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        HashMap<Prompt, List<AiChatExamplarPojo>> prompt2Exemplar = new HashMap<Prompt, List<AiChatExamplarPojo>>();
        for (List<AiChatExamplarPojo> exemplars : exemplarsList) {
            llmRequest.setChatExamplers(exemplars);
            Prompt prompt2 = this.generatePrompt(llmRequest, llmResponse, chatApp);
            prompt2Exemplar.put(prompt2, exemplars);
        }
        AiChatModelConfigPojo aiChatModelConfigPojo = chatApp.getAiChatModelConfigPojo();
        ConcurrentHashMap<String, Prompt> output2Prompt = new ConcurrentHashMap<String, Prompt>();
        prompt2Exemplar.keySet().parallelStream().forEach(prompt -> {
            Map<String, String> header = this.runAiRequestHeadBuilder(chatChatConfig, chatApp, (Prompt)prompt);
            llmResponse.setQuestionInput(prompt.toUserMessage().singleText());
            String body = this.runAiRequestParamBuilder(chatChatConfig, chatApp, (Prompt)prompt);
            HttpResponse execute = ((HttpRequest)HttpUtil.createPost((String)aiChatModelConfigPojo.getBaseUrl()).body(body).addHeaders(header)).execute();
            String result = execute.body();
            output2Prompt.put(result, (Prompt)prompt);
        });
        return this.runAiSelfConsistencyVoteBuilder(chatChatConfig, chatApp, llmResponse, output2Prompt);
    }
}

