/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ai.service.impl;

import cn.hutool.core.convert.Convert;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.ai.entity.AiChatExamplar;
import com.els.modules.ai.mapper.AiChatExamplarMapper;
import com.els.modules.ai.pojo.AiChatExamplarPojo;
import com.els.modules.ai.service.AiChatExamplarService;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class AiChatExamplarServiceImpl
extends BaseServiceImpl<AiChatExamplarMapper, AiChatExamplar>
implements AiChatExamplarService {
    private static final Logger log = LoggerFactory.getLogger(AiChatExamplarServiceImpl.class);

    @Override
    public void add(AiChatExamplar aiChatExamplar) {
        ((AiChatExamplarMapper)this.baseMapper).insert((Object)aiChatExamplar);
    }

    @Override
    public void edit(AiChatExamplar aiChatExamplar) {
        int count = ((AiChatExamplarMapper)this.baseMapper).updateById((Object)aiChatExamplar);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((AiChatExamplarMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public List<AiChatExamplarPojo> getExemplars(String appCode, int num) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(BaseEntity::getElsAccount, (Object)SysUtil.getLoginUser().getElsAccount());
        wrapper.eq(AiChatExamplar::getAppCode, (Object)appCode);
        List list = this.list((Wrapper)wrapper).stream().limit(num).toList();
        return Convert.toList(AiChatExamplarPojo.class, list);
    }

    @Override
    public List<AiChatExamplarPojo> loadExamplersByCode(String appCode, String elsAccount) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)wrapper.eq(AiChatExamplar::getAppCode, (Object)appCode)).eq(BaseEntity::getElsAccount, (Object)elsAccount);
        List list = this.list((Wrapper)wrapper);
        if (list.isEmpty() && !"100000".equals(elsAccount)) {
            wrapper.clear();
            ((LambdaQueryWrapper)wrapper.eq(AiChatExamplar::getAppCode, (Object)appCode)).eq(BaseEntity::getElsAccount, (Object)"100000");
            list = this.list((Wrapper)wrapper);
        }
        return Convert.toList(AiChatExamplarPojo.class, (Object)list);
    }
}

