/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.attachment.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.constant.CommonConstant;
import com.els.common.util.SysUtil;
import com.els.common.validator.SrmObjGroupMsg;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.attachment.entity.PurchaseAttachmentDemand;
import com.els.modules.attachment.entity.SaleAttachmentDemand;
import com.els.modules.attachment.mapper.PurchaseAttachmentDemandMapper;
import com.els.modules.attachment.service.PurchaseAttachmentDemandService;
import com.els.modules.attachment.service.SaleAttachmentDemandService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class PurchaseAttachmentDemandServiceImpl
extends ServiceImpl<PurchaseAttachmentDemandMapper, PurchaseAttachmentDemand>
implements PurchaseAttachmentDemandService {
    @Resource
    private SaleAttachmentDemandService saleAttachmentDemandService;

    @Override
    public void savePurchaseAttachmentDemand(PurchaseAttachmentDemand attachmentDemand) {
        ((PurchaseAttachmentDemandMapper)this.baseMapper).insert((Object)attachmentDemand);
    }

    @Override
    @SrmValidated
    public void addBatch(@Valid @SrmObjGroupMsg(templateGroupName="\u9644\u4ef6\u9700\u6c42\u6e05\u5355", templateGroupI18Key="i18n_title_attachedDemandList") List<PurchaseAttachmentDemand> demandList, String headId, String businessType) {
        if (CollectionUtil.isNotEmpty(demandList)) {
            LoginUserDTO user = SysUtil.getLoginUser();
            Date now = new Date();
            for (PurchaseAttachmentDemand demand : demandList) {
                demand.setId(null);
                demand.setElsAccount(TenantContext.getTenant());
                demand.setHeadId(headId);
                demand.setBusinessType(businessType);
                demand.setCreateBy(user.getSubAccount());
                demand.setCreateTime(now);
                demand.setUpdateBy(user.getSubAccount());
                demand.setUpdateTime(now);
                demand.setDeleted(CommonConstant.DEL_FLAG_0);
                demand.setRequired(demand.getRequired() == null ? "0" : demand.getRequired());
            }
            this.saveBatch(demandList);
        }
    }

    @Override
    public void sendDemand(List<PurchaseAttachmentDemand> demandList, String headId, String businessType, Map<String, String> idMap) {
        if (CollectionUtil.isEmpty(demandList)) {
            return;
        }
        List<PurchaseAttachmentDemand> dbList = ((PurchaseAttachmentDemandMapper)this.baseMapper).selectByMainId(headId);
        if (dbList.isEmpty()) {
            this.addBatch(demandList, headId, businessType);
        }
        ArrayList<SaleAttachmentDemand> saleAttachmentDemandList = new ArrayList<SaleAttachmentDemand>();
        for (PurchaseAttachmentDemand demand : demandList) {
            for (String toElsAccount : idMap.keySet()) {
                SaleAttachmentDemand saleDemand = new SaleAttachmentDemand();
                BeanUtils.copyProperties((Object)((Object)demand), (Object)((Object)saleDemand));
                saleDemand.setId(null);
                saleDemand.setElsAccount(toElsAccount);
                saleDemand.setHeadId(idMap.get(toElsAccount));
                saleAttachmentDemandList.add(saleDemand);
            }
        }
        this.saleAttachmentDemandService.saveBatch(saleAttachmentDemandList);
    }

    @Override
    public void updatePurchaseAttachmentDemand(PurchaseAttachmentDemand attachmentDemand) {
        ((PurchaseAttachmentDemandMapper)this.baseMapper).updateById((Object)attachmentDemand);
    }

    @Override
    public void delPurchaseAttachmentDemand(String id) {
        ((PurchaseAttachmentDemandMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchPurchaseAttachmentDemand(List<String> idList) {
        ((PurchaseAttachmentDemandMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public List<PurchaseAttachmentDemand> selectByMainId(String mainId) {
        return ((PurchaseAttachmentDemandMapper)this.baseMapper).selectByMainId(mainId);
    }

    @Override
    public void logicDeleteByMainId(String mainId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(PurchaseAttachmentDemand::getHeadId, (Object)mainId);
        ((PurchaseAttachmentDemandMapper)this.baseMapper).delete((Wrapper)queryWrapper);
    }

    @Override
    public void physicalDeleteByMainId(String mainId) {
        ((PurchaseAttachmentDemandMapper)this.baseMapper).deleteByMainId(mainId);
    }
}

