/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.barcode.service.impl;

import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.barcode.entity.PurchaseBarcodeInfoDetail;
import com.els.modules.barcode.entity.PurchaseBarcodeInfoHead;
import com.els.modules.barcode.entity.PurchaseBarcodeInfoItem;
import com.els.modules.barcode.entity.PurchaseBarcodePoolHead;
import com.els.modules.barcode.entity.PurchaseBarcodePoolItem;
import com.els.modules.barcode.entity.PurchaseBarcodePoolRecord;
import com.els.modules.barcode.enumerate.SrmEnabledStatusEnum;
import com.els.modules.barcode.mapper.PurchaseBarcodePoolHeadMapper;
import com.els.modules.barcode.mapper.PurchaseBarcodePoolItemMapper;
import com.els.modules.barcode.mapper.PurchaseBarcodePoolRecordMapper;
import com.els.modules.barcode.service.PurchaseBarcodePoolHeadService;
import com.els.modules.barcode.service.PurchaseBarcodePoolItemService;
import com.els.modules.barcode.service.PurchaseBarcodePoolRecordService;
import com.els.modules.barcode.vo.BarcodeInfoVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PurchaseBarcodePoolHeadServiceImpl
extends BaseServiceImpl<PurchaseBarcodePoolHeadMapper, PurchaseBarcodePoolHead>
implements PurchaseBarcodePoolHeadService {
    @Autowired
    private PurchaseBarcodePoolHeadMapper purchaseBarcodePoolHeadMapper;
    @Autowired
    private PurchaseBarcodePoolItemMapper purchaseBarcodePoolItemMapper;
    @Autowired
    private PurchaseBarcodePoolItemService purchaseBarcodePoolItemService;
    @Autowired
    private PurchaseBarcodePoolRecordMapper purchaseBarcodePoolRecordMapper;
    @Autowired
    private PurchaseBarcodePoolRecordService purchaseBarcodePoolRecordService;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseBarcodePoolHead purchaseBarcodePoolHead, List<PurchaseBarcodePoolItem> purchaseBarcodePoolItemList, List<PurchaseBarcodePoolRecord> purchaseBarcodePoolRecordList) {
        this.purchaseBarcodePoolHeadMapper.insert((Object)purchaseBarcodePoolHead);
        this.insertData(purchaseBarcodePoolHead, purchaseBarcodePoolItemList, purchaseBarcodePoolRecordList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseBarcodePoolHead purchaseBarcodePoolHead, List<PurchaseBarcodePoolItem> purchaseBarcodePoolItemList, List<PurchaseBarcodePoolRecord> purchaseBarcodePoolRecordList) {
        int count = this.purchaseBarcodePoolHeadMapper.updateById((Object)purchaseBarcodePoolHead);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
        this.purchaseBarcodePoolItemMapper.deleteByMainId(purchaseBarcodePoolHead.getId());
        this.purchaseBarcodePoolRecordMapper.deleteByMainId(purchaseBarcodePoolHead.getId());
        this.insertData(purchaseBarcodePoolHead, purchaseBarcodePoolItemList, purchaseBarcodePoolRecordList);
    }

    private void insertData(PurchaseBarcodePoolHead purchaseBarcodePoolHead, List<PurchaseBarcodePoolItem> purchaseBarcodePoolItemList, List<PurchaseBarcodePoolRecord> purchaseBarcodePoolRecordList) {
        if (purchaseBarcodePoolItemList != null && !purchaseBarcodePoolItemList.isEmpty()) {
            for (PurchaseBarcodePoolItem purchaseBarcodePoolItem : purchaseBarcodePoolItemList) {
                purchaseBarcodePoolItem.setHeadId(purchaseBarcodePoolHead.getId());
                SysUtil.setSysParam((BaseEntity)purchaseBarcodePoolItem, (BaseEntity)purchaseBarcodePoolHead);
            }
            this.purchaseBarcodePoolItemService.saveBatch(purchaseBarcodePoolItemList);
        }
        if (purchaseBarcodePoolRecordList != null && !purchaseBarcodePoolRecordList.isEmpty()) {
            for (PurchaseBarcodePoolRecord purchaseBarcodePoolRecord : purchaseBarcodePoolRecordList) {
                purchaseBarcodePoolRecord.setHeadId(purchaseBarcodePoolHead.getId());
                SysUtil.setSysParam((BaseEntity)purchaseBarcodePoolRecord, (BaseEntity)purchaseBarcodePoolHead);
            }
            this.purchaseBarcodePoolRecordService.saveBatch(purchaseBarcodePoolRecordList);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.purchaseBarcodePoolItemMapper.deleteByMainId(id);
        this.purchaseBarcodePoolRecordMapper.deleteByMainId(id);
        this.purchaseBarcodePoolHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.purchaseBarcodePoolItemMapper.deleteByMainId(serializable.toString());
            this.purchaseBarcodePoolRecordMapper.deleteByMainId(serializable.toString());
            this.purchaseBarcodePoolHeadMapper.deleteById(serializable);
        }
    }

    @Override
    @Transactional
    public void addByBarcodeInfo(PurchaseBarcodeInfoHead purchaseBarcodeInfoHead, List<PurchaseBarcodeInfoItem> purchaseBarcodeInfoItemList, List<PurchaseBarcodeInfoDetail> sysBarcodeList) {
        if (sysBarcodeList != null && sysBarcodeList.size() > 0) {
            for (PurchaseBarcodeInfoDetail detail : sysBarcodeList) {
                PurchaseBarcodePoolHead poolHead = new PurchaseBarcodePoolHead();
                poolHead.setOriginalBarcode(detail.getOriginalBarcode());
                poolHead.setBarcode(detail.getBarcode());
                poolHead.setInfoNumber(purchaseBarcodeInfoHead.getInfoNumber());
                poolHead.setRuleCode(purchaseBarcodeInfoHead.getRuleCode());
                poolHead.setRuleId(purchaseBarcodeInfoHead.getRuleId());
                poolHead.setStatus(SrmEnabledStatusEnum.ENABLED.getValue());
                poolHead.setPrintNumber(detail.getPrintNumber());
                poolHead.setPrintedNumber(0);
                poolHead.setUsed("1");
                poolHead.setCompany(purchaseBarcodeInfoHead.getCompany());
                poolHead.setFactory(purchaseBarcodeInfoHead.getFactory());
                this.save((Object)poolHead);
                ArrayList<PurchaseBarcodePoolItem> purchaseBarcodePoolItemList = new ArrayList<PurchaseBarcodePoolItem>();
                for (PurchaseBarcodeInfoItem entity : purchaseBarcodeInfoItemList) {
                    PurchaseBarcodePoolItem purchaseBarcodePoolItem = new PurchaseBarcodePoolItem();
                    BeanUtils.copyProperties((Object)((Object)entity), (Object)((Object)purchaseBarcodePoolItem));
                    purchaseBarcodePoolItem.setHeadId(poolHead.getId());
                    purchaseBarcodePoolItem.setId(null);
                    for (String attr : entity.getAttribute().split(",")) {
                        if (!poolHead.getOriginalBarcode().contains(attr)) continue;
                        purchaseBarcodePoolItem.setAttribute(attr);
                    }
                    purchaseBarcodePoolItemList.add(purchaseBarcodePoolItem);
                }
                this.purchaseBarcodePoolItemService.saveBatch(purchaseBarcodePoolItemList);
            }
        }
    }

    @Override
    public BarcodeInfoVO getBarcodeInfo(String barcode) {
        return this.purchaseBarcodePoolHeadMapper.getBarcodeInfo(barcode, SrmEnabledStatusEnum.ENABLED.getValue());
    }

    @Override
    public BarcodeInfoVO getBarcodeInfoNoStatus(String barcode) {
        return this.purchaseBarcodePoolHeadMapper.getBarcodeInfo(barcode, null);
    }
}

