/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.barcode.service.impl;

import cn.hutool.core.util.StrUtil;
import com.els.common.util.AssertI18nUtil;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.barcode.entity.SaleBarcodePoolRecord;
import com.els.modules.barcode.enumerate.I18nBarCodeEnum;
import com.els.modules.barcode.mapper.ElsBarCodeShortCodeMapper;
import com.els.modules.barcode.mapper.ElsBarcodeRuleHeadMapper;
import com.els.modules.barcode.mapper.SaleBarcodePoolHeadMapper;
import com.els.modules.barcode.mapper.SaleBarcodePoolRecordMapper;
import com.els.modules.barcode.service.SaleExplainService;
import com.els.modules.barcode.service.impl.base.BaseExplainService;
import com.els.modules.barcode.vo.BarCodeExplainItemVO;
import com.els.modules.barcode.vo.BarCodeExplainReqVO;
import com.els.modules.barcode.vo.BarCodeExplainRespVO;
import com.els.modules.barcode.vo.BarCodePoolItemVO;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.shiro.SecurityUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class SaleExplainServiceImpl
extends BaseExplainService
implements SaleExplainService {
    @Resource
    private SaleBarcodePoolHeadMapper poolHeadMapper;
    @Resource
    private SaleBarcodePoolRecordMapper poolRecordMapper;

    @Override
    @Resource
    public void setRuleHeadMapper(ElsBarcodeRuleHeadMapper ruleHeadMapper) {
        this.ruleHeadMapper = ruleHeadMapper;
    }

    @Override
    @Resource
    public void setShortCodeMapper(ElsBarCodeShortCodeMapper shortCodeMapper) {
        this.shortCodeMapper = shortCodeMapper;
    }

    private void savePoolRecord(String cipherBarcode, int saveOperaRecord) {
        if (0 == saveOperaRecord) {
            return;
        }
        SaleBarcodePoolRecord poolRecord = new SaleBarcodePoolRecord();
        LoginUserDTO sysUser = (LoginUserDTO)SecurityUtils.getSubject().getPrincipal();
        poolRecord.setHeadId(this.poolHeadMapper.getIdByBarCode(cipherBarcode));
        poolRecord.setBusinessType("\u626b\u63cf\u6761\u7801");
        poolRecord.setOperation("\u626b\u63cf");
        poolRecord.setOperator(sysUser.getSubAccount());
        poolRecord.setOperateTime(new Date());
        this.poolRecordMapper.insert((Object)poolRecord);
    }

    @Override
    protected List<BarCodeExplainItemVO> barCodeLibrary(String cipherBarcode) {
        List<BarCodePoolItemVO> itemVOS = this.poolHeadMapper.getPoolItemByBarCode(cipherBarcode);
        AssertI18nUtil.isTrue((boolean)CollectionUtils.isEmpty(itemVOS), (Enum)I18nBarCodeEnum.LIBRARY_NOT_FOUND);
        List<BarCodeExplainItemVO> explainItemVOS = itemVOS.stream().map(itemVO -> {
            BarCodeExplainItemVO explainItemVO = new BarCodeExplainItemVO();
            explainItemVO.setAttrType(itemVO.getBusinessType());
            explainItemVO.setAttrName(itemVO.getBusinessFieldName());
            explainItemVO.setOriginalValue(itemVO.getAttribute());
            if ("1".equals(itemVO.getUsedCode())) {
                String shortCodeValue = this.getShortCodeValue(itemVO.getAttribute(), itemVO.getCodeType());
                explainItemVO.setShortCode(shortCodeValue);
            }
            return explainItemVO;
        }).collect(Collectors.toList());
        return explainItemVOS;
    }

    @Override
    protected BarCodeExplainRespVO explainByLibrary(String barCodeCotent, int saveOperaRecord) {
        String cipherBarcode = this.originalBarcode(barCodeCotent);
        List<BarCodeExplainItemVO> itemVOS = this.barCodeLibrary(cipherBarcode);
        this.savePoolRecord(cipherBarcode, saveOperaRecord);
        return new BarCodeExplainRespVO(cipherBarcode, itemVOS);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public BarCodeExplainRespVO barCodeExplain(BarCodeExplainReqVO barCodeExplainReqVO) {
        AssertI18nUtil.isTrue((boolean)StrUtil.isBlank((CharSequence)barCodeExplainReqVO.getBarCodeContent()), (Enum)I18nBarCodeEnum.BAR_CODE_IS_NULL);
        if (0 == barCodeExplainReqVO.getExplainStrategy()) {
            return new BarCodeExplainRespVO(this.originalBarcode(barCodeExplainReqVO.getBarCodeContent()));
        }
        if (2 == barCodeExplainReqVO.getExplainStrategy()) {
            return this.explainByRule(barCodeExplainReqVO.getBarCodeContent());
        }
        return this.explainByLibrary(barCodeExplainReqVO.getBarCodeContent(), barCodeExplainReqVO.getSaveOperaRecord());
    }
}

