/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ai.controller;

import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.common.exception.ELSBootException;
import com.els.common.system.util.JwtUtil;
import com.els.common.system.vo.LoginUser;
import com.els.common.trace.TraceIdHolder;
import com.els.common.trace.TraceIdUtil;
import com.els.common.util.LoginUserContext;
import com.els.common.util.RedisUtil;
import com.els.common.util.SrmRpcUtil;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.ai.service.AiInvokeSrmRpcService;
import com.els.rpc.service.InvokeAccountRpcService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/openApi/ai"})
public class SrmAiOpenApiController {
    private static final Logger log = LoggerFactory.getLogger(SrmAiOpenApiController.class);
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private InvokeAccountRpcService invokeAccountRpcService;
    private static final String AI_TRACE_ID_KEY = "ai:traceIdToken:";

    @PostMapping(value={"/invokeSrm/{interfaceCode}"})
    public Object invokeSrm(@RequestBody com.alibaba.fastjson2.JSONObject param, @PathVariable(value="interfaceCode") String interfaceCode) {
        AiInvokeSrmRpcService service = null;
        try {
            String srmToken;
            service = (AiInvokeSrmRpcService)SrmRpcUtil.getExecuteServiceImpl((String)interfaceCode, AiInvokeSrmRpcService.class);
            if (null == service) {
                throw new ELSBootException(interfaceCode + "\u670d\u52a1\u4e0d\u5b58\u5728");
            }
            String traceId = TraceIdHolder.get();
            if (CharSequenceUtil.isEmpty((CharSequence)traceId)) {
                traceId = TraceIdUtil.generateOutTraceId();
            }
            if (CharSequenceUtil.isNotEmpty((CharSequence)(srmToken = (String)this.redisUtil.get(AI_TRACE_ID_KEY + traceId)))) {
                JSONObject accountObj = JwtUtil.getAccountObj((String)srmToken);
                LoginUserDTO loginUser = this.invokeAccountRpcService.getLoginUser(accountObj.getString("elsAccount") + "_" + accountObj.getString("subAccount"));
                if (null == loginUser) {
                    throw new ELSBootException("SRM\u767b\u5f55\u7528\u6237\u4f1a\u8bdd\u5df2\u8fc7\u671f\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u65b0\u64cd\u4f5c");
                }
                LoginUser user = new LoginUser();
                BeanUtils.copyProperties((Object)loginUser, (Object)user);
                LoginUserContext.setUser((LoginUserDTO)user);
            }
            Object result = service.invoke(param);
            com.alibaba.fastjson2.JSONObject resultMap = new com.alibaba.fastjson2.JSONObject();
            resultMap.put((Object)"success", (Object)true);
            resultMap.put((Object)"code", (Object)200);
            resultMap.put((Object)"result", result);
            resultMap.put((Object)"timestamp", (Object)System.currentTimeMillis());
            com.alibaba.fastjson2.JSONObject jSONObject = resultMap;
            return jSONObject;
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage());
        }
        finally {
            LoginUserContext.clear();
        }
    }
}

