/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ai.controller;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.els.common.exception.ELSBootException;
import com.els.common.trace.TraceIdHolder;
import com.els.common.trace.TraceIdUtil;
import com.els.common.util.ExternalUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.integration.api.dto.ExternalVoucherDto;
import jakarta.servlet.http.HttpServletRequest;
import java.net.URLEncoder;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/base/ai"})
public class SrmToAiApiController {
    private static final Logger log = LoggerFactory.getLogger(SrmToAiApiController.class);
    @Autowired
    private RedisUtil redisUtil;
    private static final String AI_TRACE_ID_KEY = "ai:traceIdToken:";

    @PostMapping(value={"/invokeAi/{interfaceCode}"})
    public Object invokeAi(@RequestBody JSONObject param, @PathVariable(value="interfaceCode") String interfaceCode, HttpServletRequest request) {
        LoginUserDTO loginUser = SysUtil.getLoginUser();
        param.put((Object)"loginUser", (Object)loginUser);
        String traceId = TraceIdHolder.get();
        if (CharSequenceUtil.isEmpty((CharSequence)traceId)) {
            traceId = TraceIdUtil.generateOutTraceId();
        }
        String srmToken = request.getHeader("token");
        ExternalVoucherDto authDTO = this.getAiAppToken(TenantContext.getTenant(), "srmAi");
        Map parameterMap = request.getParameterMap();
        StringBuilder urlBuilder = new StringBuilder(authDTO.getServiceUrl());
        urlBuilder.append("/").append(interfaceCode);
        if (parameterMap != null && !parameterMap.isEmpty()) {
            urlBuilder.append("?");
            boolean isFirstParam = true;
            for (Map.Entry entry : parameterMap.entrySet()) {
                String paramName = (String)entry.getKey();
                String[] paramValues = (String[])entry.getValue();
                if (paramValues == null || paramValues.length <= 0) continue;
                for (String value : paramValues) {
                    if (!isFirstParam) {
                        urlBuilder.append("&");
                    }
                    try {
                        urlBuilder.append(URLEncoder.encode(paramName, "UTF-8")).append("=").append(URLEncoder.encode(value, "UTF-8"));
                        isFirstParam = false;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        this.redisUtil.set(AI_TRACE_ID_KEY + traceId, (Object)srmToken);
        String body = ((HttpRequest)((HttpRequest)((HttpRequest)HttpRequest.post((String)urlBuilder.toString()).header("key", authDTO.getVoucherKey())).header("secret", authDTO.getVoucherSecret())).header("x-request-id", traceId)).body(param.toString()).execute().body();
        return JSON.parseObject((String)body);
    }

    public ExternalVoucherDto getAiAppToken(String elsAccount, String type) {
        ExternalVoucherDto iPassVoucher = ExternalUtil.getVoucher((String)elsAccount, (String)type);
        if (null == iPassVoucher || CharSequenceUtil.isEmpty((CharSequence)iPassVoucher.getVoucherKey()) || CharSequenceUtil.isEmpty((CharSequence)iPassVoucher.getVoucherKey())) {
            throw new ELSBootException("AI\u63a5\u53e3\u51ed\u8bc1\u4e0d\u5b58\u5728");
        }
        return iPassVoucher;
    }
}

