/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.attachment.storage.spi.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.modules.attachment.entity.ElsAttachmentPart;
import com.els.modules.attachment.storage.StorageFileInfo;
import com.els.modules.attachment.storage.enumerate.FileStorageTypeEnum;
import com.els.modules.attachment.storage.spi.AbstractStorageSpi;
import com.qcloud.cos.utils.IOUtils;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="localStorageSpi")
public class LocalStorageClient
extends AbstractStorageSpi {
    private static final Logger log = LoggerFactory.getLogger(LocalStorageClient.class);
    private static final String PART_PATH = "/opt/upFiles/temp";

    @Override
    public Object loadStorageClient() {
        throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APQIMGCKxTPqDO_d3760f73", (String)"\u5f53\u524d\u6587\u4ef6\u5b58\u50a8\u6a21\u5f0f\u4e0d\u9700\u8981\u5ba2\u6237\u7aef"));
    }

    @Override
    public String type() {
        return FileStorageTypeEnum.LOCAL.getCode();
    }

    @Override
    public String loadDownloadPath(String objectPath) {
        if (objectPath.startsWith("/")) {
            objectPath = objectPath.substring(1);
        }
        String url = SERVICE_ADDRESS + "/opt/upFiles/" + objectPath;
        return url.replace("\\", "/");
    }

    @Override
    public boolean store(StorageFileInfo fileInfo) {
        try {
            Path resolve = rootLocation.resolve(UPLOAD_PATH + fileInfo.getPath());
            File file = new File(resolve.getParent().toUri());
            if (!file.exists()) {
                file.mkdirs();
            }
            Files.copy(fileInfo.getInputStream(), resolve, StandardCopyOption.REPLACE_EXISTING);
            return true;
        }
        catch (IOException e) {
            log.error(":::\u5f53\u524d\u7c7b\u578b[{}]\u5b58\u50a8\u6587\u4ef6\u5931\u8d25:{}", (Object)this.type(), (Object)e);
            return false;
        }
    }

    public Path load(String filePath) {
        return rootLocation.resolve(UPLOAD_PATH + filePath);
    }

    @Override
    public boolean delete(String filePath) {
        Path file = this.load(filePath);
        try {
            Files.deleteIfExists(file);
            return true;
        }
        catch (IOException e) {
            log.error(":::\u5f53\u524d\u7c7b\u578b[{}]\u5220\u9664\u6587\u4ef6{}\u5931\u8d25{}", new Object[]{this.type(), filePath, e.getMessage()});
            return false;
        }
    }

    @Override
    public boolean deleteFileBatch(List<String> remotePaths) {
        remotePaths.forEach(this::delete);
        return false;
    }

    @Override
    public String getBaseUrl() {
        return SERVICE_ADDRESS + "/opt/upFiles/";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void downloadFileWithOutput(HttpServletResponse response, OutputStream outputStream, String filePath) {
        try {
            FileInputStream inputStream = new FileInputStream(UPLOAD_PATH + filePath);
            byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
            outputStream.write(bytes, 0, bytes.length);
            outputStream.flush();
        }
        catch (Exception e) {
            log.error(":::\u6587\u4ef6\u4e0b\u8f7d\u5f02\u5e38:{}", (Object)e.getMessage());
        }
        finally {
            try {
                outputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public InputStream downloadFileWithInputStream(String filePath) {
        try {
            return new FileInputStream(UPLOAD_PATH + filePath);
        }
        catch (Exception e) {
            log.error(":::\u5f53\u524d\u6587\u4ef6\u5b58\u50a8\u7c7b\u578b[{}]\u8bfb\u53d6\u6587\u4ef6{}\u5f02\u5e38:{}", new Object[]{this.type(), filePath, e.getMessage()});
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_QIzMIH_d9711ec0", (String)"\u6587\u4ef6\u8bfb\u53d6\u5f02\u5e38"));
        }
    }

    @Override
    public String getPartUploadId(String filePath) {
        return IdWorker.getIdStr();
    }

    @Override
    public void uploadPart(ElsAttachmentPart part, MultipartFile uploadPart) {
        try {
            new File(PART_PATH + File.separator + part.getUploadId()).mkdirs();
            String partPath = PART_PATH + File.separator + part.getUploadId() + File.separator + part.getPartIndex();
            File partFile = new File(partPath);
            uploadPart.transferTo(partFile);
            part.setPartSize(String.valueOf(uploadPart.getSize()));
            part.setPartPath(partPath);
            super.savePartInfo(part);
        }
        catch (Exception e) {
            throw new ELSBootException((Throwable)e);
        }
    }

    @Override
    public List<ElsAttachmentPart> completePartUpload(String uploadId) {
        List<ElsAttachmentPart> partList = super.getPartList(uploadId);
        try (FileOutputStream fos = new FileOutputStream(UPLOAD_PATH + partList.get(0).getFilePath());
             BufferedOutputStream bos = new BufferedOutputStream(fos);){
            for (ElsAttachmentPart part : partList) {
                int byteRead;
                FileInputStream fis = new FileInputStream(part.getPartPath());
                byte[] buffer = new byte[1024];
                while ((byteRead = fis.read(buffer)) != -1) {
                    bos.write(buffer, 0, byteRead);
                }
                fis.close();
            }
            bos.flush();
            File folder = new File(PART_PATH + File.separator + uploadId);
            File[] partFiles = folder.listFiles();
            if (partFiles != null) {
                for (File partFile : partFiles) {
                    partFile.delete();
                }
            }
            folder.delete();
        }
        catch (Exception e) {
            throw new ELSBootException((Throwable)e);
        }
        return partList;
    }

    @Override
    public JSONObject getPolicy(JSONObject policyParam, HttpServletResponse response) {
        return null;
    }

    static {
        try {
            rootLocation = Paths.get(UPLOAD_PATH, new String[0]);
            if (!Files.exists(rootLocation, new LinkOption[0])) {
                Files.createDirectories(rootLocation, new FileAttribute[0]);
            }
        }
        catch (Exception e) {
            log.error(":::\u7cfb\u7edf\u4e0d\u5b58\u5728\u672c\u5730\u6587\u4ef6\u6839\u76ee\u5f55:{}", (Object)UPLOAD_PATH);
        }
    }
}

