/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.email.core.sender;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.BooleanUtil;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.modules.email.api.dto.EmailConfigDTO;
import com.els.modules.email.api.dto.EmailSendResultDto;
import com.els.modules.email.core.sender.SrmEmailSender;
import com.els.modules.email.service.EmailSendLogService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSrmEmailSender
implements SrmEmailSender {
    private static final Logger log = LoggerFactory.getLogger(AbstractSrmEmailSender.class);

    protected abstract EmailSendResultDto doSendEmail(EmailConfigDTO var1);

    protected abstract void doSendEmailEp(EmailConfigDTO var1);

    protected void before(EmailConfigDTO config) {
        if (null == config.getEmailTo() || config.getEmailTo().length == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"\u90ae\u4ef6\u6536\u4ef6\u4eba\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        if (StringUtils.isEmpty((CharSequence)config.getEmailSubject())) {
            throw new ELSBootException(I18nUtil.translate((String)"\u90ae\u4ef6\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        if (StringUtils.isEmpty((CharSequence)config.getEmailContent())) {
            throw new ELSBootException(I18nUtil.translate((String)"\u90ae\u4ef6\u6b63\u6587\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        if (StringUtils.isEmpty((CharSequence)config.getEmailUsername()) || StringUtils.isEmpty((CharSequence)config.getEmailPassword())) {
            throw new ELSBootException(I18nUtil.translate((String)"\u90ae\u4ef6\u53d1\u9001\u8005\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a"));
        }
    }

    protected void after(EmailConfigDTO config, boolean result, String msg) {
        log.info("\u53d1\u9001\u90ae\u4ef6\u6807\u9898:{}\u7ed9:{}\uff0c\u6301\u4e45\u5316:{},\u53d1\u9001\u7ed3\u679c:{},\u4fe1\u606f:{}", new Object[]{config.getEmailSubject(), config.getEmailTo(), result, config.isPersistenceWhileFailed(), msg});
        EmailSendLogService logService = (EmailSendLogService)SpringContextUtils.getBean(EmailSendLogService.class);
        if (result || BooleanUtil.isTrue((Boolean)config.isPersistenceWhileFailed())) {
            config.setEmailSendStatus(result ? "1" : "2");
            config.setErrorMsg(msg);
            config.setAttachmentFiles(null);
            logService.saveOrUpdateEmailSendRecord(config);
        } else if (CharSequenceUtil.isNotEmpty((CharSequence)config.getSendLogId())) {
            // empty if block
        }
    }

    @Override
    public EmailSendResultDto sendEmail(EmailConfigDTO config) {
        this.before(config);
        EmailSendResultDto result = this.doSendEmail(config);
        this.after(config, result.isResult(), result.getMsg());
        return result;
    }

    @Override
    public void sendEmailEp(EmailConfigDTO config) {
        boolean result = true;
        String msg = null;
        try {
            this.before(config);
        }
        catch (Exception e) {
            if (!config.isSaveCheckDataToLog()) {
                throw e;
            }
            result = false;
            msg = e.getMessage();
            this.after(config, result, msg);
            return;
        }
        try {
            this.doSendEmailEp(config);
        }
        catch (Exception e) {
            result = false;
            msg = e.getMessage();
            throw e;
        }
        finally {
            this.after(config, result, msg);
        }
    }
}

