/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.email.core.sender;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.els.common.exception.ELSBootException;
import com.els.modules.email.api.dto.EmailConfigDTO;
import com.els.modules.email.api.dto.EmailSendResultDto;
import com.els.modules.email.core.SrmEmailProtocol;
import com.els.modules.email.core.sender.AbstractSrmEmailSender;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.core.service.item.EmailMessage;
import microsoft.exchange.webservices.data.credential.ExchangeCredentials;
import microsoft.exchange.webservices.data.credential.WebCredentials;
import microsoft.exchange.webservices.data.property.complex.MessageBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="ewsEmailSender")
public class EwsEmailSender
extends AbstractSrmEmailSender {
    private static final Logger log = LoggerFactory.getLogger(EwsEmailSender.class);

    @Override
    protected EmailSendResultDto doSendEmail(EmailConfigDTO config) {
        EmailSendResultDto sendResult = new EmailSendResultDto();
        try {
            this.doSendEmailEp(config);
            sendResult.setResult(true);
        }
        catch (Exception e) {
            sendResult.setResult(false);
            sendResult.setMsg(e.getMessage());
        }
        return sendResult;
    }

    private ExchangeService buildExChangeService(EmailConfigDTO config) {
        ExchangeVersion exchangeVersion = ExchangeVersion.Exchange2010;
        if (null != config.getExchangeVersion()) {
            exchangeVersion = ExchangeVersion.valueOf((String)config.getExchangeVersion());
        }
        try {
            ExchangeService exchangeService = new ExchangeService(exchangeVersion);
            WebCredentials exchangeCredentials = new WebCredentials(config.getEmailUsername(), config.getEmailPassword(), CharSequenceUtil.isEmpty((CharSequence)config.getEmailDomain()) ? "" : config.getEmailDomain());
            exchangeService.setCredentials((ExchangeCredentials)exchangeCredentials);
            exchangeService.setUrl(new URI("https://" + config.getEmailHost() + "/ews/Exchange.asmx"));
            return exchangeService;
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage());
        }
    }

    @Override
    protected void doSendEmailEp(EmailConfigDTO config) {
        try {
            HashSet to = new HashSet();
            if (null != config.getEmailTo()) {
                to = Sets.newHashSet((Object[])config.getEmailTo());
                to.remove(config.getEmailUsername());
                log.warn("\u53d1\u9001\u90ae\u4ef6\u79fb\u9664\u4e86\u548c\u81ea\u5df1\u76f8\u540c\u7684\u6536\u4ef6\u4eba");
            }
            HashSet bcc = new HashSet();
            if (null != config.getEmailBcc()) {
                bcc = Sets.newHashSet((Object[])config.getEmailBcc());
                bcc.remove(config.getEmailUsername());
                log.warn("\u53d1\u9001\u90ae\u4ef6\u79fb\u9664\u4e86\u548c\u81ea\u5df1\u76f8\u540c\u7684BCC");
            }
            HashSet cc = new HashSet();
            if (CharSequenceUtil.isNotEmpty((CharSequence)config.getEmailCc())) {
                cc = Sets.newHashSet((Object[])config.getEmailCc().split(","));
                cc.remove(config.getEmailUsername());
                log.warn("\u53d1\u9001\u90ae\u4ef6\u79fb\u9664\u4e86\u548c\u81ea\u5df1\u76f8\u540c\u7684CC");
            }
            EmailMessage emailMessage = new EmailMessage(this.buildExChangeService(config));
            emailMessage.setSubject(config.getEmailSubject());
            for (String t : to) {
                emailMessage.getToRecipients().add(t);
            }
            for (String recipient : cc) {
                emailMessage.getCcRecipients().add(recipient);
            }
            for (String recipient : bcc) {
                emailMessage.getBccRecipients().add(recipient);
            }
            if (null != config.getAttachmentFiles() && config.getAttachmentFiles().length > 0) {
                for (File file : config.getAttachmentFiles()) {
                    emailMessage.getAttachments().addFileAttachment(file.getName(), (InputStream)new FileInputStream(file));
                }
            }
            StringBuilder content = new StringBuilder(config.getEmailContent());
            if (CollectionUtil.isNotEmpty((Map)config.getAttachmentPathList())) {
                content.append("<br/><br/><br/>\u9644\u4ef6\u5217\u8868:<br/>");
                Set key = config.getAttachmentPathList().keySet();
                for (String name : key) {
                    content.append("<a href = '").append((String)config.getAttachmentPathList().get(name)).append("' download='").append(name).append("'>").append(name).append("</a><br/>");
                }
            }
            emailMessage.setBody(MessageBody.getMessageBodyFromText((String)content.toString()));
            emailMessage.send();
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage());
        }
    }

    @Override
    public List<SrmEmailProtocol> getSupportProtocol() {
        return Lists.newArrayList((Object[])new SrmEmailProtocol[]{SrmEmailProtocol.exchange});
    }

    @Override
    public int order() {
        return 13;
    }
}

