/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.email.service.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.els.api.dto.BaseDTO;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.ConfigUtil;
import com.els.common.util.I18nUtil;
import com.els.common.util.SrmUtil;
import com.els.modules.email.api.dto.EmailConfigDTO;
import com.els.modules.email.core.SrmEmailBuilder;
import com.els.modules.email.core.SrmEmailProtocol;
import com.els.modules.email.entity.EmailConfig;
import com.els.modules.email.entity.EmailSendLog;
import com.els.modules.email.enums.EmailStatusEnum;
import com.els.modules.email.mapper.EmailConfigMapper;
import com.els.modules.email.mapper.EmailSendLogMapper;
import com.els.modules.email.service.EmailConfigService;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class EmailConfigServiceImpl
extends BaseServiceImpl<EmailConfigMapper, EmailConfig>
implements EmailConfigService {
    private static final Logger log = LoggerFactory.getLogger(EmailConfigServiceImpl.class);
    @Autowired
    private EmailSendLogMapper emailSendLogMapper;

    private boolean sendEmailCheck(EmailConfig config) {
        try {
            SrmEmailBuilder.sendEmailEpImmediately((EmailConfigDTO)Convert.convert(EmailConfigDTO.class, (Object)((Object)config)), new String[]{config.getEmailTestUsername()}, "SRM Email Setting Test!", "SRM Email Setting Test!", config.getEmailCc(), null, null, null, null);
            return true;
        }
        catch (Exception e) {
            String message = CharSequenceUtil.emptyToDefault((CharSequence)e.getMessage(), (String)"");
            if (message.contains("Connection timed out")) {
                config.setErrorMsg(I18nUtil.translate((String)"\u8fde\u63a5\u8d85\u65f6\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u7684\u57df\u540d\u3001\u7aef\u53e3\u548c\u5f53\u524d\u7f51\u7edc\u662f\u5426\u6709\u6b63\u5e38") + ":" + message);
            } else if (message.contains("AuthenticationFailedException")) {
                config.setErrorMsg(I18nUtil.translate((String)"\u6388\u6743\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u8d26\u53f7\u3001\u5bc6\u7801\u662f\u5426\u6b63\u786e") + ":" + message);
            } else {
                config.setErrorMsg(message);
            }
            return false;
        }
    }

    private void emailSetting(EmailConfig emailConfig) {
        emailConfig.setEnabled("0");
        if (null == emailConfig.getEmailWeight()) {
            emailConfig.setEmailWeight(100);
        }
        if (null == emailConfig.getEmailSort()) {
            emailConfig.setEmailSort(0);
        }
        if (null == emailConfig.getEmailPort() && !SrmEmailProtocol.exchange.getProtocol().equals(emailConfig.getEmailProtocol())) {
            emailConfig.setEmailPort(25);
        }
        if (EmailStatusEnum.ENABLED.getValue().equals(emailConfig.getEmailStatus())) {
            boolean check = this.sendEmailCheck(emailConfig);
            emailConfig.setEnabled(check ? "1" : "0");
        }
    }

    @Override
    public String add(EmailConfig elsEmailConfig) {
        if (CharSequenceUtil.isEmpty((CharSequence)elsEmailConfig.getElsAccount())) {
            elsEmailConfig.setElsAccount(SrmUtil.getLoginUser().getElsAccount());
        }
        this.emailSetting(elsEmailConfig);
        String msg = elsEmailConfig.getErrorMsg();
        ((EmailConfigMapper)this.baseMapper).insert((Object)elsEmailConfig);
        return msg;
    }

    @Override
    public String edit(EmailConfig elsEmailConfig) {
        if (CharSequenceUtil.isEmpty((CharSequence)elsEmailConfig.getElsAccount())) {
            elsEmailConfig.setElsAccount(SrmUtil.getLoginUser().getElsAccount());
        }
        this.emailSetting(elsEmailConfig);
        String msg = elsEmailConfig.getErrorMsg();
        int count = ((EmailConfigMapper)this.baseMapper).updateById((Object)elsEmailConfig);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        return msg;
    }

    @Override
    public void delete(String id) {
        ((EmailConfigMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((EmailConfigMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public EmailConfigDTO getEmailConfig(String elsAccount) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(ParentEntity::getElsAccount, (Object)elsAccount)).eq(EmailConfig::getEmailStatus, (Object)EmailStatusEnum.ENABLED.getValue())).eq(EmailConfig::getEnabled, (Object)"1")).orderByDesc(EmailConfig::getEmailWeight);
        List list = ((EmailConfigMapper)this.baseMapper).selectList((Wrapper)wrapper);
        if (null == list && !"100000".equals(elsAccount)) {
            wrapper.clear();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(ParentEntity::getElsAccount, (Object)"100000")).eq(EmailConfig::getEmailStatus, (Object)EmailStatusEnum.ENABLED.getValue())).eq(EmailConfig::getEnabled, (Object)"1")).orderByDesc(EmailConfig::getEmailWeight);
            list = ((EmailConfigMapper)this.baseMapper).selectList((Wrapper)wrapper);
        }
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        EmailConfig elsEmailConfig = this.selectConfig(list);
        return (EmailConfigDTO)Convert.convert(EmailConfigDTO.class, (Object)((Object)elsEmailConfig));
    }

    private EmailConfig selectConfig(List<EmailConfig> elsEmailConfig) {
        int totalWeight = elsEmailConfig.stream().mapToInt(EmailConfig::getEmailWeight).sum();
        int randomIndex = -1;
        double randomValue = new Random().nextDouble() * (double)totalWeight;
        for (int i = 0; i < elsEmailConfig.size(); ++i) {
            if (!((randomValue -= (double)elsEmailConfig.get(i).getEmailWeight().intValue()) <= 0.0)) continue;
            randomIndex = i;
            break;
        }
        if (randomIndex != -1) {
            return elsEmailConfig.get(randomIndex);
        }
        return elsEmailConfig.get(0);
    }

    @Override
    public List<EmailConfigDTO> getEmailConfigs(String elsAccount) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(ParentEntity::getElsAccount, (Object)elsAccount)).eq(EmailConfig::getEmailStatus, (Object)EmailStatusEnum.ENABLED.getValue())).eq(EmailConfig::getEnabled, (Object)"1")).orderByDesc(EmailConfig::getEmailWeight);
        List elsEmailConfigs = ((EmailConfigMapper)this.baseMapper).selectList((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)elsEmailConfigs) && !"100000".equals(elsAccount)) {
            wrapper.clear();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(ParentEntity::getElsAccount, (Object)"100000")).eq(EmailConfig::getEmailStatus, (Object)EmailStatusEnum.ENABLED.getValue())).eq(EmailConfig::getEnabled, (Object)"1")).orderByDesc(EmailConfig::getEmailWeight);
            elsEmailConfigs = ((EmailConfigMapper)this.baseMapper).selectList((Wrapper)wrapper);
        }
        Collections.shuffle(elsEmailConfigs);
        return Convert.toList(EmailConfigDTO.class, (Object)elsEmailConfigs);
    }

    @Override
    public void updateEmailConfigWeight() {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.select(new SFunction[]{ParentEntity::getElsAccount, EmailSendLog::getEmailConfigId});
        ((LambdaQueryWrapper)wrapper.eq(EmailSendLog::getEmailSendStatus, (Object)"1")).ge(BaseEntity::getUpdateTime, (Object)DateUtil.offsetMinute((Date)new Date(), (int)-59));
        List emailSendLogs = this.emailSendLogMapper.selectList((Wrapper)wrapper);
        Map<String, Long> countMap = emailSendLogs.stream().filter(x -> CharSequenceUtil.isNotEmpty((CharSequence)x.getEmailConfigId())).collect(Collectors.toMap(EmailSendLog::getEmailConfigId, id -> 1L, Long::sum));
        if (countMap.isEmpty()) {
            return;
        }
        long allCount = countMap.values().stream().reduce(Long::sum).get();
        Set<String> configIds = countMap.keySet();
        ArrayList newConfig = Lists.newArrayList();
        for (String id2 : configIds) {
            long count = countMap.get(id2) * 100L / allCount;
            int newWeight = (int)Math.min(Math.max(1L, count), 100L);
            EmailConfig c = new EmailConfig();
            c.setId(id2);
            c.setEmailWeight(newWeight);
            newConfig.add(c);
        }
        this.updateBatchById(newConfig);
    }

    @Override
    public Map<String, List<EmailConfigDTO>> mapEmailConfigs(String elsAccount) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.in(ParentEntity::getElsAccount, (Collection)Lists.newArrayList((Object[])new String[]{elsAccount, ConfigUtil.getPurchaseAccount(), "100000"}))).eq(EmailConfig::getEmailStatus, (Object)EmailStatusEnum.ENABLED.getValue())).eq(EmailConfig::getEnabled, (Object)"1")).orderByDesc(EmailConfig::getEmailWeight);
        List elsEmailConfigs = ((EmailConfigMapper)this.baseMapper).selectList((Wrapper)wrapper);
        List emailConfigDTOS = Convert.toList(EmailConfigDTO.class, (Object)elsEmailConfigs);
        return emailConfigDTOS.stream().collect(Collectors.groupingBy(BaseDTO::getElsAccount));
    }
}

