/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.im.controller;

import com.els.common.api.vo.Result;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.common.util.SrmUtil;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.im.entity.ImUserGroup;
import com.els.modules.im.service.IImUserFriendService;
import com.els.modules.im.service.IImUserGroupService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u7528\u6237\u5206\u7ec4\u7ba1\u7406")
@RestController
@RequestMapping(value={"/im/userGroup"})
public class ImUserGroupController {
    private static final Logger log = LoggerFactory.getLogger(ImUserGroupController.class);
    @Resource
    private IImUserFriendService imUserFriendService;
    @Resource
    private IImUserGroupService imUserGroupServiceImpl;

    @Operation(summary="\u6dfb\u52a0\u5206\u7ec4", description="\u6dfb\u52a0\u5206\u7ec4")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestParam(name="groupName") String groupName) {
        LoginUserDTO sysUser = SrmUtil.getLoginUser();
        if (groupName.length() > 100) {
            throw new ELSBootException(I18nUtil.translate((String)"\u5206\u7ec4\u540d\u79f0\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7100"));
        }
        ImUserGroup imGroup = this.imUserGroupServiceImpl.addGroup(sysUser.getId(), groupName);
        return Result.ok((Object)((Object)imGroup));
    }

    @Operation(summary="\u5206\u7ec4\u91cd\u547d\u540d", description="\u5206\u7ec4\u91cd\u547d\u540d")
    @PostMapping(value={"/rename"})
    public Result<?> rename(@RequestParam(name="groupId") String groupId, @RequestParam(name="groupName") String groupName) {
        LoginUserDTO sysUser = SrmUtil.getLoginUser();
        if (groupName.length() > 100) {
            throw new ELSBootException(I18nUtil.translate((String)"\u5206\u7ec4\u540d\u79f0\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7100"));
        }
        this.imUserGroupServiceImpl.rename(groupId, sysUser.getId(), groupName);
        return Result.ok();
    }

    @Operation(summary="\u5220\u9664\u5206\u7ec4", description="\u5220\u9664\u5206\u7ec4")
    @PostMapping(value={"/delete"})
    public Result<?> deleteGroup(@RequestParam(name="groupId") String groupId) {
        LoginUserDTO sysUser = SrmUtil.getLoginUser();
        this.imUserGroupServiceImpl.deleteGroup(sysUser.getId(), groupId);
        return Result.ok();
    }

    @Operation(summary="\u5f02\u52a8\u5206\u7ec4", description="\u5f02\u52a8\u5206\u7ec4")
    @PostMapping(value={"/moveFriendToGroup"})
    public Result<?> moveFriendToGroup(@RequestParam(name="friendId") String friendId, @RequestParam(name="groupId") String groupId) {
        LoginUserDTO sysUser = SrmUtil.getLoginUser();
        this.imUserFriendService.moveFriendToGroup(sysUser.getId(), friendId, groupId);
        return Result.ok();
    }

    @Operation(summary="\u5206\u7ec4\u4e0a\u4e0b\u79fb\u52a8", description="\u5206\u7ec4\u4e0a\u4e0b\u79fb\u52a8")
    @PostMapping(value={"/groupUpAndDown"})
    public Result<?> groupUpAndDown(@RequestParam(name="moveGroupId") String moveGroupId, @RequestParam(name="targetGroupId") String targetGroupId) {
        LoginUserDTO sysUser = SrmUtil.getLoginUser();
        this.imUserGroupServiceImpl.groupUpAndDown(sysUser.getId(), moveGroupId, targetGroupId);
        return Result.ok();
    }

    @Operation(summary="\u5206\u7ec4\u62d6\u62fd", description="\u5206\u7ec4\u62d6\u62fd")
    @PostMapping(value={"/groupDrag"})
    public Result<?> groupDrag(@RequestBody List<String> imGroups) {
        LoginUserDTO sysUser = SrmUtil.getLoginUser();
        this.imUserGroupServiceImpl.groupDrag(sysUser.getId(), imGroups);
        return Result.ok();
    }
}

