/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.im.core.server.handler.third;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.els.common.util.ConfigUtil;
import com.els.common.util.IPaasUtil;
import com.els.modules.im.core.packets.ImUserPackets;
import com.els.modules.im.core.packets.WsMessageDataPackets;
import com.els.modules.im.core.packets.WsMessagePackets;
import com.els.modules.im.core.server.handler.Opt;
import com.els.modules.im.core.server.handler.third.BaseImToThirdService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.function.Consumer;
import org.apache.commons.lang3.tuple.Triple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.tio.core.ChannelContext;
import org.tio.websocket.common.WsRequest;

@Service
public class ImToTencentLkeService
extends BaseImToThirdService {
    private static final Logger log = LoggerFactory.getLogger(ImToTencentLkeService.class);

    @Override
    public String type() {
        return "tencentLke";
    }

    @Override
    public void sendMessageToThirdAndReplay(WsMessageDataPackets message, final WsRequest wsRequest, String userid, Consumer<Triple<WsRequest, String, ChannelContext>> reCall) {
        JSONObject tencentLke;
        if (this.IGNORE.contains(message.getMessageType())) {
            return;
        }
        log.info("tencentLke\u81ea\u52a8\u56de\u590d\u83b7\u53d6\u56de\u590d\u6570\u636e");
        int hashCode = message.getMessageContent().hashCode();
        String key = "srm:im:ai_robot:" + this.type() + ":" + message.getId() + ":" + hashCode;
        Object obj = this.redisUtil.get(key);
        if (obj != null) {
            tencentLke = JSONObject.parseObject((String)JSON.toJSONString((Object)obj));
        } else {
            JSONObject requestJson = this.buildJSONObject(message, ConfigUtil.getPurchaseAccount(), userid);
            JSONObject result = IPaasUtil.callIPaasInterface((JSONObject)requestJson, (String)"valueAddedApplication", (String)"chat-tencentLke");
            tencentLke = this.analysisResult(result);
            if (null != tencentLke) {
                this.redisUtil.set(key, (Object)tencentLke, 259200L);
            } else {
                this.sendNoPermission(message, wsRequest, userid, result.getString("message"), reCall);
                return;
            }
        }
        if (null == tencentLke) {
            return;
        }
        ImUserPackets imUser = this.srmBusinessHelper.loadLoginUserId(message.getId());
        if (null == imUser) {
            return;
        }
        if (tencentLke.containsKey("error")) {
            tencentLke = this.buildError(tencentLke.getString("error"));
        }
        log.info("{}\u81ea\u52a8\u56de\u590d\u83b7\u53d6\u56de\u590d\u6570\u636e\u5373\u5c06\u56de\u590d", (Object)this.type());
        final ChannelContext cc = this.srmBusinessHelper.getChannelContextByUserId(userid);
        if (null == cc) {
            log.error("\u7528\u6237\u5728\u7ebf\u72b6\u6001\u5f02\u5e38");
            return;
        }
        ArrayList choices = Lists.newArrayList((Object[])new JSONObject[]{tencentLke});
        for (JSONObject objects : choices) {
            String content = objects.getString("content");
            final WsMessagePackets sendInfo = new WsMessagePackets();
            sendInfo.setConnCode(Opt.KEFU_MSG_MESSAGE.getValue());
            WsMessageDataPackets messageInfo = new WsMessageDataPackets();
            messageInfo.setId(message.getMessageFromId());
            messageInfo.setMessageFromId(message.getMessageToId());
            messageInfo.setRealname("\u673a\u667a\u7684\u5c0f\u4f01");
            messageInfo.setHeadPortrait("/kefu/static/robot.png");
            messageInfo.setMessageContent(content);
            messageInfo.setMine(false);
            messageInfo.setMessageType("text");
            messageInfo.setMessageReplyByRobot("1");
            messageInfo.setMessageSendTime((Date)DateUtil.date());
            messageInfo.setMessageChatType(message.getMessageChatType());
            sendInfo.setMessage(messageInfo);
            log.info(":::\u6536\u5230\u7684\u6d88\u606f:{},{}\u81ea\u52a8\u56de\u590d\u7684\u6d88\u606f:{}", new Object[]{this.type(), message, sendInfo});
            if (cc.isClosed) continue;
            reCall.accept(new Triple<WsRequest, String, ChannelContext>(){

                public WsRequest getLeft() {
                    return wsRequest;
                }

                public String getMiddle() {
                    return JSON.toJSONString((Object)sendInfo);
                }

                public ChannelContext getRight() {
                    return cc;
                }
            });
        }
    }

    private JSONObject buildJSONObject(WsMessageDataPackets message, String elsAccount, String userId) {
        JSONObject param = new JSONObject();
        param.put((Object)"content", (Object)message.getMessageContent());
        param.put((Object)"currentAccount", (Object)elsAccount);
        param.put((Object)"session_id", (Object)("v7" + userId));
        param.put((Object)"visitor_biz_id", (Object)("v7" + userId));
        return param;
    }

    private JSONObject buildError(String errorMsg) {
        JSONObject param = new JSONObject();
        JSONObject choiceObj = new JSONObject();
        JSONObject message = new JSONObject();
        message.put((Object)"content", (Object)errorMsg);
        choiceObj.put((Object)"message", (Object)message);
        JSONArray choices = new JSONArray();
        choices.add((Object)choiceObj);
        param.put((Object)"choices", (Object)choices);
        return param;
    }

    @Override
    protected JSONObject analysisResult(JSONObject object) {
        if ("200".equals(object.getString("code"))) {
            String data = object.getJSONObject("data").getString("data");
            List<JSONObject> linesList = Arrays.stream(data.split("\n")).filter(x -> CharSequenceUtil.isNotEmpty((CharSequence)x) && x.contains("\"type\":\"reply\",\"payload\":{\"can_feedback\":false,\"can_rating\":true")).map(x -> JSONObject.parseObject((String)x.replaceFirst("data:", ""))).toList();
            JSONObject replay = null;
            if (linesList.size() == 0) {
                return null;
            }
            replay = linesList.get(linesList.size() - 1);
            if (null != replay) {
                replay.getJSONObject("payload");
            }
            return replay;
        }
        return null;
    }
}

