/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.justauth.controller;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.els.common.api.vo.Result;
import com.els.common.exception.ELSBootException;
import com.els.common.util.AdminFlagUtil;
import com.els.common.util.ExternalUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.entity.ExternalVoucher;
import com.els.modules.account.service.ExternalVoucherService;
import com.els.modules.integration.api.dto.ExternalVoucherDto;
import com.els.modules.justauth.aes.WechatMessageUtil;
import com.els.modules.justauth.util.ThirdAuthUtil;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.annotation.Resource;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import me.chanjar.weixin.mp.api.WxMpMessageRouter;
import me.chanjar.weixin.mp.bean.message.WxMpXmlMessage;
import me.chanjar.weixin.mp.bean.message.WxMpXmlOutMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/base/wechatMp"})
public class WechatMpController {
    private static final Logger log = LoggerFactory.getLogger(WechatMpController.class);
    @Resource
    private ExternalVoucherService externalVoucherService;
    @Resource
    @Lazy
    private WxMpMessageRouter wxMpMessageRouter;
    private static final String WE_CHAT_TOKEN = "Droo3C5oiomm5G1z";

    @RequestMapping(value={"/noToken/signature/{busAccount}"})
    public void weChatMpSignature(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="busAccount") String busAccount) {
        ExternalVoucher config = this.externalVoucherService.getOneBindLoginTemplateConfig(busAccount, "wechat_mp");
        if (null == config) {
            try {
                response.getWriter().print("");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        JSONObject jsonObject = JSONObject.parseObject((String)CharSequenceUtil.emptyToDefault((CharSequence)config.getExtendParam(), (String)"{}"));
        String wechatToken = jsonObject.getString("token");
        String signature = request.getParameter("signature");
        String timestamp = request.getParameter("timestamp");
        String nonce = request.getParameter("nonce");
        String echostr = request.getParameter("echostr");
        if (StrUtil.isNotBlank((CharSequence)echostr)) {
            this.wechatSignature(response, wechatToken, signature, timestamp, nonce, echostr);
        } else {
            this.handleMp(request, response, busAccount, config);
        }
    }

    @Operation(summary="\u5fae\u4fe1\u516c\u4f17\u53f7-\u516c\u4f17\u53f7\u521b\u5efa\u670d\u52a1\u7aef\u83dc\u5355\u6837\u4f8b", description="\u5fae\u4fe1\u516c\u4f17\u53f7-\u516c\u4f17\u53f7\u521b\u5efa\u670d\u52a1\u7aef\u83dc\u5355\u6837\u4f8b")
    @GetMapping(value={"/menu/example"})
    public Result<?> create() {
        JSONObject body = new JSONObject();
        JSONArray button = new JSONArray();
        JSONObject about = new JSONObject();
        about.put((Object)"name", (Object)"\u83dc\u5355\u4fe1\u606f");
        JSONArray subButton = new JSONArray();
        JSONObject officialWebsite = new JSONObject();
        officialWebsite.put((Object)"type", (Object)"view");
        officialWebsite.put((Object)"name", (Object)"\u5b50\u83dc\u53551");
        officialWebsite.put((Object)"url", (Object)"http://www.baidu.com");
        subButton.add((Object)officialWebsite);
        officialWebsite = new JSONObject();
        officialWebsite.put((Object)"type", (Object)"view");
        officialWebsite.put((Object)"name", (Object)"\u5b50\u83dc\u53552");
        officialWebsite.put((Object)"url", (Object)"http://www.baidu.com");
        subButton.add((Object)officialWebsite);
        officialWebsite = new JSONObject();
        officialWebsite.put((Object)"type", (Object)"view");
        officialWebsite.put((Object)"name", (Object)"\u5b50\u83dc\u53553");
        officialWebsite.put((Object)"url", (Object)"http://www.baidu.com");
        subButton.add((Object)officialWebsite);
        officialWebsite = new JSONObject();
        officialWebsite.put((Object)"type", (Object)"view");
        officialWebsite.put((Object)"name", (Object)"\u5b50\u83dc\u53554");
        officialWebsite.put((Object)"url", (Object)"http://www.baidu.com");
        subButton.add((Object)officialWebsite);
        officialWebsite = new JSONObject();
        officialWebsite.put((Object)"type", (Object)"click");
        officialWebsite.put((Object)"name", (Object)"\u70b9\u51fb\u53d1\u6d88\u606f");
        officialWebsite.put((Object)"key", (Object)"MY_SEND_MESSAGE");
        subButton.add((Object)officialWebsite);
        about.put((Object)"sub_button", (Object)subButton);
        button.add((Object)about);
        JSONObject joinMe = new JSONObject();
        joinMe.put((Object)"type", (Object)"view");
        joinMe.put((Object)"name", (Object)"\u4e2d\u95f4\u83dc\u5355");
        joinMe.put((Object)"url", (Object)"http://www.baidu.com");
        button.add((Object)joinMe);
        about = new JSONObject();
        about.put((Object)"name", (Object)"\u5176\u4ed6\u83dc\u5355");
        subButton = new JSONArray();
        officialWebsite = new JSONObject();
        officialWebsite.put((Object)"type", (Object)"view");
        officialWebsite.put((Object)"name", (Object)"\u5b98\u7f51");
        officialWebsite.put((Object)"url", (Object)"http://www.baidu.com");
        subButton.add((Object)officialWebsite);
        about.put((Object)"sub_button", (Object)subButton);
        button.add((Object)about);
        body.put((Object)"button", (Object)button);
        return Result.ok((Object)body);
    }

    @Operation(summary="\u5fae\u4fe1\u516c\u4f17\u53f7-\u516c\u4f17\u53f7\u521b\u5efa\u670d\u52a1\u7aef\u83dc\u5355", description="\u5fae\u4fe1\u516c\u4f17\u53f7-\u516c\u4f17\u53f7\u521b\u5efa\u670d\u52a1\u7aef\u83dc\u5355")
    @PostMapping(value={"/menu/create"})
    public Result<?> createMenu(@RequestBody JSONObject body) {
        String adminFlag = AdminFlagUtil.getAdminFlag();
        if (!"1".equals(adminFlag)) {
            throw new ELSBootException("\u6743\u9650\u4e0d\u8db3");
        }
        ExternalVoucherDto config = ExternalUtil.getVoucher((String)TenantContext.getTenant(), (String)"wechat_mp");
        String accessToken = ThirdAuthUtil.getWechatMpToken(TenantContext.getTenant(), config);
        String url = "https://api.weixin.qq.com/cgi-bin/menu/create?access_token=" + accessToken;
        HttpUtil.post((String)url, (String)body.toString());
        return Result.ok();
    }

    @Operation(summary="\u5fae\u4fe1\u516c\u4f17\u53f7-\u516c\u4f17\u53f7\u5220\u9664\u670d\u52a1\u7aef\u83dc\u5355", description="\u5fae\u4fe1\u516c\u4f17\u53f7-\u516c\u4f17\u53f7\u5220\u9664\u670d\u52a1\u7aef\u83dc\u5355")
    @PostMapping(value={"/menu/delete"})
    public Result<?> delete() {
        String adminFlag = AdminFlagUtil.getAdminFlag();
        if (!"1".equals(adminFlag)) {
            throw new ELSBootException("\u6743\u9650\u4e0d\u8db3");
        }
        ExternalVoucherDto config = ExternalUtil.getVoucher((String)TenantContext.getTenant(), (String)"wechat_mp");
        String accessToken = ThirdAuthUtil.getWechatMpToken(TenantContext.getTenant(), config);
        String url = "https://api.weixin.qq.com/cgi-bin/menu/delete?access_token=" + accessToken;
        HttpUtil.get((String)url);
        return Result.ok();
    }

    private void handleMp(HttpServletRequest request, HttpServletResponse response, String busAccount, ExternalVoucher config) {
        try (ServletInputStream is = request.getInputStream();
             InputStreamReader isr = new InputStreamReader((InputStream)is, StandardCharsets.UTF_8);
             BufferedReader br = new BufferedReader(isr);){
            String str;
            StringBuilder returnXml = new StringBuilder();
            while ((str = br.readLine()) != null) {
                returnXml.append(str);
            }
            WxMpXmlMessage wxMpXmlMessage = WxMpXmlMessage.fromXml((String)returnXml.toString());
            wxMpXmlMessage.getAllFieldsMap().put("busAccount", busAccount);
            wxMpXmlMessage.getAllFieldsMap().put("configParam", config.getExtendParam());
            WxMpXmlOutMessage outMessage = this.wxMpMessageRouter.route(config.getVoucherKey(), wxMpXmlMessage);
            if (null == outMessage) {
                response.getWriter().print("");
                return;
            }
            response.setCharacterEncoding("UTF-8");
            response.getWriter().print(outMessage.toXml());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void wechatSignature(HttpServletResponse response, String wechatToken, String signature, String timestamp, String nonce, String echostr) {
        try (PrintWriter out = response.getWriter();){
            if (WechatMpController.checkSignature(wechatToken, signature, timestamp, nonce)) {
                out.print(echostr);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static boolean checkSignature(String wechatToken, String signature, String timestamp, String nonce) {
        Object[] arr = new String[]{wechatToken, timestamp, nonce};
        Arrays.sort(arr);
        StringBuilder content = new StringBuilder();
        for (Object s : arr) {
            content.append((String)s);
        }
        String tmpStr = null;
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            byte[] digest = md.digest(content.toString().getBytes());
            tmpStr = WechatMessageUtil.byteToStr(digest);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return CharSequenceUtil.isNotEmpty(tmpStr) ? tmpStr.equals(signature.toUpperCase()) : false;
    }
}

