/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.justauth.util;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Base64;
import java.util.HashMap;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QRCodeUtil {
    private static final Logger log = LoggerFactory.getLogger(QRCodeUtil.class);
    private static final String BASE_64_URL = "data:image/png;base64,";

    public static String createQRCode(String json) throws IOException, WriterException {
        QRCodeWriter qrCodeWriter = new QRCodeWriter();
        HashMap<EncodeHintType, String> hints = new HashMap<EncodeHintType, String>(2);
        hints.put(EncodeHintType.CHARACTER_SET, "utf-8");
        BitMatrix bitMatrix = qrCodeWriter.encode(json, BarcodeFormat.QR_CODE, 600, 600, hints);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        BufferedImage bufferedImage = new BufferedImage(bitMatrix.getWidth(), bitMatrix.getHeight(), 1);
        for (int x = 0; x < bitMatrix.getWidth(); ++x) {
            for (int y = 0; y < bitMatrix.getHeight(); ++y) {
                bufferedImage.setRGB(x, y, bitMatrix.get(x, y) ? 0 : 0xFFFFFF);
            }
        }
        ImageIO.write((RenderedImage)bufferedImage, "png", outputStream);
        Base64.Encoder encoder = Base64.getEncoder();
        String text = encoder.encodeToString(outputStream.toByteArray());
        return BASE_64_URL + text;
    }
}

