/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.exception.ELSBootException;
import com.els.common.system.api.CommonAPI;
import com.els.common.system.vo.ComboModel;
import com.els.common.system.vo.DictModel;
import com.els.common.util.ConvertUtils;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.entity.Role;
import com.els.modules.system.mapper.ElsSubAccountMapper;
import com.els.modules.system.mapper.RoleMapper;
import com.els.modules.system.mapper.UserRoleMapper;
import com.els.modules.system.rpc.service.InvokeBaseRpcService;
import com.els.modules.system.service.PermissionGroupService;
import com.els.modules.system.service.UserPermissionGroupService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class BaseApiImpl
implements CommonAPI {
    private static final Logger log = LoggerFactory.getLogger(BaseApiImpl.class);
    private static String DB_TYPE = "";
    @Resource
    private ElsSubAccountMapper userMapper;
    @Resource
    private UserRoleMapper userRoleMapper;
    @Resource
    private RoleMapper roleMapper;
    @Resource
    private InvokeBaseRpcService baseDubboService;
    @Resource
    private UserPermissionGroupService userPermissionGroupService;
    @Resource
    private PermissionGroupService permissionGroupService;

    public void addLog(String LogContent, Integer logType, Integer operatetype) {
    }

    public LoginUserDTO getUserById(String id) {
        if (ConvertUtils.isEmpty((Object)id)) {
            return null;
        }
        LoginUserDTO loginUser = new LoginUserDTO();
        ElsSubAccount sysUser = (ElsSubAccount)((Object)this.userMapper.selectById((Serializable)((Object)id)));
        if (sysUser == null) {
            return null;
        }
        BeanUtils.copyProperties((Object)((Object)sysUser), (Object)loginUser);
        return loginUser;
    }

    public List<String> getRolesByUsername(String elsAccount, String subAccount) {
        return this.userRoleMapper.getRoleByUserName(elsAccount, subAccount);
    }

    public String getDatabaseType() {
        DataSource dataSource = (DataSource)SpringContextUtils.getApplicationContext().getBean(DataSource.class);
        return this.getDatabaseTypeByDataSource(dataSource);
    }

    public List<DictModel> queryDictItemsByCode(String code) {
        return null;
    }

    public List<DictModel> queryTableDictItemsByCode(String table, String text, String code) throws Exception {
        return null;
    }

    public List<DictModel> queryAllDepartBackDictModel() {
        return null;
    }

    private String getDatabaseTypeByDataSource(DataSource dataSource) {
        block13: {
            if ("".equals(DB_TYPE)) {
                try (Connection connection = dataSource.getConnection();){
                    DatabaseMetaData md = connection.getMetaData();
                    String dbType = md.getDatabaseProductName().toLowerCase();
                    if (dbType.contains("mysql")) {
                        DB_TYPE = "MYSQL";
                        break block13;
                    }
                    if (dbType.contains("oracle")) {
                        DB_TYPE = "ORACLE";
                        break block13;
                    }
                    if (dbType.contains("sqlserver") || dbType.contains("sql server")) {
                        DB_TYPE = "SQLSERVER";
                        break block13;
                    }
                    if (dbType.contains("postgresql")) {
                        DB_TYPE = "POSTGRESQL";
                        break block13;
                    }
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_WFGAcWWWWWWWWWxKqW_1e7f934a", (String)"\u6570\u636e\u5e93\u7c7b\u578b:[ ${0} ]\u4e0d\u8bc6\u522b!", (String[])new String[]{dbType}));
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return DB_TYPE;
    }

    public List<DictModel> queryAllDict() {
        return null;
    }

    public List<DictModel> queryFilterTableDictInfo(String table, String text, String code, String filterSql) {
        return null;
    }

    public List<ComboModel> queryAllUser() {
        ArrayList<ComboModel> list = new ArrayList<ComboModel>();
        List userList = this.userMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"status", (Object)"1")).eq((Object)"is_deleted", (Object)"0"));
        for (ElsSubAccount user : userList) {
            ComboModel model = new ComboModel();
            model.setTitle(user.getRealname());
            model.setId(user.getId());
            list.add(model);
        }
        return list;
    }

    public List<ComboModel> queryAllUser(String[] userIds) {
        ArrayList<ComboModel> list = new ArrayList<ComboModel>();
        List userList = this.userMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"status", (Object)"1")).eq((Object)"is_deleted", (Object)"0"));
        for (ElsSubAccount user : userList) {
            ComboModel model = new ComboModel();
            model.setUsername(user.getSubAccount());
            model.setTitle(user.getRealname());
            model.setId(user.getId());
            if (ConvertUtils.isNotEmpty((Object)userIds)) {
                for (String userId : userIds) {
                    if (!userId.equals(user.getId())) continue;
                    model.setChecked(true);
                }
            }
            list.add(model);
        }
        return list;
    }

    public List<ComboModel> queryAllRole() {
        ArrayList<ComboModel> list = new ArrayList<ComboModel>();
        List roleList = this.roleMapper.selectList((Wrapper)new QueryWrapper());
        for (Role role : roleList) {
            ComboModel model = new ComboModel();
            model.setTitle(role.getRoleName());
            model.setId(role.getId());
            list.add(model);
        }
        return list;
    }

    public List<ComboModel> queryAllRole(String[] roleIds) {
        ArrayList<ComboModel> list = new ArrayList<ComboModel>();
        List roleList = this.roleMapper.selectList((Wrapper)new QueryWrapper());
        for (Role role : roleList) {
            ComboModel model = new ComboModel();
            model.setTitle(role.getRoleName());
            model.setId(role.getId());
            if (ConvertUtils.isNotEmpty((Object)roleIds)) {
                for (String roleId : roleIds) {
                    if (!roleId.equals(role.getId())) continue;
                    model.setChecked(true);
                }
            }
            list.add(model);
        }
        return list;
    }

    public List<String> getRoleIdsByUsername(String elsAccount, String subAccount) {
        return this.userRoleMapper.getRoleIdByUserName(elsAccount, subAccount);
    }
}

