/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.message.api.dto.MsgConfigItemDTO;
import com.els.modules.quartz.entity.QuartzJob;
import com.els.modules.quartz.service.IQuartzJobService;
import com.els.modules.system.entity.ElsAlertConfig;
import com.els.modules.system.mapper.ElsAlertConfigMapper;
import com.els.modules.system.rpc.service.JobInvokeMessageRpcService;
import com.els.modules.system.service.ElsAlertConfigService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.List;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ElsAlertConfigServiceImpl
extends ServiceImpl<ElsAlertConfigMapper, ElsAlertConfig>
implements ElsAlertConfigService {
    private static final Logger log = LoggerFactory.getLogger(ElsAlertConfigServiceImpl.class);
    @Resource
    private JobInvokeMessageRpcService msgConfigRpcService;
    @Autowired
    private IQuartzJobService quartzJobService;
    private final String JOB_CLASS = "com.els.modules.quartz.job.AlertJob";
    private final String SPLIT_CHAR = ":";

    @Override
    @SrmTransaction
    public void saveElsAlertConfig(ElsAlertConfig elsAlertConfig, List<MsgConfigItemDTO> elsMsgConfigItemList) {
        this.checkParam(elsAlertConfig);
        ((ElsAlertConfigMapper)this.baseMapper).insert((Object)elsAlertConfig);
        if (elsMsgConfigItemList != null && !elsMsgConfigItemList.isEmpty()) {
            for (MsgConfigItemDTO item : elsMsgConfigItemList) {
                item.setHeadId(elsAlertConfig.getId());
                item.setElsAccount(elsAlertConfig.getElsAccount());
                item.setDeleted(CommonConstant.DEL_FLAG_0);
            }
            this.msgConfigRpcService.save(elsMsgConfigItemList);
        }
        this.generateJob(elsAlertConfig);
    }

    private void checkParam(ElsAlertConfig elsAlertConfig) {
        if (StrUtil.isEmpty((CharSequence)elsAlertConfig.getAlertFrequency())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_UONIxOLVW_114317f9", (String)"\u9884\u8b66\u9891\u7387\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        if (elsAlertConfig.getAlertDays() == null) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_UODPSWxOLVW_37263fab", (String)"\u9884\u8b66\u63d0\u524d\u5929\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        if (StrUtil.isEmpty((CharSequence)elsAlertConfig.getAlertTime())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_UODcKIxOLVW_91e439cf", (String)"\u9884\u8b66\u63d0\u9192\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
    }

    @Override
    @SrmTransaction
    public void updateElsAlertConfig(ElsAlertConfig elsAlertConfig, List<MsgConfigItemDTO> elsMsgConfigItemList) {
        log.info("enter_into_updateElsAlertConfig");
        this.checkParam(elsAlertConfig);
        ((ElsAlertConfigMapper)this.baseMapper).updateById((Object)elsAlertConfig);
        this.msgConfigRpcService.delete(elsAlertConfig.getId());
        this.msgConfigRpcService.deleteByMainId(elsAlertConfig.getId());
        log.info("elsMsgConfigItemList_size:" + elsMsgConfigItemList.size());
        if (elsMsgConfigItemList != null && !elsMsgConfigItemList.isEmpty()) {
            for (MsgConfigItemDTO item : elsMsgConfigItemList) {
                item.setHeadId(elsAlertConfig.getId());
                item.setElsAccount(elsAlertConfig.getElsAccount());
                item.setDeleted(CommonConstant.DEL_FLAG_0);
            }
            this.msgConfigRpcService.save(elsMsgConfigItemList);
        }
        this.generateJob(elsAlertConfig);
    }

    private void generateJob(ElsAlertConfig alertConfig) {
        String cornExpression = this.getCronExpression(alertConfig);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"job_class_name", (Object)"com.els.modules.quartz.job.AlertJob");
        queryWrapper.eq((Object)"parameter", (Object)alertConfig.getId());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        List list = this.quartzJobService.list((Wrapper)queryWrapper);
        if (list.size() > 0) {
            QuartzJob quartzJob = (QuartzJob)((Object)list.get(0));
            quartzJob.setCronExpression(cornExpression);
            try {
                this.quartzJobService.editAndScheduleJob(quartzJob);
            }
            catch (SchedulerException e) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_crIKLSGN_be976a4c", (String)"\u4fee\u6539\u5b9a\u65f6\u4efb\u52a1\u51fa\u9519"));
            }
        } else {
            QuartzJob quartzJob = new QuartzJob();
            quartzJob.setCronExpression(cornExpression);
            quartzJob.setDescription("\u9884\u8b66\u5b9a\u65f6\u4efb\u52a1\uff0c\u7531\u7cfb\u7edf\u9884\u8b66\u914d\u7f6e\u81ea\u52a8\u751f\u6210");
            quartzJob.setJobClassName("com.els.modules.quartz.job.AlertJob");
            quartzJob.setParameter(alertConfig.getId());
            quartzJob.setJobNameKey("com.els.modules.quartz.job.AlertJob" + alertConfig.getId());
            quartzJob.setStatus(CommonConstant.STATUS_NORMAL);
            quartzJob.setElsAccount(TenantContext.getTenant());
            this.quartzJobService.saveAndScheduleJob(quartzJob);
        }
    }

    private String getCronExpression(ElsAlertConfig alertConfig) {
        String[] alertTimes = alertConfig.getAlertTime().split(":");
        if (alertTimes.length != 3) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_DcKImKxIWdL_7eae32b3", (String)"\u63d0\u9192\u65f6\u95f4\u683c\u5f0f\u4e0d\u5bf9\uff0c\u5e94\u4e3a\uff1a") + "hh:mm:ss");
        }
        String hour = alertConfig.getAlertTime().split(":")[0];
        String min = alertConfig.getAlertTime().split(":")[1];
        String sec = alertConfig.getAlertTime().split(":")[2];
        return sec + " " + min + " " + hour + " * * ?";
    }

    @Override
    @SrmTransaction
    public void delElsAlertConfig(String id) {
        ((ElsAlertConfigMapper)this.baseMapper).deleteById((Serializable)((Object)id));
        this.msgConfigRpcService.delete(id);
        this.deleteJob(id);
    }

    private void deleteJob(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"job_class_name", (Object)"com.els.modules.quartz.job.AlertJob");
        queryWrapper.eq((Object)"parameter", (Object)id);
        List list = this.quartzJobService.list((Wrapper)queryWrapper);
        if (list.size() > 0) {
            this.quartzJobService.deleteAndStopJob((QuartzJob)((Object)list.get(0)));
        }
    }

    @Override
    public void delBatchElsAlertConfig(List<String> idList) {
        for (String id : idList) {
            this.delElsAlertConfig(id);
        }
    }

    @Override
    @SrmTransaction
    public void addBy100000(String id) {
        ElsAlertConfig config = (ElsAlertConfig)((Object)((ElsAlertConfigMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        List<MsgConfigItemDTO> itemList = this.msgConfigRpcService.findListByMainId(id);
        config.setId(null);
        config.setCreateBy(null);
        config.setCreateTime(null);
        config.setUpdateBy(null);
        config.setUpdateTime(null);
        config.setNoticeRole(null);
        config.setNoticeUser(null);
        config.setNoticePrincipal(null);
        config.setNoticeToPrincipal(null);
        config.setEnableStatus("inactive");
        config.setElsAccount(TenantContext.getTenant());
        ((ElsAlertConfigMapper)this.baseMapper).insert((Object)config);
        for (MsgConfigItemDTO item : itemList) {
            item.setId(null);
            item.setHeadId(config.getId());
            item.setElsAccount(TenantContext.getTenant());
            item.setDeleted(CommonConstant.DEL_FLAG_0);
        }
        this.msgConfigRpcService.save(itemList);
    }
}

