/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.barcode.service.impl;

import cn.hutool.core.util.StrUtil;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.barcode.entity.BarcodeTemplateSupplierList;
import com.els.modules.barcode.entity.PurchaseBarcodeTemplateHead;
import com.els.modules.barcode.entity.PurchaseBarcodeTemplateItem;
import com.els.modules.barcode.enumerate.SrmEnabledStatusEnum;
import com.els.modules.barcode.mapper.BarcodeTemplateSupplierListMapper;
import com.els.modules.barcode.mapper.PurchaseBarcodeTemplateHeadMapper;
import com.els.modules.barcode.mapper.PurchaseBarcodeTemplateItemMapper;
import com.els.modules.barcode.service.BarcodeTemplateSupplierListService;
import com.els.modules.barcode.service.PurchaseBarcodeTemplateHeadService;
import com.els.modules.barcode.service.PurchaseBarcodeTemplateItemService;
import com.els.modules.barcode.service.SaleBarcodeTemplateHeadService;
import com.els.modules.system.service.CodeGeneratorService;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PurchaseBarcodeTemplateHeadServiceImpl
extends BaseServiceImpl<PurchaseBarcodeTemplateHeadMapper, PurchaseBarcodeTemplateHead>
implements PurchaseBarcodeTemplateHeadService {
    @Autowired
    private PurchaseBarcodeTemplateHeadMapper purchaseBarcodeTemplateHeadMapper;
    @Autowired
    private PurchaseBarcodeTemplateItemMapper purchaseBarcodeTemplateItemMapper;
    @Autowired
    private PurchaseBarcodeTemplateItemService purchaseBarcodeTemplateItemService;
    @Autowired
    private BarcodeTemplateSupplierListMapper barcodeTemplateSupplierListMapper;
    @Autowired
    private BarcodeTemplateSupplierListService barcodeTemplateSupplierListService;
    @Autowired
    private SaleBarcodeTemplateHeadService saleBarcodeTemplateHeadService;
    @Autowired
    private CodeGeneratorService codeGeneratorService;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseBarcodeTemplateHead purchaseBarcodeTemplateHead, List<PurchaseBarcodeTemplateItem> purchaseBarcodeTemplateItemList, List<BarcodeTemplateSupplierList> barcodeTemplateSupplierListList) {
        purchaseBarcodeTemplateHead.setBarcodeTemplateNumber(this.codeGeneratorService.getNextCode("srmBarcodeTemplateNumber", (Object)purchaseBarcodeTemplateHead));
        purchaseBarcodeTemplateHead.setStatus(SrmEnabledStatusEnum.NEW.getValue());
        this.purchaseBarcodeTemplateHeadMapper.insert((Object)purchaseBarcodeTemplateHead);
        this.insertData(purchaseBarcodeTemplateHead, purchaseBarcodeTemplateItemList, barcodeTemplateSupplierListList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseBarcodeTemplateHead purchaseBarcodeTemplateHead, List<PurchaseBarcodeTemplateItem> purchaseBarcodeTemplateItemList, List<BarcodeTemplateSupplierList> barcodeTemplateSupplierListList) {
        if (StrUtil.isBlank((CharSequence)purchaseBarcodeTemplateHead.getId())) {
            this.saveMain(purchaseBarcodeTemplateHead, purchaseBarcodeTemplateItemList, barcodeTemplateSupplierListList);
        } else {
            int count = this.purchaseBarcodeTemplateHeadMapper.updateById((Object)purchaseBarcodeTemplateHead);
            if (count == 0) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
            }
            this.purchaseBarcodeTemplateItemMapper.deleteByMainId(purchaseBarcodeTemplateHead.getId());
            this.barcodeTemplateSupplierListMapper.deleteByMainId(purchaseBarcodeTemplateHead.getId());
            this.insertData(purchaseBarcodeTemplateHead, purchaseBarcodeTemplateItemList, barcodeTemplateSupplierListList);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void publish(PurchaseBarcodeTemplateHead purchaseBarcodeTemplateHead, List<PurchaseBarcodeTemplateItem> purchaseBarcodeTemplateItemList, List<BarcodeTemplateSupplierList> barcodeTemplateSupplierListList) {
        purchaseBarcodeTemplateHead.setStatus(SrmEnabledStatusEnum.ENABLED.getValue());
        int count = this.purchaseBarcodeTemplateHeadMapper.updateById((Object)purchaseBarcodeTemplateHead);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
        this.purchaseBarcodeTemplateItemMapper.deleteByMainId(purchaseBarcodeTemplateHead.getId());
        this.barcodeTemplateSupplierListMapper.deleteByMainId(purchaseBarcodeTemplateHead.getId());
        this.insertData(purchaseBarcodeTemplateHead, purchaseBarcodeTemplateItemList, barcodeTemplateSupplierListList);
        if (barcodeTemplateSupplierListList != null && barcodeTemplateSupplierListList.size() > 0) {
            this.saleBarcodeTemplateHeadService.addByPurchase(purchaseBarcodeTemplateHead, purchaseBarcodeTemplateItemList, barcodeTemplateSupplierListList);
        }
    }

    private void insertData(PurchaseBarcodeTemplateHead purchaseBarcodeTemplateHead, List<PurchaseBarcodeTemplateItem> purchaseBarcodeTemplateItemList, List<BarcodeTemplateSupplierList> barcodeTemplateSupplierListList) {
        if (purchaseBarcodeTemplateItemList != null && !purchaseBarcodeTemplateItemList.isEmpty()) {
            for (PurchaseBarcodeTemplateItem purchaseBarcodeTemplateItem : purchaseBarcodeTemplateItemList) {
                purchaseBarcodeTemplateItem.setHeadId(purchaseBarcodeTemplateHead.getId());
                purchaseBarcodeTemplateItem.setId(null);
                SysUtil.setSysParam((BaseEntity)purchaseBarcodeTemplateItem, (BaseEntity)purchaseBarcodeTemplateHead);
            }
            this.purchaseBarcodeTemplateItemService.saveBatch(purchaseBarcodeTemplateItemList);
        }
        if (barcodeTemplateSupplierListList != null && !barcodeTemplateSupplierListList.isEmpty()) {
            for (BarcodeTemplateSupplierList barcodeTemplateSupplierList : barcodeTemplateSupplierListList) {
                barcodeTemplateSupplierList.setHeadId(purchaseBarcodeTemplateHead.getId());
                SysUtil.setSysParam((BaseEntity)barcodeTemplateSupplierList, (BaseEntity)purchaseBarcodeTemplateHead);
            }
            this.barcodeTemplateSupplierListService.saveBatch(barcodeTemplateSupplierListList);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.purchaseBarcodeTemplateItemMapper.deleteByMainId(id);
        this.barcodeTemplateSupplierListMapper.deleteByMainId(id);
        this.purchaseBarcodeTemplateHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.purchaseBarcodeTemplateItemMapper.deleteByMainId(serializable.toString());
            this.barcodeTemplateSupplierListMapper.deleteByMainId(serializable.toString());
            this.purchaseBarcodeTemplateHeadMapper.deleteById(serializable);
        }
    }

    @Override
    public void templateCopy(String id) {
        PurchaseBarcodeTemplateHead purchaseBarcodeTemplateHead = (PurchaseBarcodeTemplateHead)((Object)this.purchaseBarcodeTemplateHeadMapper.selectById((Serializable)((Object)id)));
        purchaseBarcodeTemplateHead.setBarcodeTemplateNumber(this.codeGeneratorService.getNextCode("srmBarcodeTemplateNumber", (Object)purchaseBarcodeTemplateHead));
        purchaseBarcodeTemplateHead.setStatus(SrmEnabledStatusEnum.NEW.getValue());
        purchaseBarcodeTemplateHead.setId(null);
        purchaseBarcodeTemplateHead.setCreateBy(null);
        purchaseBarcodeTemplateHead.setCreateTime(null);
        purchaseBarcodeTemplateHead.setUpdateBy(null);
        purchaseBarcodeTemplateHead.setUpdateTime(null);
        this.purchaseBarcodeTemplateHeadMapper.insert((Object)purchaseBarcodeTemplateHead);
        List<PurchaseBarcodeTemplateItem> itemList = this.purchaseBarcodeTemplateItemMapper.selectByMainId(id);
        for (PurchaseBarcodeTemplateItem item : itemList) {
            item.setHeadId(purchaseBarcodeTemplateHead.getId());
            item.setId(null);
            SysUtil.setSysParam((BaseEntity)item, (BaseEntity)purchaseBarcodeTemplateHead);
        }
        this.purchaseBarcodeTemplateItemService.saveBatch(itemList);
    }
}

