/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.email.core.sender;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.extra.mail.MailAccount;
import cn.hutool.extra.mail.MailUtil;
import com.els.modules.email.api.dto.EmailConfigDTO;
import com.els.modules.email.api.dto.EmailSendResultDto;
import com.els.modules.email.core.SrmEmailBuilder;
import com.els.modules.email.core.SrmEmailProtocol;
import com.els.modules.email.core.sender.AbstractSrmEmailSender;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="hutoolEmailSender")
public class HutoolEmailSender
extends AbstractSrmEmailSender {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HutoolEmailSender.class);

    @Override
    protected EmailSendResultDto doSendEmail(EmailConfigDTO config) {
        EmailSendResultDto result = new EmailSendResultDto();
        try {
            result.setResult(true);
            this.doSendEmailEp(config);
        }
        catch (Exception e) {
            log.error("HutoolEmailSender \u53d1\u9001\u90ae\u4ef6\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            result.setResult(false);
            result.setMsg(e.getMessage());
        }
        return result;
    }

    @Override
    protected void doSendEmailEp(EmailConfigDTO config) {
        Object[] to = config.getEmailTo();
        List<String> cc = CharSequenceUtil.isEmpty((CharSequence)config.getEmailCc()) ? null : Arrays.stream(config.getEmailCc().split(",")).distinct().toList();
        ArrayList bcc = null == config.getEmailBcc() || config.getEmailBcc().length == 0 ? null : Lists.newArrayList((Object[])config.getEmailBcc());
        MailAccount mailAccount = SrmEmailBuilder.buildMailAccountByConfig(config.getEmailProps());
        mailAccount.setFrom(config.getEmailUsername());
        mailAccount.setHost(config.getEmailHost());
        mailAccount.setPass(config.getEmailPassword());
        mailAccount.setPort(config.getEmailPort());
        mailAccount.setUser(config.getEmailUsername());
        StringBuilder content = new StringBuilder(config.getEmailContent());
        if (CollectionUtil.isNotEmpty((Map)config.getAttachmentPathList())) {
            content.append("<br/><br/><br/>\u9644\u4ef6\u5217\u8868:<br/>");
            Set key = config.getAttachmentPathList().keySet();
            for (String name : key) {
                content.append("<a href = '").append((String)config.getAttachmentPathList().get(name)).append("' download='").append(name).append("'>").append(name).append("</a><br/>");
            }
        }
        MailUtil.send((MailAccount)mailAccount, (Collection)Lists.newArrayList((Object[])to), cc, (Collection)bcc, (String)config.getEmailSubject(), (String)content.toString(), (boolean)true, (File[])config.getAttachmentFiles());
    }

    @Override
    public List<SrmEmailProtocol> getSupportProtocol() {
        return Lists.newArrayList();
    }

    @Override
    public int order() {
        return 10;
    }
}

