/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.im.controller;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.text.CharSequenceUtil;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.api.dto.BaseDTO;
import com.els.common.api.vo.Result;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.common.util.SrmUtil;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.im.api.dto.GroupChatRecordDto;
import com.els.modules.im.api.dto.RecordUserDto;
import com.els.modules.im.core.ImSender;
import com.els.modules.im.core.constant.TioConfigConstant;
import com.els.modules.im.core.message.BusinessHelper;
import com.els.modules.im.core.packets.ImPackets;
import com.els.modules.im.core.packets.ImUserPackets;
import com.els.modules.im.core.packets.WsMsgTypePackets;
import com.els.modules.im.core.packets.WsResultPackets;
import com.els.modules.im.dto.ImGroupChatCreateDto;
import com.els.modules.im.dto.ImGroupCreateDto;
import com.els.modules.im.entity.ImGroupChat;
import com.els.modules.im.entity.ImGroupChatConfig;
import com.els.modules.im.entity.ImGroupChatUser;
import com.els.modules.im.service.IImGroupChatService;
import com.els.modules.im.service.IImGroupChatUserService;
import com.els.modules.im.service.IImUserFriendService;
import com.els.modules.im.service.ImAccountLocalService;
import com.els.modules.im.service.ImGroupChatConfigService;
import com.els.modules.im.service.ImGroupMessageUserService;
import com.els.modules.im.service.ImInvokeGroupChatUserRpcService;
import com.els.modules.im.utils.ImUtils;
import com.els.modules.im.vo.ImUserGroupVO;
import com.els.modules.im.vo.ImUserListVO;
import com.els.modules.system.entity.ElsSubAccount;
import com.google.common.collect.Lists;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.tio.core.TioConfig;

@Tag(name="IM\u7fa4\u804a\u7ba1\u7406")
@RestController
@RequestMapping(value={"/im/chatGroup"})
public class ImGroupChatController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ImGroupChatController.class);
    @Resource
    private IImUserFriendService iImUserFriendService;
    @Resource
    private IImGroupChatUserService imChatGroupUserService;
    @Resource
    private IImGroupChatService imGroupChatServiceImpl;
    @Autowired
    private ImGroupChatConfigService imGroupChatConfigService;
    @Resource
    private ImGroupMessageUserService imGroupMessageUserServiceImpl;
    @Resource
    private ImAccountLocalService accountLocalService;
    @Resource
    private ImInvokeGroupChatUserRpcService imInvokeGroupChatUserRpcService;
    @Resource
    private BusinessHelper businessHelper;

    @Operation(summary="\u624b\u52a8\u521b\u5efa\u7fa4\u804a", description="\u624b\u52a8\u521b\u5efa\u7fa4\u804a")
    @PostMapping(value={"/addChatGroup"})
    public Result<?> addChatGroup(@RequestBody ImGroupCreateDto imGroupCreateDto) {
        if (CharSequenceUtil.isEmpty((CharSequence)imGroupCreateDto.getGroupChatName())) {
            throw new ELSBootException(I18nUtil.translate((String)"\u7fa4\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        if (CollectionUtil.isEmpty(imGroupCreateDto.getUserIds())) {
            throw new ELSBootException(I18nUtil.translate((String)"\u7fa4\u5458\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        imGroupCreateDto.setBusinessType(null);
        imGroupCreateDto.setBusinessNumber(null);
        ImGroupChat chatGroup = this.imGroupChatServiceImpl.createGroupChat(imGroupCreateDto, true);
        List<String> chatGroupMembers = imGroupCreateDto.getUserIds();
        WsResultPackets wsResult = new WsResultPackets();
        wsResult.setMsgType(WsMsgTypePackets.CREATE_CHAT_GROUP_SUCCESS.getMsgType());
        wsResult.setData((Object)chatGroup);
        chatGroupMembers.remove(SrmUtil.getLoginUser().getId());
        ArrayList chatGroupUserList = Lists.newArrayList();
        for (String memberId : chatGroupMembers) {
            ImGroupChatUser chatGroupUser = new ImGroupChatUser();
            chatGroupUser.setGroupChatId(chatGroup.getId());
            chatGroupUser.setUserId(memberId);
            chatGroupUser.setCreateTime(new Date());
            chatGroupUserList.add(chatGroupUser);
        }
        this.imChatGroupUserService.saveBatch(chatGroupUserList);
        for (String memberId : chatGroupMembers) {
            ImSender.clusterToBindGroup(memberId, chatGroup.getId());
            ImPackets imPacket = ImPackets.fromText(wsResult);
            imPacket.setMessageId(IdWorker.getIdStr());
            imPacket.setServerId(TioConfigConstant.SERVER_ID);
            ImSender.sendToUserChannelContext(memberId, (TioConfig)TioConfigConstant.tioServerConfig, imPacket);
        }
        return Result.ok((Object)((Object)chatGroup));
    }

    @Operation(summary="\u6dfb\u52a0\u7fa4\u804a\u6210\u5458", description="\u6dfb\u52a0\u7fa4\u804a\u6210\u5458")
    @PostMapping(value={"/addChatGroupUser"})
    public Result<?> addChatGroupUser(@RequestBody ImGroupChatCreateDto imChatGroupCreateDto) {
        if (CollUtil.isEmpty(imChatGroupCreateDto.getUserId())) {
            return Result.ok(Collections.emptyList());
        }
        ImGroupChat imChatGroup = (ImGroupChat)((Object)this.imGroupChatServiceImpl.getById((Serializable)((Object)imChatGroupCreateDto.getGroupChatId())));
        if (null == imChatGroup) {
            throw new ELSBootException(I18nUtil.translate((String)"\u4e0d\u5b58\u5728\u8be5\u7fa4"));
        }
        List<ImGroupChatUser> userList = this.imChatGroupUserService.getByKey(imChatGroupCreateDto.getUserId(), imChatGroupCreateDto.getGroupChatId());
        List<String> userIds = userList.stream().map(ImGroupChatUser::getUserId).distinct().toList();
        imChatGroupCreateDto.getUserId().removeAll(userIds);
        if (CollUtil.isEmpty(imChatGroupCreateDto.getUserId())) {
            return Result.ok(Collections.emptyList());
        }
        List<ElsSubAccount> imUserMap = this.accountLocalService.getUsersByUserIdList(imChatGroupCreateDto.getUserId());
        if (CollUtil.isEmpty(imUserMap)) {
            return Result.ok(imUserMap);
        }
        WsResultPackets wsResult = new WsResultPackets();
        wsResult.setBroadcasting(true);
        wsResult.setMsgType(WsMsgTypePackets.ADD_CHAT_GROUP_USER_SUCCESS.getMsgType());
        wsResult.setData((Object)imChatGroup);
        ArrayList chatGroupUserList = Lists.newArrayList();
        for (ElsSubAccount member : imUserMap) {
            ImGroupChatUser chatGroupUser = new ImGroupChatUser();
            chatGroupUser.setGroupChatId(imChatGroupCreateDto.getGroupChatId());
            chatGroupUser.setUserId(member.getId());
            chatGroupUser.setCreateTime(new Date());
            chatGroupUserList.add(chatGroupUser);
        }
        this.imChatGroupUserService.saveBatch(chatGroupUserList);
        for (ElsSubAccount member : imUserMap) {
            ImSender.clusterToBindGroup(member.getId(), imChatGroupCreateDto.getGroupChatId());
            ImPackets imPacket = ImPackets.fromText(wsResult);
            imPacket.setMessageId(IdWorker.getIdStr());
            imPacket.setServerId(TioConfigConstant.SERVER_ID);
            ImSender.sendToUserChannelContext(member.getId(), (TioConfig)TioConfigConstant.tioServerConfig, imPacket);
        }
        return Result.ok(imUserMap);
    }

    @Operation(summary="\u5220\u9664\u7fa4\u804a\u6210\u5458", description="\u5220\u9664\u7fa4\u804a\u6210\u5458")
    @PostMapping(value={"/deleteChatGroupUser"})
    public Result<?> deleteChatGroupUser(@RequestBody ImGroupChatCreateDto imChatGroupDto) {
        if (CollUtil.isEmpty(imChatGroupDto.getUserId())) {
            return Result.ok();
        }
        ImGroupChat imChatGroup = (ImGroupChat)((Object)this.imGroupChatServiceImpl.getById((Serializable)((Object)imChatGroupDto.getGroupChatId())));
        if (null == imChatGroup) {
            throw new ELSBootException(I18nUtil.translate((String)"\u4e0d\u5b58\u5728\u8be5\u7fa4"));
        }
        String userId = SrmUtil.getLoginUser().getId();
        if (!imChatGroup.getGroupChatMasterId().equals(userId)) {
            throw new ELSBootException(I18nUtil.translate((String)"\u65e0\u64cd\u4f5c\u6743\u9650"));
        }
        this.imChatGroupUserService.removeChatGroupUser(imChatGroupDto.getGroupChatId(), imChatGroupDto.getUserId());
        WsResultPackets wsResult = new WsResultPackets();
        wsResult.setMsgType(WsMsgTypePackets.DELETE_CHAT_GROUP_USER_SUCCESS.getMsgType());
        wsResult.setData((Object)imChatGroup);
        for (String memberId : imChatGroupDto.getUserId()) {
            ImSender.clusterToUbBindGroup(Lists.newArrayList((Object[])new String[]{memberId}), imChatGroupDto.getGroupChatId());
            if (!this.businessHelper.isOnline(memberId)) continue;
            ImPackets imPacket = ImPackets.fromText(wsResult);
            imPacket.setMessageId(IdWorker.getIdStr());
            imPacket.setServerId(TioConfigConstant.SERVER_ID);
            ImSender.sendToUserChannelContext(memberId, (TioConfig)TioConfigConstant.tioServerConfig, imPacket);
        }
        return Result.ok();
    }

    @Operation(summary="\u89e3\u6563\u7fa4\u804a", description="\u89e3\u6563\u7fa4\u804a")
    @PostMapping(value={"/deleteChatGroup/{chatGroupId}"})
    public Result<?> deleteChatGroup(@PathVariable(value="chatGroupId") String chatGroupId) {
        ImGroupChat imChatGroup = (ImGroupChat)((Object)this.imGroupChatServiceImpl.getById((Serializable)((Object)chatGroupId)));
        if (null == imChatGroup) {
            throw new ELSBootException(I18nUtil.translate((String)"\u4e0d\u5b58\u5728\u8be5\u7fa4"));
        }
        String userId = SrmUtil.getLoginUser().getId();
        if (!imChatGroup.getGroupChatMasterId().equals(userId)) {
            throw new ELSBootException(I18nUtil.translate((String)"\u65e0\u64cd\u4f5c\u6743\u9650"));
        }
        List<String> memberIds = this.imChatGroupUserService.deleteChatGroup(chatGroupId);
        WsResultPackets wsResult = new WsResultPackets();
        wsResult.setMsgType(WsMsgTypePackets.DELETE_CHAT_GROUP_SUCCESS.getMsgType());
        wsResult.setData((Object)imChatGroup);
        ImSender.clusterToUbBindGroup(memberIds, chatGroupId);
        for (String memberId : memberIds) {
            ImPackets imPacket = ImPackets.fromText(wsResult);
            imPacket.setMessageId(IdWorker.getIdStr());
            imPacket.setServerId(TioConfigConstant.SERVER_ID);
            ImSender.sendToUserChannelContext(memberId, (TioConfig)TioConfigConstant.tioServerConfig, imPacket);
        }
        return Result.ok();
    }

    @Operation(summary="\u6839\u636e\u5355\u636eID\u521b\u5efa\u7fa4\u804a", description="\u6839\u636e\u5355\u636eID\u521b\u5efa\u7fa4\u804a")
    @PostMapping(value={"/createChatGroupById"})
    public Result<?> createChatGroupById(@RequestBody ImGroupCreateDto imGroupCreateDto) {
        ImGroupChat imChatGroup = (ImGroupChat)((Object)this.imGroupChatServiceImpl.getById((Serializable)((Object)imGroupCreateDto.getId())));
        if (null == imChatGroup) {
            throw new ELSBootException(I18nUtil.translate((String)"\u8be5\u5355\u636e\u5df2\u7ecf\u521b\u5efa\u7fa4\u804a"));
        }
        String groupName = CharSequenceUtil.isEmpty((CharSequence)imGroupCreateDto.getGroupChatName()) ? imGroupCreateDto.getBusinessType() + "-" + imGroupCreateDto.getBusinessNumber() : imGroupCreateDto.getGroupChatName() + "-" + imGroupCreateDto.getBusinessType() + "-" + imGroupCreateDto.getBusinessNumber();
        imGroupCreateDto.setGroupChatName(groupName);
        imChatGroup = this.imGroupChatServiceImpl.createGroupChat(imGroupCreateDto, true);
        List chatGroupMembers = imGroupCreateDto.getUserIds().stream().distinct().collect(Collectors.toList());
        WsResultPackets wsResult = new WsResultPackets();
        wsResult.setMsgType(WsMsgTypePackets.CREATE_CHAT_GROUP_SUCCESS.getMsgType());
        wsResult.setData((Object)imChatGroup);
        chatGroupMembers.remove(SrmUtil.getLoginUser().getId());
        if (!chatGroupMembers.isEmpty()) {
            ArrayList chatGroupUserList = Lists.newArrayList();
            for (String memberId : chatGroupMembers) {
                ImGroupChatUser chatGroupUser = new ImGroupChatUser();
                chatGroupUser.setGroupChatId(imGroupCreateDto.getId());
                chatGroupUser.setUserId(memberId);
                chatGroupUser.setCreateTime(new Date());
                chatGroupUserList.add(chatGroupUser);
            }
            this.imChatGroupUserService.saveBatch(chatGroupUserList);
            for (String memberId : chatGroupMembers) {
                ImSender.clusterToBindGroup(memberId, imChatGroup.getId());
                ImPackets imPacket = ImPackets.fromText(wsResult);
                imPacket.setMessageId(IdWorker.getIdStr());
                imPacket.setServerId(TioConfigConstant.SERVER_ID);
                ImSender.sendToUserChannelContext(memberId, (TioConfig)TioConfigConstant.tioServerConfig, imPacket);
            }
        }
        List<ImGroupChatConfig> elsChatConfigs = this.imGroupChatConfigService.loadConfig();
        return Result.ok((String)imChatGroup.getGroupChatName().replace(imChatGroup.getBusinessType(), ImUtils.getRecordI18Value(imChatGroup.getBusinessType(), elsChatConfigs)));
    }

    @Operation(summary="\u83b7\u53d6\u7fa4\u804a\u8d1f\u8d23\u4eba", description="\u83b7\u53d6\u7fa4\u804a\u8d1f\u8d23\u4eba")
    @GetMapping(value={"/getChargePerson"})
    public Result<?> getChargePerson(@RequestParam(name="id") String id, @RequestParam(name="type") String type) {
        ImGroupChatConfig config = this.imGroupChatConfigService.loadChatConfigByType(type);
        if (null == config) {
            throw new ELSBootException(I18nUtil.translate((String)"\u4e0d\u5b58\u5728\u5355\u636e\u7c7b\u578b"));
        }
        GroupChatRecordDto recordDto = new GroupChatRecordDto(id, type, config.getBeanName());
        List<RecordUserDto> recordUserList = this.imInvokeGroupChatUserRpcService.loadGroupChatUserByRecord(recordDto);
        List recordUserListVo = Convert.toList(ImUserPackets.class, recordUserList);
        String userId = SrmUtil.getLoginUser().getId();
        if (CollectionUtil.isEmpty((Collection)(recordUserListVo = (List)recordUserListVo.stream().filter(x -> !CharSequenceUtil.equals((CharSequence)userId, (CharSequence)x.getId())).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<ImUserPackets>(Comparator.comparing(BaseDTO::getId))), ArrayList::new))))) {
            throw new ELSBootException(I18nUtil.translate((String)"\u5355\u636e\u9664\u5f53\u524d\u767b\u5f55\u4eba\u5916\u65e0\u5176\u4ed6\u53c2\u4e0e\u4eba\u5458\uff0c\u65e0\u9700\u521b\u5efa\u804a\u5929\u5ba4"));
        }
        return Result.ok((Object)ImUserListVO.buildImResultList(recordUserListVo, "1".equals(config.getGroupChat())));
    }

    @Operation(summary="\u6839\u636e\u7fa4\u804aID\u83b7\u53d6\u7528\u6237", description="\u6839\u636e\u7fa4\u804aID\u83b7\u53d6\u7528\u6237")
    @GetMapping(value={"/loadUserList/{groupId}"})
    public Result<?> loadUserList(@PathVariable(value="groupId") String groupId) {
        ImGroupChat group = (ImGroupChat)((Object)this.imGroupChatServiceImpl.getById((Serializable)((Object)groupId)));
        if (null == group) {
            throw new ELSBootException(I18nUtil.translate((String)"\u4e0d\u5b58\u5728\u8be5\u7fa4"));
        }
        String[] idStr = groupId.split("_");
        String userId = SrmUtil.getLoginUser().getId();
        ArrayList<ImUserPackets> allUserList = new ArrayList<ImUserPackets>();
        if (CharSequenceUtil.isNotBlank((CharSequence)group.getBusinessType()) && idStr.length > 1) {
            ImGroupChatConfig config = this.imGroupChatConfigService.loadChatConfigByType(group.getBusinessType());
            if (null == config) {
                throw new ELSBootException(I18nUtil.translate((String)"\u4e0d\u5b58\u5728\u8be5\u7fa4"));
            }
            GroupChatRecordDto recordDto = new GroupChatRecordDto(idStr[0], group.getBusinessType(), config.getBeanName());
            List<RecordUserDto> recordUserList = this.imInvokeGroupChatUserRpcService.loadGroupChatUserByRecord(recordDto);
            allUserList.addAll(Convert.toList(ImUserPackets.class, (Object)recordUserList));
        }
        List<String> recordIds = allUserList.stream().map(BaseDTO::getId).distinct().toList();
        List<ImUserGroupVO> friend = this.getUserFriends(userId);
        for (ImUserGroupVO groupVO : friend) {
            List<ImUserPackets> groupVOList = groupVO.getList();
            if (!CollUtil.isNotEmpty(groupVOList)) continue;
            List<ImUserPackets> temList = groupVOList.stream().filter(x -> !recordIds.contains(x.getId())).peek(x -> x.setRealname(groupVO.getGroupName() + "-" + x.getElsAccount() + "_" + x.getRealname())).toList();
            allUserList.addAll(temList);
        }
        List<ImGroupChatUser> chatUserByChatId = this.imChatGroupUserService.getChatUserByChatId(groupId);
        List<String> charGroupUserIds = chatUserByChatId.stream().map(ImGroupChatUser::getUserId).distinct().toList();
        if (CollectionUtil.isEmpty(allUserList = allUserList.stream().filter(x -> !charGroupUserIds.contains(x.getId())).collect(Collectors.toList()))) {
            throw new ELSBootException(I18nUtil.translate((String)"\u5355\u636e\u9664\u5f53\u524d\u767b\u5f55\u4eba\u5916\u65e0\u5176\u4ed6\u53c2\u4e0e\u4eba\u5458\uff0c\u65e0\u9700\u521b\u5efa\u804a\u5929\u5ba4"));
        }
        return Result.ok((Object)ImUserListVO.buildImResultList(allUserList, true));
    }

    @Operation(summary="\u6839\u636e\u7fa4\u804aID\u83b7\u53d6\u7fa4\u7528\u6237", description="\u6839\u636e\u7fa4\u804aID\u83b7\u53d6\u7fa4\u7528\u6237")
    @GetMapping(value={"chatUserList"})
    public Result<?> chatUserList(@RequestParam(name="id") String chatId) {
        HashMap<String, List<ImUserPackets>> objectMap = new HashMap<String, List<ImUserPackets>>();
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        ImGroupChat chatGroup = (ImGroupChat)((Object)this.imGroupChatServiceImpl.getById((Serializable)((Object)chatId)));
        if (null == chatGroup) {
            throw new ELSBootException(I18nUtil.translate((String)"\u4e0d\u5b58\u5728\u8be5\u7fa4"));
        }
        List<ImGroupChatUser> imChatGroupUserList = this.imChatGroupUserService.getChatUserByChatId(chatId);
        List<ImUserPackets> chatUserList = this.businessHelper.getUsersByUserIdList(imChatGroupUserList.stream().map(ImGroupChatUser::getUserId).collect(Collectors.toList()));
        for (ImUserPackets dto : chatUserList) {
            dto.setMaster(dto.getId().equals(chatGroup.getGroupChatMasterId()));
        }
        chatUserList.sort(Comparator.comparing(ImUserPackets::isMaster));
        objectMap.put("list", chatUserList);
        resultMap.put("code", "0");
        resultMap.put("msg", "");
        resultMap.put("data", objectMap);
        return Result.ok(resultMap);
    }

    @Operation(summary="\u9605\u8bfb\u7fa4\u7ec4\u6d88\u606f", description="\u9605\u8bfb\u7fa4\u7ec4\u6d88\u606f")
    @PostMapping(value={"/removeGroupChatMessage/{groupId}"})
    public Result<?> removeGroupChatMessage(@PathVariable(value="groupId") String groupId) {
        LoginUserDTO sysUser = SrmUtil.getLoginUser();
        this.imGroupMessageUserServiceImpl.removeMsgLogByUserId(sysUser.getId(), Lists.newArrayList((Object[])new String[]{groupId}));
        return Result.ok();
    }

    public List<ImUserGroupVO> getUserFriends(String userId) {
        List<ImUserGroupVO> userFriends = this.iImUserFriendService.getUserFriends(userId);
        List<String> userIdList = userFriends.stream().flatMap(l -> l.getList().stream()).map(BaseDTO::getId).filter(CharSequenceUtil::isNotBlank).collect(Collectors.toList());
        List<ElsSubAccount> usersLst = this.accountLocalService.getUsersByUserIdList(userIdList);
        List userVOList = Convert.toList(ImUserPackets.class, usersLst);
        Map userMap = userVOList.stream().collect(Collectors.toMap(BaseDTO::getId, Function.identity(), (v1, v2) -> v2));
        for (ImUserGroupVO g : userFriends) {
            int size = g.getList().size();
            for (int i = size - 1; i >= 0; --i) {
                ImUserPackets imUserVO = g.getList().get(i);
                ImUserPackets vo = (ImUserPackets)((Object)userMap.get(imUserVO.getId()));
                if (null != vo) {
                    g.getList().remove(i);
                    g.getList().add(i, vo);
                    continue;
                }
                g.getList().remove((Object)imUserVO);
            }
        }
        return userFriends;
    }

    @Operation(summary="\u5220\u9664\u7fa4\u804a\u6210\u5458", description="\u5220\u9664\u7fa4\u804a\u6210\u5458")
    @PostMapping(value={"/removeChatGroupUser"})
    public Result<?> removeChatGroupUser(@RequestBody ImGroupChatCreateDto imChatGroupDto) {
        if (CollUtil.isEmpty(imChatGroupDto.getUserId())) {
            return Result.ok();
        }
        ImGroupChat imChatGroup = (ImGroupChat)((Object)this.imGroupChatServiceImpl.getById((Serializable)((Object)imChatGroupDto.getGroupChatId())));
        if (null == imChatGroup) {
            throw new ELSBootException(I18nUtil.translate((String)"\u4e0d\u5b58\u5728\u8be5\u7fa4"));
        }
        String userId = SrmUtil.getLoginUser().getId();
        if (!imChatGroup.getGroupChatMasterId().equals(userId)) {
            throw new ELSBootException(I18nUtil.translate((String)"\u65e0\u64cd\u4f5c\u6743\u9650"));
        }
        this.imChatGroupUserService.removeChatGroupUser(imChatGroupDto.getGroupChatId(), imChatGroupDto.getUserId());
        WsResultPackets wsResult = new WsResultPackets();
        wsResult.setMsgType(WsMsgTypePackets.DELETE_CHAT_GROUP_USER_SUCCESS.getMsgType());
        wsResult.setData((Object)imChatGroup);
        for (String memberId : imChatGroupDto.getUserId()) {
            ImSender.clusterToUbBindGroup(Lists.newArrayList((Object[])new String[]{memberId}), imChatGroupDto.getGroupChatId());
            if (!this.businessHelper.isOnline(memberId)) continue;
            ImPackets imPacket = ImPackets.fromText(wsResult);
            imPacket.setMessageId(IdWorker.getIdStr());
            imPacket.setServerId(TioConfigConstant.SERVER_ID);
            ImSender.sendToUserChannelContext(memberId, (TioConfig)TioConfigConstant.tioServerConfig, imPacket);
        }
        return Result.ok();
    }
}

