/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.im.controller;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.api.dto.BaseDTO;
import com.els.common.api.vo.Result;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.util.I18nUtil;
import com.els.common.util.SrmUtil;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.im.core.ImSender;
import com.els.modules.im.core.constant.TioConfigConstant;
import com.els.modules.im.core.message.BusinessHelper;
import com.els.modules.im.core.packets.ImPackets;
import com.els.modules.im.core.packets.ImUserPackets;
import com.els.modules.im.core.packets.WsMsgTypePackets;
import com.els.modules.im.core.packets.WsResultPackets;
import com.els.modules.im.dto.GroupMessageUserDto;
import com.els.modules.im.dto.ImInitDto;
import com.els.modules.im.entity.ImGroupChat;
import com.els.modules.im.entity.ImGroupChatConfig;
import com.els.modules.im.entity.ImGroupChatUser;
import com.els.modules.im.entity.ImMessage;
import com.els.modules.im.entity.ImUserFriend;
import com.els.modules.im.service.IImGroupChatService;
import com.els.modules.im.service.IImGroupChatUserService;
import com.els.modules.im.service.IImMessageService;
import com.els.modules.im.service.IImUserFriendService;
import com.els.modules.im.service.IImUserGroupService;
import com.els.modules.im.service.ImAccountLocalService;
import com.els.modules.im.service.ImGroupChatConfigService;
import com.els.modules.im.service.ImGroupMessageUserService;
import com.els.modules.im.utils.ImUtils;
import com.els.modules.im.vo.ImMessageVO;
import com.els.modules.im.vo.ImUserGroupVO;
import com.els.modules.system.entity.ElsSubAccount;
import com.google.common.collect.Lists;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.tio.core.TioConfig;

@Tag(name="IM\u6c9f\u901a")
@RestController
@RequestMapping(value={"/im/user"})
public class ImUserController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ImUserController.class);
    @Resource
    private IImUserFriendService imUserFriendService;
    @Resource
    private IImGroupChatUserService imChatGroupUserService;
    @Resource
    private IImMessageService iImMessageService;
    @Resource
    private IImGroupChatService imGroupChatServiceImpl;
    @Resource
    private IImUserGroupService imUserGroupServiceImpl;
    @Resource
    private ImAccountLocalService imAccountLocalServiceImpl;
    @Resource
    private ImGroupMessageUserService imGroupMessageUserServiceImpl;
    @Autowired
    private ThreadPoolTaskExecutor srmPoolTaskExecutor;
    @Autowired
    private ImGroupChatConfigService imGroupChatConfigService;
    @Autowired
    private IImUserFriendService iImUserFriendService;
    @Autowired
    private BusinessHelper businessHelper;

    @Operation(summary="\u6c9f\u901a\u521d\u59cb\u5316\u65b9\u6cd5", description="\u6c9f\u901a\u521d\u59cb\u5316\u65b9\u6cd5")
    @GetMapping(value={"/init"})
    public Result<?> imInit() {
        ImInitDto initDto = new ImInitDto();
        LoginUserDTO loginUser = SrmUtil.getLoginUser();
        ImUserPackets user = (ImUserPackets)((Object)Convert.convert(ImUserPackets.class, (Object)loginUser));
        Future listFuture = this.srmPoolTaskExecutor.submit(() -> this.chatGroupInitTask(user.getId()));
        List<ImUserGroupVO> friend = this.getUserFriends(user.getId());
        if (friend.isEmpty()) {
            this.imUserGroupServiceImpl.initGroup(user.getId());
            friend = this.getUserFriends(user.getId());
        }
        for (ImUserGroupVO group : friend) {
            List<ImUserPackets> userList = group.getList();
            for (ImUserPackets imUser : userList) {
                imUser.setGroupId(group.getId());
                if (this.businessHelper.isOnline(user.getId())) {
                    imUser.setStatus("online");
                    continue;
                }
                imUser.setStatus("offline");
            }
        }
        initDto.setFriend(friend);
        user.setStatus("online");
        initDto.setUser(user);
        List<ImUserPackets> friendsRequest = this.getUserFriendsRequest(user.getId());
        initDto.setFriendsRequest(friendsRequest);
        List<ImGroupChat> chatGroups = new ArrayList();
        try {
            chatGroups = (List)listFuture.get(20L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            log.info("\u5f02\u6b65\u67e5\u8be2\u7fa4\u7ec4\u4fe1\u606f\u9519\u8bef");
        }
        chatGroups.sort(Comparator.comparing(ImGroupChat::getNewMsgCount).reversed());
        initDto.setChatGroup(chatGroups);
        return Result.ok((Object)initDto);
    }

    @Operation(summary="\u5ba2\u670d\u63a5\u53e3\u521d\u59cb\u5316", description="\u5ba2\u670d\u63a5\u53e3\u521d\u59cb\u5316")
    @GetMapping(value={"/customer-init"})
    public Result<?> customerInit(@RequestParam(name="pageNo") Long pageNo, Integer pageSize) {
        ImInitDto initDto = new ImInitDto();
        LoginUserDTO loginUser = SrmUtil.getLoginUser();
        ImUserPackets user = (ImUserPackets)((Object)Convert.convert(ImUserPackets.class, (Object)loginUser));
        if (null == user) {
            throw new ELSBootException("IM" + I18nUtil.translate((String)"\u7528\u6237\u4e0d\u5b58\u5728"));
        }
        Page page = new Page();
        page.setSize(null == pageSize ? 10000L : (long)pageSize.intValue());
        page.setCurrent(pageNo == null ? 0L : pageNo);
        Page<ImMessage> messageList = this.iImMessageService.pageMessage((Page<ImMessage>)page, "kefu", SrmUtil.getLoginUser().getId());
        List messageVos = Lists.newArrayList();
        if (CollUtil.isNotEmpty((Collection)messageList.getRecords())) {
            List<String> userIdList = messageList.getRecords().stream().map(ImMessage::getMessageFromId).collect(Collectors.toList());
            List<ImUserPackets> userList = this.businessHelper.getUsersByUserIdList(userIdList);
            Map stringImUserMap = userList.stream().collect(Collectors.toMap(BaseDTO::getId, Function.identity()));
            messageVos = Convert.toList(ImMessageVO.class, (Object)messageList.getRecords());
            for (ImMessageVO vo : messageVos) {
                ImUserPackets imUser = (ImUserPackets)((Object)stringImUserMap.get(vo.getMessageFromId()));
                if (null == imUser) continue;
                vo.setGroupChatHeadPortrait(imUser.getHeadPortrait());
                vo.setId(vo.getMessageFromId());
                vo.setRealname(imUser.getRealname());
                vo.setElsAccount(imUser.getElsAccount());
                vo.setSubAccount(imUser.getSubAccount());
            }
        }
        initDto.setChatList(messageVos);
        user.setStatus("online");
        initDto.setUser(user);
        initDto.setChatGroup(Lists.newArrayList());
        return Result.ok((Object)initDto);
    }

    public List<ImUserGroupVO> getUserFriends(String userId) {
        List<ImUserGroupVO> userFriends = this.iImUserFriendService.getUserFriends(userId);
        List<String> userIdList = userFriends.stream().flatMap(l -> l.getList().stream()).map(BaseDTO::getId).filter(CharSequenceUtil::isNotBlank).collect(Collectors.toList());
        List<ElsSubAccount> usersLst = this.imAccountLocalServiceImpl.getUsersByUserIdList(userIdList);
        List userVOList = Convert.toList(ImUserPackets.class, usersLst);
        Map userMap = userVOList.stream().collect(Collectors.toMap(BaseDTO::getId, Function.identity(), (v1, v2) -> v2));
        for (ImUserGroupVO g : userFriends) {
            int size = g.getList().size();
            for (int i = size - 1; i >= 0; --i) {
                ImUserPackets imUserVO = g.getList().get(i);
                ImUserPackets vo = (ImUserPackets)((Object)userMap.get(imUserVO.getId()));
                if (null != vo) {
                    g.getList().remove(i);
                    g.getList().add(i, vo);
                    continue;
                }
                g.getList().remove((Object)imUserVO);
            }
        }
        return userFriends;
    }

    public List<ImUserPackets> getUserFriendsRequest(String userId) {
        List<ImUserFriend> imUserFriendList = this.iImUserFriendService.listImUserFriendOfUid(userId);
        Map friendMap = imUserFriendList.stream().collect(Collectors.toMap(ImUserFriend::getUserId, Function.identity()));
        List<ImUserPackets> imFriendUserList = this.businessHelper.getUsersByUserIdList(imUserFriendList.stream().map(ImUserFriend::getUserId).collect(Collectors.toList()));
        int size = imFriendUserList.size();
        for (int i = size - 1; i >= 0; --i) {
            ImUserPackets imUserVO = imFriendUserList.get(i);
            ImUserFriend imUserFriend = (ImUserFriend)((Object)friendMap.get(imUserVO.getId()));
            if (null == imUserFriend) {
                imFriendUserList.remove(i);
                continue;
            }
            imUserVO.setCreateTime(imUserVO.getCreateTime());
        }
        return imFriendUserList;
    }

    private List<ImGroupChat> chatGroupInitTask(String userId) {
        List<ImGroupChat> chatGroups = this.imGroupChatServiceImpl.getGroupChatsByUserId(userId);
        List groupIds = chatGroups.stream().map(ParentEntity::getId).collect(Collectors.toList());
        List<ImGroupChatConfig> elsChatConfigs = this.imGroupChatConfigService.loadConfig();
        List<GroupMessageUserDto> messageUserVos = this.imGroupMessageUserServiceImpl.listCountUnReadMessage(userId);
        Map<String, Integer> msgCountMap = messageUserVos.stream().collect(Collectors.toMap(GroupMessageUserDto::getGroupId, GroupMessageUserDto::getMsgCount));
        for (ImGroupChat group : chatGroups) {
            String recordI18Value;
            if (CharSequenceUtil.isNotEmpty((CharSequence)group.getBusinessType()) && CharSequenceUtil.isNotEmpty((CharSequence)group.getGroupChatName()) && CharSequenceUtil.isNotEmpty((CharSequence)(recordI18Value = ImUtils.getRecordI18Value(group.getBusinessType(), elsChatConfigs)))) {
                String groupName = group.getGroupChatName().replace(group.getBusinessType(), recordI18Value);
                log.info(":::\u7528\u6237\u7fa4\u7ec4\u7684\u540d\u79f0:{}", (Object)groupName);
                group.setGroupChatName(groupName);
            }
            group.setIsMaster(SrmUtil.getLoginUser().getId().equals(group.getGroupChatMasterId()));
            Integer count = (Integer)ObjectUtil.defaultIfNull((Object)msgCountMap.get(group.getId()), (Object)0);
            if (count == 0) {
                groupIds.remove(group.getId());
            }
            group.setNewMsgCount(count);
        }
        return chatGroups;
    }

    @Operation(summary="\u6839\u636e\u7fa4\u804aID\u83b7\u53d6\u5f53\u524d\u7528\u6237\u80fd\u89c1\u7684\u7fa4\u7528\u6237", description="\u6839\u636e\u7fa4\u804aID\u83b7\u53d6\u5f53\u524d\u7528\u6237\u80fd\u89c1\u7684\u7fa4\u7528\u6237")
    @GetMapping(value={"/getChatGroupUserByGroupId"})
    public Result<?> getChatGroupUserByGroupId(@RequestParam(name="id") String id) {
        List<ImUserPackets> chatUserList;
        ImGroupChat chatGroup = (ImGroupChat)((Object)this.imGroupChatServiceImpl.getById((Serializable)((Object)id)));
        if (null == chatGroup) {
            throw new ELSBootException(I18nUtil.translate((String)"\u4e0d\u5b58\u5728\u8be5\u7fa4"));
        }
        ElsSubAccount master = this.imAccountLocalServiceImpl.getAccountInfoById(chatGroup.getGroupChatMasterId());
        if (!SrmUtil.getLoginUser().getId().equals(chatGroup.getGroupChatMasterId()) && !this.imAccountLocalServiceImpl.checkIfSameElsAccountByUserId(master.getElsAccount(), SrmUtil.getLoginUser().getId())) {
            List<String> subAccountId = this.imAccountLocalServiceImpl.loadElsAccountId(Lists.newArrayList((Object[])new String[]{master.getElsAccount(), SrmUtil.getLoginUser().getElsAccount()}));
            List<ImGroupChatUser> groupUserList = this.imChatGroupUserService.getChatUserByChatId(id);
            List<String> groupUserIds = groupUserList.stream().map(ImGroupChatUser::getUserId).toList();
            subAccountId = subAccountId.stream().filter(groupUserIds::contains).collect(Collectors.toList());
            chatUserList = this.businessHelper.getUsersByUserIdList(subAccountId);
        } else {
            List<ImGroupChatUser> imChatGroupUserList = this.imChatGroupUserService.getChatUserByChatId(id);
            chatUserList = this.businessHelper.getUsersByUserIdList(imChatGroupUserList.stream().map(ImGroupChatUser::getUserId).collect(Collectors.toList()));
        }
        for (ImUserPackets dto : chatUserList) {
            dto.setMaster(dto.getId().equals(chatGroup.getGroupChatMasterId()));
            dto.setRealname(dto.getRealname() + "_" + dto.getElsAccount());
        }
        chatUserList.sort(Comparator.comparing(ImUserPackets::isMaster));
        return Result.ok(chatUserList);
    }

    @Operation(summary="\u6dfb\u52a0\u597d\u53cb", description="\u6dfb\u52a0\u597d\u53cb")
    @GetMapping(value={"/addFriend"})
    public Result<?> addFriend(@RequestParam(name="friendId") String friendId, @RequestParam(name="groupId") String groupId) {
        this.imUserGroupServiceImpl.addFriend(friendId, groupId);
        LoginUserDTO loginSysUser = SrmUtil.getLoginUser();
        ImUserPackets user = new ImUserPackets();
        user.setId(loginSysUser.getId());
        user.setRealname(loginSysUser.getRealname());
        user.setHeadPortrait(loginSysUser.getAvatar());
        user.setElsAccount(loginSysUser.getElsAccount());
        user.setSubAccount(loginSysUser.getSubAccount());
        user.setCreateTime(new Date());
        WsResultPackets wsResult = new WsResultPackets();
        wsResult.setMsgType(WsMsgTypePackets.ADD_FRIEND_REQUEST.getMsgType());
        wsResult.setData((Object)user);
        ImPackets imPacket = ImPackets.fromText(wsResult);
        imPacket.setMessageId(IdWorker.getIdStr());
        imPacket.setServerId(TioConfigConstant.SERVER_ID);
        ImSender.sendToUserChannelContext(friendId, (TioConfig)TioConfigConstant.tioServerConfig, imPacket);
        return Result.ok((String)I18nUtil.translate((String)"\u5df2\u53d1\u9001\u597d\u53cb\u8bf7\u6c42"));
    }

    @Operation(summary="\u540c\u610f\u597d\u53cb\u7533\u8bf7", description="\u540c\u610f\u597d\u53cb\u7533\u8bf7")
    @GetMapping(value={"/agreeFriendRequest"})
    public Result<?> agreeFriendRequest(@RequestParam(name="friendId") String friendId, @RequestParam(name="groupId") String groupId) {
        ImUserFriend friend = this.imUserGroupServiceImpl.agreeFriendRequest(friendId, groupId);
        LoginUserDTO loginSysUser = SrmUtil.getLoginUser();
        ImUserPackets user = new ImUserPackets();
        user.setId(loginSysUser.getId());
        user.setRealname(loginSysUser.getRealname());
        user.setHeadPortrait(loginSysUser.getAvatar());
        user.setElsAccount(loginSysUser.getElsAccount());
        user.setSubAccount(loginSysUser.getSubAccount());
        user.setStatus(friend.getUserGroupId());
        user.setGroupId(friend.getUserGroupId());
        user.setCreateTime(new Date());
        WsResultPackets wsResult = new WsResultPackets();
        wsResult.setMsgType(WsMsgTypePackets.ADD_FRIEND_AGREE.getMsgType());
        wsResult.setData((Object)user);
        ImPackets imPacket = ImPackets.fromText(wsResult);
        imPacket.setMessageId(IdWorker.getIdStr());
        imPacket.setServerId(TioConfigConstant.SERVER_ID);
        ImSender.sendToUserChannelContext(friendId, (TioConfig)TioConfigConstant.tioServerConfig, imPacket);
        return Result.ok();
    }

    @Operation(summary="\u5220\u9664\u597d\u53cb", description="\u5220\u9664\u597d\u53cb")
    @GetMapping(value={"/deleteFriend"})
    public Result<?> deleteFriend(@RequestParam(name="friendId") String friendId) {
        LoginUserDTO sysUser = SrmUtil.getLoginUser();
        this.imUserFriendService.deleteFriend(sysUser.getId(), friendId);
        ImUserPackets user = new ImUserPackets();
        user.setId(sysUser.getId());
        user.setRealname(sysUser.getRealname());
        user.setHeadPortrait(sysUser.getAvatar());
        user.setElsAccount(sysUser.getElsAccount());
        user.setSubAccount(sysUser.getSubAccount());
        user.setCreateTime(new Date());
        WsResultPackets wsResult = new WsResultPackets();
        wsResult.setMsgType(WsMsgTypePackets.DELETE_FRIEND_SUCCESS.getMsgType());
        wsResult.setData((Object)user);
        ImPackets imPacket = ImPackets.fromText(wsResult);
        imPacket.setMessageId(IdWorker.getIdStr());
        imPacket.setServerId(TioConfigConstant.SERVER_ID);
        ImSender.sendToUserChannelContext(friendId, (TioConfig)TioConfigConstant.tioServerConfig, imPacket);
        return Result.ok();
    }

    @Operation(summary="\u67e5\u8be2\u7cfb\u7edf\u7528\u6237", description="\u67e5\u8be2\u7cfb\u7edf\u7528\u6237")
    @GetMapping(value={"/getUserByKeyword"})
    public Result<?> getUserByKeyword(@RequestParam(name="keyword") String keyword) {
        List<ElsSubAccount> accountList = this.imAccountLocalServiceImpl.getUserByKeyWord(keyword);
        List userIds = accountList.stream().map(ParentEntity::getId).distinct().collect(Collectors.toList());
        ArrayList<ImUserPackets> imUserDtoList = new ArrayList<ImUserPackets>();
        if (!userIds.isEmpty()) {
            LambdaQueryWrapper mine = Wrappers.lambdaQuery();
            mine.select(new SFunction[]{ImUserFriend::getFriendId, ImUserFriend::getFriendGroupId});
            ((LambdaQueryWrapper)((LambdaQueryWrapper)mine.eq(ImUserFriend::getUserId, (Object)SrmUtil.getLoginUser().getId())).in(ImUserFriend::getFriendId, userIds)).eq(BaseEntity::getDeleted, (Object)0);
            Map<String, Boolean> requestMap = this.imUserFriendService.list((Wrapper)mine).stream().collect(Collectors.toMap(ImUserFriend::getFriendId, x -> CharSequenceUtil.isNotEmpty((CharSequence)x.getFriendGroupId()), (v1, v2) -> v2));
            for (ElsSubAccount vo : accountList) {
                Boolean flag = requestMap.get(vo.getId());
                ImUserPackets dto = (ImUserPackets)((Object)Convert.convert(ImUserPackets.class, (Object)((Object)vo)));
                imUserDtoList.add(dto);
                if (null == flag) {
                    dto.setFriendStatus("0");
                    continue;
                }
                dto.setFriendStatus(flag != false ? "2" : "1");
            }
        }
        return Result.ok(imUserDtoList);
    }

    @Operation(summary="\u62d2\u7edd\u597d\u53cb\u8bf7\u6c42", description="\u62d2\u7edd\u597d\u53cb\u8bf7\u6c42")
    @GetMapping(value={"/refuseFriendRequest"})
    public Result<?> refuseFriendRequest(@RequestParam(name="requestId") String requestId) {
        this.imUserFriendService.delFriendRequest(requestId);
        return Result.ok();
    }

    @Operation(summary="\u83b7\u53d6\u597d\u53cb\u8bf7\u6c42\u5217\u8868", description="\u83b7\u53d6\u597d\u53cb\u8bf7\u6c42\u5217\u8868")
    @PostMapping(value={"/getFriendRequest"})
    public Result<?> getFriendRequest() {
        List<ImUserPackets> friendsRequest = this.getUserFriendsRequest(SrmUtil.getLoginUser().getId());
        return Result.ok(friendsRequest);
    }

    @Operation(summary="\u83b7\u53d6\u6240\u6709\u597d\u53cb", description="\u83b7\u53d6\u6240\u6709\u597d\u53cb")
    @PostMapping(value={"/getAllFriends"})
    public Result<?> getAllFriends() {
        List<ImUserGroupVO> friend = this.getUserFriends(SrmUtil.getLoginUser().getId());
        List<ElsSubAccount> subListOld = this.imAccountLocalServiceImpl.listSubAccountList(SrmUtil.getLoginUser().getElsAccount());
        List subList = Convert.toList(ImUserPackets.class, subListOld);
        List voList = friend.stream().filter(x -> CollectionUtil.isNotEmpty(x.getList())).flatMap(x -> x.getList().stream().peek(u -> u.setRealname(x.getGroupName() + "-" + u.getElsAccount() + "_" + u.getRealname()))).collect(Collectors.toList());
        Map map = voList.stream().collect(Collectors.toMap(BaseDTO::getId, Function.identity()));
        LoginUserDTO loginUser = SrmUtil.getLoginUser();
        for (ImUserPackets vo : subList) {
            if (map.containsKey(vo.getId()) || loginUser.getId().equals(vo.getId())) continue;
            vo.setRealname(loginUser.getCompanyName() + "-" + vo.getElsAccount() + "_" + vo.getRealname());
            vo.setEnterpriseName(loginUser.getCompanyName());
            voList.add(vo);
        }
        return Result.ok(voList);
    }
}

