/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.im.core.server.handler;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import com.els.api.dto.BaseDTO;
import com.els.modules.im.core.constant.TioConfigConstant;
import com.els.modules.im.core.message.BusinessHelper;
import com.els.modules.im.core.packets.ImPackets;
import com.els.modules.im.core.packets.ImUserPackets;
import com.els.modules.im.core.packets.MessagePackets;
import com.els.modules.im.core.packets.WsMessageDataPackets;
import com.els.modules.im.core.packets.WsMessagePackets;
import com.els.modules.im.core.packets.WsMsgTypePackets;
import com.els.modules.im.core.packets.WsResultPackets;
import com.els.modules.im.core.server.handler.HandlerManager;
import com.els.modules.im.core.server.handler.OptHandler;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.tio.core.ChannelContext;
import org.tio.core.Tio;
import org.tio.core.intf.Packet;
import org.tio.websocket.common.WsRequest;

public abstract class AbstractConnHandler
implements OptHandler,
InitializingBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractConnHandler.class);
    @Resource(name="srmBusinessHelper")
    private BusinessHelper srmBusinessHelper;

    @Override
    public Object handler(WsRequest wsRequest, WsMessagePackets wsMessage, ChannelContext channelContext) {
        WsResultPackets wsResult = new WsResultPackets();
        Object obj = this.doHandler(wsResult, wsRequest, wsMessage, channelContext);
        this.asyncHandlerAfter(obj, wsResult, wsRequest, wsMessage, channelContext);
        return obj;
    }

    protected abstract Object doHandler(WsResultPackets var1, WsRequest var2, WsMessagePackets var3, ChannelContext var4);

    protected void asyncHandlerAfter(Object resultObj, WsResultPackets wsResult, WsRequest wsRequest, WsMessagePackets wsMessage, ChannelContext channelContext) {
    }

    @Override
    public Object reCallOnText(WsRequest wsRequest, String text, ChannelContext channelContext) {
        return null;
    }

    protected OptHandler register() {
        return this;
    }

    public void afterPropertiesSet() {
        HandlerManager.register(this.opt().getValue(), this.register());
    }

    protected void sendOffLineMessage(ChannelContext channelContext, String type) {
        WsResultPackets wsResult = new WsResultPackets();
        List<MessagePackets> imMessageList = this.srmBusinessHelper.getUnReadMessage(channelContext.userid, type);
        if (CollectionUtil.isEmpty(imMessageList)) {
            return;
        }
        List<String> imUserId = imMessageList.stream().map(MessagePackets::getMessageFromId).distinct().collect(Collectors.toList());
        List<ImUserPackets> usersByUserIdList = this.srmBusinessHelper.getUsersByUserIdList(imUserId);
        Map userDTOMap = usersByUserIdList.stream().collect(Collectors.toMap(BaseDTO::getId, Function.identity(), (x1, x2) -> x2));
        ArrayList<WsMessageDataPackets> messageList = new ArrayList<WsMessageDataPackets>();
        for (MessagePackets imMessage : imMessageList) {
            WsMessageDataPackets message = new WsMessageDataPackets();
            message.setId(imMessage.getMessageToId());
            message.setMine(false);
            message.setMessageChatType(imMessage.getMessageChatType());
            ImUserPackets imUser = (ImUserPackets)((Object)userDTOMap.get(imMessage.getMessageFromId()));
            message.setRealname(imUser.getRealname());
            message.setMessageToId(imMessage.getMessageToId());
            message.setMessageContent(imMessage.getMessageContent());
            message.setMessageSendTime(imMessage.getMessageSendTime());
            message.setMessageFromId(imMessage.getMessageFromId());
            message.setMessageType(imMessage.getMessageType());
            message.setHeadPortrait(imUser.getHeadPortrait());
            messageList.add(message);
        }
        wsResult.setMsgType(WsMsgTypePackets.FRIEND_UNREAD_MESSAGE.getMsgType());
        wsResult.setData(messageList);
        ImPackets imPacket = ImPackets.fromText(wsResult);
        imPacket.setServerId(TioConfigConstant.SERVER_ID);
        Tio.send((ChannelContext)channelContext, (Packet)imPacket);
    }

    protected WsMessageDataPackets storeMessage(WsMessageDataPackets message, String readStatus, String type) {
        MessagePackets imMessage = new MessagePackets();
        imMessage.setMessageToId(message.getMessageToId());
        imMessage.setId(message.getId());
        imMessage.setMessageFromId(message.getMessageFromId());
        imMessage.setMessageSendTime((Date)DateUtil.date());
        imMessage.setMessageContent(message.getMessageContent());
        imMessage.setMessageStatus(readStatus);
        imMessage.setMessageChatType(type);
        imMessage.setMessageType(message.getMessageType());
        imMessage.setMessageReplyByRobot(message.getMessageReplyByRobot());
        imMessage.setMessageUndoStatus(0);
        imMessage = this.srmBusinessHelper.storeMessage(imMessage);
        message.setId(imMessage.getId());
        message.setMessageSendTime(imMessage.getMessageSendTime());
        message.setMessageUndoStatus(imMessage.getMessageUndoStatus());
        message.setMessageStatus(imMessage.getMessageStatus());
        return message;
    }

    protected ImPackets buildImPacket(WsResultPackets wsResult, WsMessageDataPackets message) {
        wsResult.setData(message);
        ImPackets imPacket = ImPackets.fromText(wsResult);
        imPacket.setMessageId(message.getId());
        imPacket.setServerId(TioConfigConstant.SERVER_ID);
        return imPacket;
    }
}

