/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.system.vo.DictModel;
import com.els.common.util.ConfigUtil;
import com.els.common.util.DictUtil;
import com.els.common.util.I18nUtil;
import com.els.common.util.InterfaceUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SrmRpcUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.base.api.service.BaseRpcService;
import com.els.modules.language.service.I18nService;
import com.els.modules.org.api.dto.PurchaseOrganizationInfoDTO;
import com.els.modules.org.api.enumrate.PurchaseOrgCategoryStatus;
import com.els.modules.org.api.service.PurchaseOrganizationInfoRpcService;
import com.els.modules.system.entity.Dict;
import com.els.modules.system.entity.DictItem;
import com.els.modules.system.mapper.DictItemMapper;
import com.els.modules.system.mapper.DictMapper;
import com.els.modules.system.model.TreeSelectModel;
import com.els.modules.system.service.DictItemService;
import com.els.modules.system.service.DictService;
import com.els.modules.system.vo.DzAddressVO;
import com.els.modules.system.vo.DzAreasVO;
import com.els.modules.system.vo.DzCitiesVO;
import com.els.modules.system.vo.DzCountryVO;
import com.els.modules.system.vo.DzProvincesVO;
import com.els.modules.system.vo.DzStreetsVO;
import com.els.rpc.service.InvokeAccountRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DictServiceImpl
extends ServiceImpl<DictMapper, Dict>
implements DictService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DictServiceImpl.class);
    private static final Map<String, String> cacheMap = new ConcurrentHashMap<String, String>();
    @Resource
    private DictMapper dictMapper;
    @Resource
    private DictItemMapper dictItemMapper;
    @Autowired
    private DictItemService dictItemService;
    @Autowired
    private I18nService i18nService;
    @Autowired
    private RedisUtil redisUtil;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;
    @Resource
    @Lazy
    private InvokeBaseRpcService invokeBaseRpcService;
    private static final String CATALOGUE = "sys:cache:dict";
    private static final String COLON = ":";

    @Override
    public List<DictModel> queryDictItemsByCode(String code, String elsAccount, String status) {
        log.info("queryDictItemsByCode.dictCode : " + code);
        log.info("queryDictItemsByCode.busAccount : " + elsAccount);
        String language = I18nUtil.getCurrentLanguage();
        if (StrUtil.isBlank((CharSequence)language)) {
            language = "zh";
        }
        StringBuilder redisKey = new StringBuilder(CATALOGUE).append(elsAccount).append(COLON).append(code).append(COLON).append(language);
        List<Object> list = (List<DictModel>)this.redisUtil.get(redisKey.toString());
        log.info("queryDictItemsByCode.redisKey : " + redisKey);
        if (list == null || CollectionUtils.isEmpty((Collection)list)) {
            log.info("\u65e0\u7f13\u5b58dictCache\u7684\u65f6\u5019\u8c03\u7528\u8fd9\u91cc\uff01");
            list = this.dictMapper.queryDictItemsByCode(code, elsAccount);
            if (CollectionUtil.isEmpty(list)) {
                list = this.dictMapper.queryDictItemsByCode(code, SysUtil.getPurchaseAccount());
            }
            if (CollectionUtil.isEmpty(list)) {
                list = this.dictMapper.queryDictItemsByCode(code, "100000");
            }
            this.redisUtil.set(redisKey.toString(), list, 0L);
        }
        log.info("queryDictItemsByCode.result : " + JSONObject.toJSONString((Object)list));
        if (!CollectionUtils.isEmpty(list)) {
            if ("1".equals(status)) {
                list = list.parallelStream().filter(item -> "1".equals(item.getStatus())).collect(Collectors.toList());
            }
            if (!language.equals("zh")) {
                list.forEach(item -> item.setText(I18nUtil.translate((String)item.getTextI18nKey(), (String)item.getText())));
            }
        }
        return list;
    }

    @Override
    public String queryDictTextByKey(String code, String key, String elsAccount) {
        List<DictModel> list;
        String language = I18nUtil.getCurrentLanguage();
        if (StrUtil.isBlank((CharSequence)language)) {
            language = "zh";
        }
        if (CollectionUtil.isNotEmpty(list = this.queryDictItemsByCode(code, elsAccount, "1"))) {
            for (DictModel dictModel : list) {
                if (!key.equals(dictModel.getValue())) continue;
                if (!language.equals("zh")) {
                    return I18nUtil.translate((String)dictModel.getTextI18nKey(), (String)dictModel.getText());
                }
                return dictModel.getText();
            }
        }
        return null;
    }

    @Override
    @Cacheable(value={"sys:cache:dict"}, key="#code+':text='+#text", sync=true)
    public String queryDictValueByText(String code, String text) {
        log.info("\u65e0\u7f13\u5b58dictText\u7684\u65f6\u5019\u8c03\u7528\u8fd9\u91cc\uff01");
        String val = this.dictMapper.queryDictValueByText(code, text, TenantContext.getTenant());
        if (StrUtil.isBlank((CharSequence)val)) {
            val = this.dictMapper.queryDictValueByText(code, text, "100000");
        }
        return val;
    }

    @Override
    public List<DictModel> queryTableDictItemsByCode(String table, String text, String code) {
        StringBuilder redisKey = new StringBuilder(CATALOGUE).append(TenantContext.getTenant()).append(COLON).append(table).append(text).append(code);
        List<DictModel> list = (List<DictModel>)this.redisUtil.get(redisKey.toString());
        if (list == null) {
            log.info("\u65e0\u7f13\u5b58dictTableList\u7684\u65f6\u5019\u8c03\u7528\u8fd9\u91cc\uff01");
            list = this.dictMapper.queryTableDictItemsByCode(table, text, code);
            this.redisUtil.set(redisKey.toString(), list, 0L);
        }
        return list;
    }

    @Override
    @Cacheable(value={"sys:cache:dictTable"})
    public List<String> queryTableDictByKeys(String table, String text, String code, String[] keyArray) {
        List<DictModel> dicts = this.dictMapper.queryTableDictByKeys(table, text, code, keyArray);
        ArrayList<String> texts = new ArrayList<String>(dicts.size());
        block0: for (String key : keyArray) {
            for (DictModel dict : dicts) {
                if (!key.equals(dict.getValue())) continue;
                texts.add(dict.getText());
                continue block0;
            }
        }
        return texts;
    }

    @Override
    public boolean deleteByDictId(Dict sysDict) {
        sysDict.setDeleted(CommonConstant.DEL_FLAG_1);
        return this.updateById((Object)sysDict);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(Dict sysDict, List<DictItem> sysDictItemList) {
        this.dictMapper.insert((Object)sysDict);
        if (sysDictItemList != null) {
            for (DictItem entity : sysDictItemList) {
                entity.setDictId(sysDict.getId());
                this.dictItemMapper.insert(entity);
            }
        }
        this.redisUtil.dels(DictUtil.getDictItemListRedisKey((String)TenantContext.getTenant(), (String)sysDict.getDictCode()));
    }

    @Override
    public List<DictModel> queryAllDepartBackDictModel() {
        return ((DictMapper)this.baseMapper).queryAllDepartBackDictModel();
    }

    @Override
    public List<DictModel> queryAllUserBackDictModel() {
        return ((DictMapper)this.baseMapper).queryAllUserBackDictModel();
    }

    @Override
    public List<DictModel> queryTableDictItems(String table, String text, String code, String keyword) {
        return ((DictMapper)this.baseMapper).queryTableDictItems(table, text, code, "%" + keyword + "%");
    }

    @Override
    public List<TreeSelectModel> queryTreeList(Map<String, String> query, String table, String text, String code, String pidField, String pid, String hasChildField) {
        return ((DictMapper)this.baseMapper).queryTreeList(query, table, text, code, pidField, pid, hasChildField);
    }

    @Override
    public void deleteOneDictPhysically(String id) {
        ((DictMapper)this.baseMapper).deleteOneById(id);
        this.dictItemMapper.delete((Wrapper)new LambdaQueryWrapper().eq(DictItem::getDictId, (Object)id));
    }

    @Override
    public void updateDictDelFlag(int delFlag, String id) {
        ((DictMapper)this.baseMapper).updateDictDelFlag(delFlag, id);
    }

    @Override
    public IPage<Dict> queryDeleteList(Page<Dict> page, QueryWrapper<Dict> queryWrapper) {
        return ((DictMapper)this.baseMapper).queryDeleteList(page, queryWrapper);
    }

    @Override
    public List<String> queryTableKeyword(String table, String column, String value) {
        return ((DictMapper)this.baseMapper).queryTableKeyword(table, column, "%" + value + "%");
    }

    @Override
    public String queryTableDictTextByFilterSql(String table, String text, String filterSql, String elsAccount) {
        StringBuilder redisKey = new StringBuilder(CATALOGUE).append(elsAccount).append(COLON).append(table).append(text).append(filterSql);
        String value = (String)this.redisUtil.get(redisKey.toString());
        if (StrUtil.isBlank((CharSequence)value)) {
            if (StrUtil.isBlank((CharSequence)filterSql)) {
                filterSql = "1 = 1";
            }
            StringBuilder sql = new StringBuilder(filterSql);
            sql.append(" and is_deleted = '0'");
            if (!filterSql.contains("els_account") && !filterSql.contains("id =")) {
                sql.append(" and els_account='").append(elsAccount).append("' ");
            }
            if (StrUtil.isBlank((CharSequence)(value = ((DictMapper)this.baseMapper).queryTableDictTextByFilterSql(table, text, sql.toString())))) {
                sql = new StringBuilder(filterSql);
                sql.append(" and is_deleted = '0'");
                if (!filterSql.contains("els_account") && !filterSql.contains("id =")) {
                    sql.append(" and els_account='").append("100000").append("' ");
                }
                value = ((DictMapper)this.baseMapper).queryTableDictTextByFilterSql(table, text, sql.toString());
            }
            this.redisUtil.set(redisKey.toString(), (Object)value, 0L);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String queryTableDictItemsByValue(String table, String text, String code, String filterSql, String val, String elsAccountParam) {
        try {
            String elsAccount = StrUtil.isBlank((CharSequence)elsAccountParam) ? TenantContext.getTenant() : elsAccountParam;
            TenantContext.setTenant((String)elsAccount);
            StringBuilder redisKey = new StringBuilder(CATALOGUE).append(elsAccount).append(COLON).append(table).append(code).append(filterSql);
            String value = (String)this.redisUtil.get(redisKey.toString());
            if (StrUtil.isBlank((CharSequence)value)) {
                if (StrUtil.isBlank((CharSequence)filterSql)) {
                    filterSql = "1 = 1";
                }
                StringBuilder sql = new StringBuilder(filterSql);
                sql.append(" and is_deleted = '0'");
                if (!filterSql.contains("els_account") && !filterSql.contains("id =")) {
                    sql.append(" and els_account='").append(elsAccount).append("' ");
                }
                if (StrUtil.isBlank((CharSequence)(value = ((DictMapper)this.baseMapper).queryTableDictItemsByValue(table, code, sql.toString())))) {
                    sql = new StringBuilder(filterSql);
                    sql.append(" and is_deleted = '0'");
                    if (!filterSql.contains("els_account") && !filterSql.contains("id =")) {
                        sql.append(" and els_account='").append("100000").append("' ");
                    }
                    value = ((DictMapper)this.baseMapper).queryTableDictItemsByValue(table, code, sql.toString());
                }
                this.redisUtil.set(redisKey.toString(), (Object)value, 0L);
            }
            String string = value;
            return string;
        }
        finally {
            TenantContext.clear();
        }
    }

    @Override
    public void addDictI18nKey() {
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().and(p -> ((LambdaQueryWrapper)((LambdaQueryWrapper)p.isNull(Dict::getDictNameI18nKey)).or()).eq(Dict::getDictNameI18nKey, (Object)""))).list();
        List list1 = ((LambdaQueryChainWrapper)this.dictItemService.lambdaQuery().and(p -> ((LambdaQueryWrapper)((LambdaQueryWrapper)p.isNull(DictItem::getItemTextI18nKey)).or()).eq(DictItem::getItemTextI18nKey, (Object)""))).list();
        if (CollectionUtils.isEmpty((Collection)list) && CollectionUtils.isEmpty((Collection)list1)) {
            return;
        }
        ArrayList<String> collect = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            collect = list.parallelStream().map(o -> o.getDictName()).distinct().collect(Collectors.toList());
        }
        if (!CollectionUtils.isEmpty((Collection)list1)) {
            List collect1 = list1.parallelStream().map(o -> o.getItemText()).distinct().collect(Collectors.toList());
            collect.addAll(collect1);
        }
        if (!CollectionUtils.isEmpty(collect)) {
            Map<String, String> stringStringMap = this.i18nService.checkAndAdd(collect, "dict");
            list.forEach(item -> item.setDictNameI18nKey((String)stringStringMap.get(item.getDictName())));
            list1.forEach(item -> item.setItemTextI18nKey((String)stringStringMap.get(item.getItemText())));
            this.updateBatchById(list);
            this.dictItemService.updateBatchById(list1);
        }
        this.redisUtil.del(new String[]{"sys:cache:dict*"});
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void addToEnterprise(String id) {
        Dict dict = (Dict)((Object)this.dictMapper.selectById((Serializable)((Object)id)));
        List<DictItem> items = this.dictItemMapper.selectItemsByMainId(id);
        String subAccount = SysUtil.getLoginUser().getSubAccount();
        String elsAccount = TenantContext.getTenant();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"els_account", (Object)elsAccount);
        queryWrapper.eq((Object)"dict_code", (Object)dict.getDictCode());
        List oldDicts = this.dictMapper.selectList((Wrapper)queryWrapper);
        if (!oldDicts.isEmpty()) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_rJCIMKAEJCs_8a9040ea", (String)"\u8be5\u5b57\u5178\u5df2\u5b58\u5728\u4f01\u4e1a\u5b57\u5178\u4e2d!"));
        }
        int count = this.dictMapper.loadDictFromRecycle(dict.getDictCode(), elsAccount);
        if (count > 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_rJCMKAEJCMlXsVRyMMSNqnQGKwtk_2fc226ed", (String)"\u8be5\u5b57\u5178\u5b58\u5728\u4f01\u4e1a\u5b57\u5178\u56de\u6536\u7ad9\u4e2d\uff0c\u8bf7\u76f4\u63a5\u53d6\u56de\u6216\u8005\u5f7b\u5e95\u5220\u9664\u518d\u6765\u64cd\u4f5c!"));
        }
        dict.setId(null);
        dict.setElsAccount(elsAccount);
        dict.setCreateBy(subAccount);
        dict.setUpdateBy(subAccount);
        dict.setCreateTime(new Date());
        dict.setUpdateTime(new Date());
        this.dictMapper.insert((Object)dict);
        for (DictItem item : items) {
            item.setId(null);
            item.setDictId(dict.getId());
            item.setElsAccount(elsAccount);
            item.setCreateBy(subAccount);
            item.setUpdateBy(subAccount);
            item.setCreateTime(new Date());
            item.setUpdateTime(new Date());
            this.dictItemMapper.insert(item);
        }
    }

    @Override
    public void getDataByErp() {
        String elsAccount = TenantContext.getTenant();
        InterfaceUtil interfaceUtil = (InterfaceUtil)SpringContextUtils.getBean(InterfaceUtil.class);
        List<String> codes = Arrays.asList("getUnitData", "getCurrencyData", "getPayConditionData", "getSupplierGroup", "getSettlementTypeData", "getSupplierClassify", "getAssistantData");
        JSONObject custom = new JSONObject();
        custom.put("elsAccount", (Object)elsAccount);
        interfaceUtil.callInterface(elsAccount, codes, (Object)custom);
    }

    @Override
    public void pushDataToErp(String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        List dictList = this.listByIds(idList).stream().filter(head -> !"1".equals(head.getReturnState())).collect(Collectors.toList());
        for (Dict head2 : dictList) {
            this.pushDataToErp(head2);
        }
    }

    @Override
    public List<DictItem> findOpenbusinessType() {
        JSONObject companySet;
        LoginUserDTO user = SysUtil.getLoginUser();
        String permissionScope = null;
        if (user != null && (companySet = ((BaseRpcService)SrmRpcUtil.getExecuteServiceImpl(BaseRpcService.class)).getParamObj(user.getElsAccount())) != null) {
            permissionScope = companySet.getString("permissionScope");
        }
        ArrayList<DictItem> dictItems = new ArrayList<DictItem>();
        DictItem dictItem = new DictItem();
        dictItem.setItemValue("all");
        dictItem.setItemText(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"));
        dictItems.add(dictItem);
        if (StrUtil.isNotBlank((CharSequence)permissionScope)) {
            LambdaQueryWrapper dictQueryWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)dictQueryWrapper.eq(ParentEntity::getElsAccount, (Object)SysUtil.getPurchaseAccount())).eq(Dict::getDictCode, (Object)"permissionScope");
            Dict dict = (Dict)((Object)((DictMapper)this.baseMapper).selectOne((Wrapper)dictQueryWrapper));
            if (dict == null) {
                dictQueryWrapper.clear();
                ((LambdaQueryWrapper)dictQueryWrapper.eq(ParentEntity::getElsAccount, (Object)"100000")).eq(Dict::getDictCode, (Object)"permissionScope");
                dict = (Dict)((Object)((DictMapper)this.baseMapper).selectOne((Wrapper)dictQueryWrapper));
            }
            if (dict != null) {
                List<DictItem> items = this.dictItemService.selectItemsByMainId(dict.getId());
                List scopeList = StrUtil.split((CharSequence)permissionScope, (CharSequence)",");
                for (DictItem item : items) {
                    if (!scopeList.contains(item.getItemValue())) continue;
                    dictItems.add(item);
                }
            }
        }
        return dictItems;
    }

    @Override
    public void deleteRedisCache() {
        this.redisUtil.del(new String[]{"sys:cache:dict*"});
        this.redisUtil.dels("srm:base:dict:itemList:" + TenantContext.getTenant() + "*");
    }

    @Override
    public void checkSysDictCode(String dictCode) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(ParentEntity::getElsAccount, (Object)"100000")).eq(Dict::getDictCode, (Object)dictCode)).eq(Dict::getDictType, (Object)"system");
        if (((DictMapper)this.baseMapper).selectCount((Wrapper)wrapper) > 0L) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APJCAoLHeJCxiTjDSuAtQG_3dbed16e", (String)"\u5f53\u524d\u5b57\u5178\u7f16\u7801\u4e3a\u7cfb\u7edf\u5b57\u5178\uff0c\u4e0d\u5141\u8bb8\u7528\u6237\u6dfb\u52a0\u3001\u7f16\u8f91\u3001\u5220\u9664"));
        }
        this.redisUtil.dels(DictUtil.getDictItemListRedisKey((String)TenantContext.getTenant(), (String)dictCode));
    }

    @Override
    public void batchSaveMain(String elsAccount, String dictCode, String dictCodeName, List<DictItem> dictDTOS) {
        Dict dict = this.findDictByDictCode(elsAccount, dictCode);
        if (null == dict) {
            dict = new Dict();
            dict.setElsAccount(elsAccount);
            dict.setDeleted(0);
            dict.setDictCode(dictCode);
            dict.setDictName(dictCodeName);
            dict.setDescription(dictCodeName);
            dict.setCreateBy(elsAccount);
            dict.setCreateTime(new Date());
            dict.setElsAccount(elsAccount);
            this.save((Object)dict);
        }
        ArrayList<DictItem> dictItems = new ArrayList<DictItem>();
        Map collect = this.dictItemService.selectItemsByMainId(dict.getId()).stream().collect(Collectors.toMap(DictItem::getThirdPartyId, Function.identity(), (v1, v2) -> v2));
        for (DictItem dto : dictDTOS) {
            if (collect.containsKey(dto.getThirdPartyId())) continue;
            dto.setDictId(dict.getId());
            dto.setStatus(1);
            dictItems.add(dto);
        }
        if (!CollectionUtils.isEmpty(dictItems)) {
            this.dictItemService.saveBatch(dictItems, 200);
        }
    }

    @Override
    public List<DictItem> findByDictCode(String elsAccount, String dictCode) {
        Dict dict = this.findDictByDictCode(elsAccount, dictCode);
        if (null == dict) {
            throw new ELSBootException("\u8be5\u5b57\u6bb5\u4e0d\u5b58\u5728\uff0c\u64cd\u4f5c\u65f6\u62a5");
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(DictItem::getDictId, (Object)dict.getId());
        return this.dictItemService.list((Wrapper)wrapper);
    }

    @Override
    public IPage<DzAddressVO> queryDzAddressPage(Page<DzAddressVO> page, QueryWrapper<DzAddressVO> queryWrapper) {
        return this.dictMapper.queryDzAddressPage(page, queryWrapper);
    }

    @Override
    public IPage<DzCountryVO> queryDzCountryPage(Page<DzCountryVO> page, QueryWrapper<DzCountryVO> queryWrapper) {
        return this.dictMapper.queryDzCountryPage(page, queryWrapper);
    }

    @Override
    public IPage<DzProvincesVO> queryDzProvincesPage(Page<DzProvincesVO> page, QueryWrapper<DzProvincesVO> queryWrapper) {
        return this.dictMapper.queryDzProvincesPage(page, queryWrapper);
    }

    @Override
    public IPage<DzCitiesVO> queryDzCitiesPage(Page<DzCitiesVO> page, QueryWrapper<DzCitiesVO> queryWrapper) {
        return this.dictMapper.queryDzCitiesPage(page, queryWrapper);
    }

    @Override
    public IPage<DzAreasVO> queryDzAreasPage(Page<DzAreasVO> page, QueryWrapper<DzAreasVO> queryWrapper) {
        return this.dictMapper.queryDzAreasPage(page, queryWrapper);
    }

    @Override
    public IPage<DzStreetsVO> queryDzStreetsPage(Page<DzStreetsVO> page, QueryWrapper<DzStreetsVO> queryWrapper) {
        return this.dictMapper.queryDzStreetsPage(page, queryWrapper);
    }

    @Override
    public void deleteCacheByKey(String redisKey) {
        if (this.redisUtil.hasKey(redisKey)) {
            log.info("redisObj is : {}", (Object)JSONObject.toJSONString((Object)this.redisUtil.get(redisKey)));
        }
        this.redisUtil.del(new String[]{redisKey});
    }

    private Dict findDictByDictCode(String elsAccount, String dictCode) {
        Dict dict = (Dict)((Object)this.dictMapper.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Dict::getDictCode, (Object)dictCode)).eq(BaseEntity::getDeleted, (Object)0)).eq(ParentEntity::getElsAccount, (Object)elsAccount)));
        return dict;
    }

    private void pushDataToErp(Dict head) {
        String elsAccount = TenantContext.getTenant();
        InterfaceUtil interfaceUtil = (InterfaceUtil)SpringContextUtils.getBean(InterfaceUtil.class);
        interfaceUtil.callInterface(elsAccount, "getAssistantData", (Object)new JSONObject());
    }

    @Override
    public List<DictItem> getItemListByCode(String elsAccount, String dictCode) {
        String redisKey = DictUtil.getDictItemListRedisKey((String)elsAccount, (String)dictCode);
        List<DictItem> dictItemList = (ArrayList<DictItem>)this.redisUtil.get(redisKey);
        if (dictItemList != null) {
            return dictItemList;
        }
        if (PurchaseOrgCategoryStatus.isOrg((String)dictCode)) {
            List orgList = ((PurchaseOrganizationInfoRpcService)SrmRpcUtil.getExecuteServiceImpl(PurchaseOrganizationInfoRpcService.class)).getCurrentAccountOrgList(elsAccount, dictCode);
            dictItemList = new ArrayList<DictItem>();
            for (PurchaseOrganizationInfoDTO org : orgList) {
                DictItem item = new DictItem();
                item.setItemText(org.getOrgName());
                item.setItemValue(org.getOrgCode());
                dictItemList.add(item);
            }
        } else {
            Dict dict = (Dict)((Object)this.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ParentEntity::getElsAccount, (Object)elsAccount)).eq(Dict::getDictCode, (Object)dictCode), false));
            if (dict == null) {
                dict = (Dict)((Object)this.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ParentEntity::getElsAccount, (Object)ConfigUtil.getPurchaseAccount())).eq(Dict::getDictCode, (Object)dictCode), false));
            }
            if (dict == null) {
                dict = (Dict)((Object)this.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ParentEntity::getElsAccount, (Object)"100000")).eq(Dict::getDictCode, (Object)dictCode), false));
            }
            if (dict != null) {
                dictItemList = this.dictItemService.selectItemsByMainId(dict.getId());
            }
        }
        if (dictItemList == null) {
            dictItemList = new ArrayList();
            this.redisUtil.set(redisKey, new ArrayList(), 180L);
        } else {
            this.redisUtil.set(redisKey, dictItemList);
        }
        return dictItemList;
    }

    @Override
    public DictItem getItemByCode(String elsAccount, String dictCode, String itemValue) {
        List<DictItem> dictItemList = this.getItemListByCode(elsAccount, dictCode);
        for (DictItem item : dictItemList) {
            if (!item.getItemValue().equals(itemValue)) continue;
            return item;
        }
        return null;
    }

    @Override
    public List<DictItem> findItemListByCode(String elsAccount, String dictCode) {
        List<DictItem> dictItemList = this.getItemListByCode(elsAccount, dictCode);
        dictItemList.forEach(item -> {
            item.setText(item.getItemText());
            item.setValue(item.getItemValue());
            item.setTitle(item.getItemText());
        });
        return this.buildItem(dictItemList);
    }

    private List<DictItem> buildItem(List<DictItem> dictItemList) {
        List<DictItem> checkList;
        String language = I18nUtil.getCurrentLanguage();
        if (!"zh".equals(language)) {
            String elsAccount = TenantContext.getTenant();
            dictItemList.forEach(item -> {
                String cacheKey = elsAccount + item.getTitle() + language;
                if (cacheMap.containsKey(cacheKey)) {
                    item.setTitle(cacheMap.get(cacheKey));
                } else {
                    String i18nName = I18nUtil.translate((String)item.getTitle());
                    cacheMap.put(cacheKey, i18nName);
                    item.setTitle(i18nName);
                }
            });
        }
        if ((checkList = dictItemList.stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getItemParentValue())).toList()).isEmpty()) {
            return dictItemList;
        }
        Map itemMap = dictItemList.stream().collect(Collectors.toMap(DictItem::getId, Function.identity()));
        ArrayList<DictItem> trees = new ArrayList<DictItem>();
        for (DictItem item2 : dictItemList) {
            if (StrUtil.isBlank((CharSequence)item2.getItemParentValue()) || !itemMap.containsKey(item2.getItemParentValue())) {
                trees.add(item2);
                continue;
            }
            DictItem parentItem = (DictItem)itemMap.get(item2.getItemParentValue());
            parentItem.getChildren().add(item2);
        }
        return trees;
    }
}

