/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.entity.PermissionData;
import com.els.modules.system.mapper.ElsSubAccountMapper;
import com.els.modules.system.mapper.PermissionDataMapper;
import com.els.modules.system.service.PermissionDataService;
import com.els.modules.system.vo.PermissionDataVO;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PermissionDataServiceImpl
extends ServiceImpl<PermissionDataMapper, PermissionData>
implements PermissionDataService {
    private static final String PERMISSION_DATA_KEY = "sys:permissionData:";
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private ElsSubAccountMapper elsSubAccountMapper;

    private void checkData(PermissionDataVO permissionData) {
        List<PermissionData> dataList = permissionData.getPermissionDataList();
        ArrayList<CallSite> checkList = new ArrayList<CallSite>();
        for (PermissionData data : dataList) {
            String key = data.getSubAccount() + data.getBusinessType() + data.getPermissionField() + data.getPermissionValue();
            if (checkList.contains(key)) {
                throw new ELSBootException("\u6743\u9650\u6570\u636e\u914d\u7f6e\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
            checkList.add((CallSite)((Object)key));
        }
    }

    @Override
    public void savePermissionData(PermissionData permissionData) {
        ((PermissionDataMapper)this.baseMapper).insert((Object)permissionData);
    }

    @Override
    public void updatePermissionData(PermissionDataVO permissionData) {
        this.checkData(permissionData);
        String elsAccount = TenantContext.getTenant();
        String subAccount = permissionData.getSubAccount();
        List<PermissionData> dataList = permissionData.getPermissionDataList();
        ((PermissionDataMapper)this.baseMapper).deleteByMainId(elsAccount, subAccount);
        for (PermissionData data : dataList) {
            data.setId(IdWorker.getIdStr());
            data.setUserId(permissionData.getId());
            data.setElsAccount(elsAccount);
            data.setSubAccount(subAccount);
            data.setDeleted(CommonConstant.DEL_FLAG_0);
            data.setCreateTime(new Date());
            data.setUpdateTime(data.getCreateTime());
            data.setCreateById(null);
            data.setUpdateById(null);
            data.setCreateBy(SysUtil.getCurrentBy());
            data.setUpdateBy(SysUtil.getCurrentBy());
        }
        if (dataList.size() > 0) {
            this.saveBatch(dataList);
        }
        String redisKey = this.getRedisKey(elsAccount, subAccount);
        this.redisUtil.del(new String[]{redisKey});
        ElsSubAccount account = new ElsSubAccount();
        account.setId(permissionData.getId());
        account.setSensitiveFieldGroups(permissionData.getSensitiveFieldGroups());
        this.elsSubAccountMapper.updateById((Object)account);
        String redisKey1 = String.format("%s::%s", "sys:cache:user", elsAccount + "_" + subAccount);
        this.redisUtil.del(new String[]{redisKey1});
    }

    @Override
    public void savePermissionDataBus(PermissionDataVO permissionData) {
        List<PermissionData> dataList = permissionData.getPermissionDataList();
        ArrayList<CallSite> p = new ArrayList<CallSite>();
        if (CollectionUtils.isEmpty(dataList)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_LGRbWERcVH_60b159f2", (String)"\u672a\u8bbe\u7f6e\u6743\u9650\u914d\u7f6e\u884c\u4fe1\u606f"));
        }
        for (PermissionData data : dataList) {
            p.add((CallSite)((Object)(data.getSubAccount() + "_" + permissionData.getBusinessType() + "_" + data.getPermissionField() + "_" + data.getPermissionValue())));
        }
        QueryWrapper wrapper = Wrappers.query();
        wrapper.in((Object)"sub_account+'_'+business_type+'_'+permission_field+'_'+permission_value", p);
        wrapper.lambda().eq(ParentEntity::getElsAccount, (Object)SysUtil.getLoginUser().getElsAccount());
        List dbDataList = ((PermissionDataMapper)this.baseMapper).selectList((Wrapper)wrapper);
        List dbList = dbDataList.stream().map(x -> x.getSubAccount() + "_" + x.getBusinessType() + "_" + x.getPermissionField() + "_" + x.getPermissionValue()).collect(Collectors.toList());
        int size = p.size();
        p.removeAll(dbList);
        if (p.size() != size) {
            throw new ELSBootException("\u6743\u9650\u6570\u636e\u914d\u7f6e\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        this.checkData(permissionData);
        String elsAccount = TenantContext.getTenant();
        String businessType = permissionData.getBusinessType();
        for (PermissionData data : dataList) {
            data.setId(IdWorker.getIdStr());
            data.setElsAccount(elsAccount);
            data.setBusinessType(businessType);
            data.setDeleted(CommonConstant.DEL_FLAG_0);
            data.setCreateTime(new Date());
            data.setUpdateTime(data.getCreateTime());
            data.setCreateBy(SysUtil.getCurrentBy());
            data.setUpdateBy(SysUtil.getCurrentBy());
        }
        if (dataList.size() > 0) {
            this.saveBatch(dataList);
        }
        List currentList = dataList.stream().map(PermissionData::getSubAccount).distinct().collect(Collectors.toList());
        for (String subAccount : currentList) {
            String redisKey = this.getRedisKey(elsAccount, subAccount);
            this.redisUtil.del(new String[]{redisKey});
            String redisKey1 = String.format("%s::%s", "sys:cache:user", elsAccount + "_" + subAccount);
            this.redisUtil.del(new String[]{redisKey1});
        }
    }

    @Override
    public void updatePermissionDataBus(PermissionDataVO permissionData) {
        this.checkData(permissionData);
        String elsAccount = TenantContext.getTenant();
        String businessType = permissionData.getBusinessType();
        List<PermissionData> dataList = permissionData.getPermissionDataList();
        List list = this.list((Wrapper)new QueryWrapper()).stream().map(PermissionData::getSubAccount).distinct().collect(Collectors.toList());
        ((PermissionDataMapper)this.baseMapper).deleteByType(elsAccount, businessType);
        for (PermissionData data : dataList) {
            data.setId(IdWorker.getIdStr());
            data.setElsAccount(elsAccount);
            data.setBusinessType(businessType);
            data.setDeleted(CommonConstant.DEL_FLAG_0);
            data.setCreateTime(new Date());
            data.setUpdateTime(data.getCreateTime());
            data.setCreateBy(SysUtil.getCurrentBy());
            data.setUpdateBy(SysUtil.getCurrentBy());
        }
        if (dataList.size() > 0) {
            this.saveBatch(dataList);
        }
        List currentList = dataList.stream().map(PermissionData::getSubAccount).distinct().collect(Collectors.toList());
        list.addAll(currentList);
        for (String subAccount : list) {
            String redisKey = this.getRedisKey(elsAccount, subAccount);
            this.redisUtil.del(new String[]{redisKey});
            String redisKey1 = String.format("%s::%s", "sys:cache:user", elsAccount + "_" + subAccount);
            this.redisUtil.del(new String[]{redisKey1});
        }
    }

    @Override
    public void delPermissionData(String id) {
        PermissionData data = (PermissionData)((Object)((PermissionDataMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        if (data != null) {
            ((PermissionDataMapper)this.baseMapper).deleteById((Serializable)((Object)id));
            String redisKey = this.getRedisKey(data.getElsAccount(), data.getSubAccount());
            this.redisUtil.del(new String[]{redisKey});
        }
    }

    @Override
    public void delBatchPermissionData(List<String> idList) {
        ((PermissionDataMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public List<PermissionData> getPermissionDataList(String elsAccount, String subAccount) {
        String redisKey = this.getRedisKey(elsAccount, subAccount);
        List dataList = (List)this.redisUtil.get(redisKey);
        if (dataList == null) {
            dataList = ((PermissionDataMapper)this.baseMapper).selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)elsAccount)).eq((Object)"sub_account", (Object)subAccount));
            this.redisUtil.set(redisKey, (Object)dataList);
        }
        return dataList;
    }

    @Override
    public List<PermissionData> getPermissionDataList(String elsAccount, String subAccount, String businessType) {
        List<PermissionData> dataList = this.getPermissionDataList(elsAccount, subAccount);
        if (dataList != null) {
            dataList = dataList.parallelStream().filter(data -> data.getBusinessType().equals(businessType) || "all".equals(data.getBusinessType())).collect(Collectors.toList());
        }
        return dataList;
    }

    private String getRedisKey(String elsAccount, String subAccount) {
        StringBuilder key = new StringBuilder(PERMISSION_DATA_KEY);
        key.append(elsAccount).append("_").append(subAccount);
        return key.toString();
    }

    @Override
    public void batchSave(List<PermissionData> dataList) {
        List updateList = dataList.stream().filter(x -> CharSequenceUtil.isNotEmpty((CharSequence)x.getId())).collect(Collectors.toList());
        List addList = dataList.stream().filter(x -> CharSequenceUtil.isEmpty((CharSequence)x.getId())).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(updateList)) {
            this.updateBatchById(updateList);
        }
        if (CollectionUtil.isNotEmpty(addList)) {
            this.saveBatch(addList);
        }
        String elsAccount = TenantContext.getTenant();
        List list = dataList.parallelStream().map(PermissionData::getSubAccount).distinct().collect(Collectors.toList());
        for (String subAccount : list) {
            String key = this.getRedisKey(elsAccount, subAccount);
            this.redisUtil.del(new String[]{key});
        }
    }

    @Override
    public void copyPermission(PermissionDataVO data) {
        List<PermissionData> suorceList = this.getPermissionDataList(TenantContext.getTenant(), data.getSubAccount());
        if (suorceList == null || suorceList.isEmpty()) {
            return;
        }
        List<ElsSubAccount> accountList = data.getSubAccountList();
        if (accountList == null || accountList.isEmpty()) {
            return;
        }
        ArrayList<PermissionData> insertList = new ArrayList<PermissionData>();
        for (ElsSubAccount account : accountList) {
            if (account.getSubAccount().equals(data.getSubAccount())) continue;
            ((PermissionDataMapper)this.baseMapper).deleteByMainId(account.getElsAccount(), account.getSubAccount());
            String redisKey = this.getRedisKey(account.getElsAccount(), account.getSubAccount());
            this.redisUtil.del(new String[]{redisKey});
            for (PermissionData suorceData : suorceList) {
                PermissionData permissionData = new PermissionData();
                BeanUtils.copyProperties((Object)((Object)suorceData), (Object)((Object)permissionData));
                permissionData.setId(IdWorker.getIdStr());
                permissionData.setUserId(account.getId());
                permissionData.setElsAccount(account.getElsAccount());
                permissionData.setSubAccount(account.getSubAccount());
                permissionData.setDeleted(CommonConstant.DEL_FLAG_0);
                permissionData.setCreateTime(new Date());
                insertList.add(permissionData);
            }
        }
        if (!insertList.isEmpty()) {
            this.saveBatch(insertList, 2000);
        }
    }

    @Override
    public void deleteByGroupId(String groupId) {
        ((PermissionDataMapper)this.baseMapper).deleteByGroupId(groupId);
    }

    @Override
    public List<PermissionData> selectByGroupId(String groupId) {
        return ((PermissionDataMapper)this.baseMapper).selectByGroupId(groupId);
    }
}

