/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.third.dingding;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.api.dto.ParentEntityDTO;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.ConvertUtils;
import com.els.common.util.PasswordUtil;
import com.els.common.util.SrmRpcUtil;
import com.els.modules.base.api.service.InterfaceCustomExtendRpcService;
import com.els.modules.org.api.dto.PurchaseOrganizationInfoDTO;
import com.els.modules.org.api.service.PurchaseOrganizationInfoRpcService;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.service.ElsSubAccountService;
import com.els.modules.third.base.enums.ThirdTypeEnum;
import com.els.modules.third.dingding.util.DingDingBusinessManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@RpcService
public class GetSubAccountFromShiWeiImpl
extends DingDingBusinessManager
implements InterfaceCustomExtendRpcService {
    private static final Logger log = LoggerFactory.getLogger(GetSubAccountFromShiWeiImpl.class);
    @Autowired
    private ElsSubAccountService elsSubAccountService;
    private PurchaseOrganizationInfoRpcService purchaseOrganizationInfoService = (PurchaseOrganizationInfoRpcService)SrmRpcUtil.getExecuteServiceImpl(PurchaseOrganizationInfoRpcService.class);

    public JSONObject before(JSONObject obj, Object custom) {
        JSONObject customObj = (JSONObject)custom;
        String deptId = customObj.getString("dept_id");
        String elsAccount = customObj.getString("bus_account");
        JSONObject body = new JSONObject();
        if (StrUtil.isBlank((CharSequence)deptId)) {
            PurchaseOrganizationInfoDTO company = this.purchaseOrganizationInfoService.selectByElsAccountAndCode(elsAccount, "companyCode", "1");
            if (company == null) {
                throw new ELSBootException("\u7f3a\u5c11\u7ec4\u7ec7\u7f16\u7801\u4e3a1\u7684\u516c\u53f8\u4fe1\u606f");
            }
            customObj.put("id", (Object)company.getId());
        }
        body.put("dept_id", (Object)(StrUtil.isNotBlank((CharSequence)deptId) ? deptId : "1"));
        customObj.put("dept_id", (Object)body.getString("dept_id"));
        obj.put("body", (Object)body);
        log.info("GetSubAccountFromShiWeiImpl -> obj \u3010{}\u3011 custom \u3010{}\u3011", (Object)JSON.toJSONString((Object)obj), custom);
        return this.getSendJSON(obj, custom);
    }

    public JSONObject after(JSONObject result, JSONObject obj, Object custom) {
        List organizationInfoDTOS;
        JSONObject customObj = (JSONObject)custom;
        String id = customObj.getString("id");
        String elsAccount = customObj.getString("bus_account");
        log.info("GetSubAccountFromShiWeiImpl -> result \u3010{}\u3011", (Object)JSON.toJSONString((Object)obj));
        JSONObject resultObject = this.handlerResult(result);
        JSONObject result1 = resultObject.getJSONObject("result");
        JSONArray useridList = result1.getJSONArray("userid_list");
        if (CollUtil.isEmpty((Collection)useridList)) {
            result.put("message", (Object)"\u6682\u65e0\u7528\u6237\u6570\u636e\u9700\u8981\u540c\u6b65");
            return result;
        }
        List list = this.elsSubAccountService.list((Wrapper)new LambdaQueryWrapper().eq(BaseEntity::getElsAccount, (Object)elsAccount));
        List dbList = list.stream().filter(i -> StrUtil.isNotBlank((CharSequence)i.getSourceId())).collect(Collectors.toList());
        Map dbMap = dbList.stream().collect(Collectors.toMap(ElsSubAccount::getSourceId, Function.identity()));
        List<PurchaseOrganizationInfoDTO> purchaseOrganizationInfoList = this.getPurchaseOrganizationInfoList(customObj, elsAccount);
        Map<String, String> orgMap = purchaseOrganizationInfoList.stream().collect(Collectors.toMap(PurchaseOrganizationInfoDTO::getSourceId, ParentEntityDTO::getId));
        ArrayList<ElsSubAccount> insertList = new ArrayList<ElsSubAccount>();
        ArrayList<ElsSubAccount> updateList = new ArrayList<ElsSubAccount>();
        List allSubAccountList = list.stream().map(ElsSubAccount::getSubAccount).collect(Collectors.toList());
        for (Object userId : useridList) {
            JSONObject body = new JSONObject();
            body.put("userid", userId);
            JSONObject userInfo = this.getDataDetail(elsAccount, "getAccountDetail", body);
            if (StrUtil.isBlank((CharSequence)userInfo.getString("email"))) continue;
            ElsSubAccount subAccount = new ElsSubAccount();
            JSONArray deptIdList = userInfo.getJSONArray("dept_id_list");
            ArrayList<String> superBusinessIds = new ArrayList<String>();
            for (Object deptId : deptIdList) {
                String dbId = orgMap.get(deptId.toString());
                if (!StrUtil.isNotBlank((CharSequence)dbId)) continue;
                superBusinessIds.add(dbId);
            }
            String superBusinessId = String.join((CharSequence)",", superBusinessIds);
            if (superBusinessId.length() > 100) {
                superBusinessId = superBusinessId.substring(0, superBusinessId.substring(0, 100).lastIndexOf(","));
            }
            subAccount.setOrgCode(superBusinessId);
            subAccount.setRealname(userInfo.getString("name"));
            subAccount.setEmail(userInfo.getString("email"));
            subAccount.setPhone(userInfo.getString("mobile"));
            String managerUserid = userInfo.getString("manager_userid");
            ElsSubAccount managerSubAccount = (ElsSubAccount)((Object)dbMap.get(managerUserid));
            if (managerSubAccount != null) {
                subAccount.setSuperiorLeader(managerSubAccount.getSubAccount() + "_" + managerSubAccount.getRealname());
            } else {
                subAccount.setSuperiorLeader("");
            }
            if (dbMap.containsKey(userId.toString())) {
                ElsSubAccount elsSubAccount = (ElsSubAccount)((Object)dbMap.get(userInfo.getString("userid")));
                subAccount.setId(elsSubAccount.getId());
                subAccount.setSubAccount(null);
                updateList.add(subAccount);
                continue;
            }
            String insertId = IdWorker.getIdStr();
            subAccount.setId(insertId);
            subAccount.setElsAccount(elsAccount);
            subAccount.setSubAccount(subAccount.getEmail().split("@")[0]);
            subAccount.setWorkNo(userInfo.getString("job_number"));
            subAccount.setSourceId(userInfo.getString("userid"));
            subAccount.setSourceType("\u9489\u9489");
            subAccount.setSourceSystem(ThirdTypeEnum.DING_DING.getValue());
            subAccount.setDeleted(0);
            String salt = ConvertUtils.randomGen((int)8);
            String passwordEncode = PasswordUtil.encrypt((String)(elsAccount + "_" + subAccount.getSubAccount()), (String)"123456", (String)salt);
            subAccount.setPassword(passwordEncode);
            subAccount.setSalt(salt);
            dbMap.put(subAccount.getSourceId(), subAccount);
            insertList.add(subAccount);
        }
        if (CollUtil.isNotEmpty(updateList)) {
            this.elsSubAccountService.updateBatchById(updateList);
        }
        if (CollUtil.isNotEmpty(insertList)) {
            this.elsSubAccountService.saveBatch(insertList);
        }
        if (CollUtil.isNotEmpty(organizationInfoDTOS = purchaseOrganizationInfoList.stream().filter(i -> id.equals(i.getSuperBusinessId())).collect(Collectors.toList()))) {
            for (PurchaseOrganizationInfoDTO organizationInfoDTO : organizationInfoDTOS) {
                customObj.put("dept_id", (Object)organizationInfoDTO.getSourceId());
                customObj.put("id", (Object)organizationInfoDTO.getId());
                this.getPageInfo(obj, custom);
            }
        }
        return result;
    }

    private List<PurchaseOrganizationInfoDTO> getPurchaseOrganizationInfoList(JSONObject custom, String elsAccount) {
        if (custom.containsKey((Object)"orgList")) {
            return (List)custom.get((Object)"orgList");
        }
        List<PurchaseOrganizationInfoDTO> purchaseOrganizationInfoDTOS = this.purchaseOrganizationInfoService.listByCateCode(elsAccount, "dept");
        if (CollUtil.isEmpty(purchaseOrganizationInfoDTOS = purchaseOrganizationInfoDTOS.stream().filter(i -> StrUtil.isNotBlank((CharSequence)i.getSourceId())).collect(Collectors.toList()))) {
            throw new ELSBootException("\u7f3a\u5c11\u90e8\u95e8\u4fe1\u606f\uff0c\u8bf7\u5148\u540c\u6b65\u90e8\u95e8\u4fe1\u606f");
        }
        custom.put("orgList", purchaseOrganizationInfoDTOS);
        return purchaseOrganizationInfoDTOS;
    }
}

