/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.base.api.service.impl;

import com.els.common.api.service.InterfaceConverter;
import com.els.common.aspect.annotation.RpcService;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.math.BigDecimal;
import net.minidev.json.JSONArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RpcService(value="computeConverter")
public class ComputeConverter
implements InterfaceConverter {
    private static final Logger log = LoggerFactory.getLogger(ComputeConverter.class);

    public Object convertData(Object data, Object obj, String ... args) {
        if (args.length <= 1) {
            return this.oneComputeFunction(args[0], obj);
        }
        if (args.length <= 3) {
            return this.twoComputeFunction(obj, args);
        }
        return "";
    }

    public BigDecimal oneComputeFunction(String args, Object data) {
        String[] arrInfo = args.replaceAll("\\)", "").split("\\(");
        if (arrInfo.length <= 1) {
            Object json = JsonPath.read((Object)data, (String)arrInfo[0], (Predicate[])new Predicate[0]);
            return new BigDecimal(json.toString());
        }
        String computeCode = arrInfo[0];
        String computeValue = arrInfo[1];
        JSONArray json = (JSONArray)JsonPath.read((Object)data, (String)computeValue, (Predicate[])new Predicate[0]);
        if ("count".equals(computeCode)) {
            return new BigDecimal(json.size());
        }
        if ("sum".equals(computeCode)) {
            return this.computeSum(json);
        }
        if ("max".equals(computeCode)) {
            return this.computeMax(json);
        }
        if ("min".equals(computeCode)) {
            return this.computeMin(json);
        }
        if ("avg".equals(computeCode)) {
            return this.computeAvg(json);
        }
        return BigDecimal.ZERO;
    }

    public BigDecimal twoComputeFunction(Object data, String ... args) {
        String one = args[0];
        String two = args[1];
        String computeCode = args[2];
        BigDecimal oneBig = this.oneComputeFunction(one, data);
        BigDecimal twoBig = this.oneComputeFunction(two, data);
        if ("-".equals(computeCode)) {
            return oneBig.subtract(twoBig);
        }
        if ("+".equals(computeCode)) {
            return oneBig.add(twoBig);
        }
        if ("*".equals(computeCode)) {
            return oneBig.multiply(twoBig);
        }
        if ("/".equals(computeCode)) {
            return oneBig.divide(twoBig);
        }
        return BigDecimal.ZERO;
    }

    private BigDecimal computeSum(JSONArray json) {
        BigDecimal sum = BigDecimal.ZERO;
        for (int i = 0; i < json.size(); ++i) {
            sum = sum.add(new BigDecimal(json.get(i).toString()));
        }
        return sum;
    }

    private BigDecimal computeMax(JSONArray json) {
        BigDecimal sum = BigDecimal.ZERO;
        for (int i = 0; i < json.size(); ++i) {
            BigDecimal decimal = new BigDecimal(json.get(i).toString());
            if (sum.compareTo(decimal) != 1) continue;
            sum = decimal;
        }
        return sum;
    }

    private BigDecimal computeMin(JSONArray json) {
        BigDecimal sum = BigDecimal.ZERO;
        for (int i = 0; i < json.size(); ++i) {
            BigDecimal decimal = new BigDecimal(json.get(i).toString());
            if (sum.compareTo(decimal) != -1) continue;
            sum = decimal;
        }
        return sum;
    }

    private BigDecimal computeAvg(JSONArray json) {
        return this.computeSum(json).divide(new BigDecimal(json.size()));
    }
}

