/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.quartz.job;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.common.trace.TraceIdHolder;
import com.els.common.trace.TraceIdUtil;
import com.els.common.util.MqUtil;
import com.els.common.util.SysUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseJob
implements Job {
    private static final Logger log = LoggerFactory.getLogger(BaseJob.class);
    private String parameter;

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        String jobTraceId = TraceIdUtil.generateJobTraceId();
        TraceIdHolder.set((String)jobTraceId);
        String strjobClass = jobExecutionContext.getJobDetail().getKey().getName();
        String name = strjobClass.substring(strjobClass.lastIndexOf(".") + 1);
        StringBuilder builder = new StringBuilder("\u7cfb\u7edf\u5b9a\u65f6\u4efb\u52a1\uff1a");
        try {
            long startTime = System.currentTimeMillis();
            this.executeBusiness(this.parameter);
            long endTime = System.currentTimeMillis();
            builder.append(name).append(" \u6267\u884c\u5b9a\u65f6\u4efb\u52a1\u6210\u529f! \u8017\u65f6\uff1a").append(endTime - startTime);
        }
        catch (Exception e) {
            log.error("BaseJob run failed:", (Throwable)e);
            builder.append(name).append(" \u6267\u884c\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25\uff01\u539f\u56e0\uff1a" + this.getErrorInfoFromException(e));
            throw new JobExecutionException(e.getMessage());
        }
        finally {
            String elsAccount = SysUtil.getPurchaseAccount();
            try {
                JSONObject paramObj = JSONObject.parseObject((String)this.parameter);
                if (paramObj.containsKey((Object)"elsAccount")) {
                    elsAccount = paramObj.getString("elsAccount");
                } else if (paramObj.containsKey((Object)"tenantId")) {
                    elsAccount = paramObj.getString("tenantId");
                }
            }
            catch (Exception paramObj) {}
            JSONObject object = new JSONObject();
            object.put("elsAccount", (Object)elsAccount);
            object.put("logContent", (Object)builder.toString());
            object.put("logType", (Object)3);
            object.put("operateType", (Object)7);
            object.put("businessId", (Object)name);
            object.put("requestParam", (Object)this.parameter);
            object.put("createTime", (Object)DateUtil.formatDateTime((Date)new Date()));
            MqUtil.sendLogMsg((String)object.toJSONString());
            TraceIdHolder.remove();
        }
    }

    private String getErrorInfoFromException(Exception e) {
        StringWriter sw = new StringWriter();
        try (PrintWriter pw = new PrintWriter(sw);){
            e.printStackTrace(pw);
        }
        return sw.toString();
    }

    public abstract void executeBusiness(String var1);

    public String getParameter() {
        return this.parameter;
    }

    public void setParameter(String parameter) {
        this.parameter = parameter;
    }
}

