/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.barcode.service.impl;

import cn.hutool.core.util.StrUtil;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.barcode.entity.PurchaseBarcodeLevelHead;
import com.els.modules.barcode.entity.PurchaseBarcodeLevelItem;
import com.els.modules.barcode.entity.SaleBarcodeLevelHead;
import com.els.modules.barcode.entity.SaleBarcodeLevelItem;
import com.els.modules.barcode.enumerate.BarcodeLevelStatusEnum;
import com.els.modules.barcode.mapper.PurchaseBarcodeLevelHeadMapper;
import com.els.modules.barcode.mapper.PurchaseBarcodeLevelItemMapper;
import com.els.modules.barcode.service.PurchaseBarcodeLevelHeadService;
import com.els.modules.barcode.service.PurchaseBarcodeLevelItemService;
import com.els.modules.barcode.service.SaleBarcodeLevelHeadService;
import com.els.modules.enterprise.api.dto.ElsEnterpriseInfoDTO;
import com.els.modules.system.service.CodeGeneratorService;
import com.els.rpc.service.InvokeAccountRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PurchaseBarcodeLevelHeadServiceImpl
extends BaseServiceImpl<PurchaseBarcodeLevelHeadMapper, PurchaseBarcodeLevelHead>
implements PurchaseBarcodeLevelHeadService {
    @Autowired
    private PurchaseBarcodeLevelHeadMapper purchaseBarcodeLevelHeadMapper;
    @Autowired
    private PurchaseBarcodeLevelItemMapper purchaseBarcodeLevelItemMapper;
    @Autowired
    private PurchaseBarcodeLevelItemService purchaseBarcodeLevelItemService;
    @Autowired
    private CodeGeneratorService codeGeneratorService;
    @Autowired
    @Lazy
    private SaleBarcodeLevelHeadService saleBarcodeLevelHeadService;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseBarcodeLevelHead purchaseBarcodeLevelHead, List<PurchaseBarcodeLevelItem> purchaseBarcodeLevelItemList) {
        purchaseBarcodeLevelHead.setLevelNumber(this.codeGeneratorService.getNextCode("srmBarcodeInfoNumber", (Object)purchaseBarcodeLevelHead));
        purchaseBarcodeLevelHead.setLevelStatus(BarcodeLevelStatusEnum.NEW.getValue());
        ElsEnterpriseInfoDTO enterpriseInfo = this.invokeAccountRpcService.getByElsAccount(TenantContext.getTenant());
        if (enterpriseInfo != null) {
            purchaseBarcodeLevelHead.setPurchaseName(enterpriseInfo.getName());
        }
        this.purchaseBarcodeLevelHeadMapper.insert((Object)purchaseBarcodeLevelHead);
        this.insertData(purchaseBarcodeLevelHead, purchaseBarcodeLevelItemList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseBarcodeLevelHead purchaseBarcodeLevelHead, List<PurchaseBarcodeLevelItem> purchaseBarcodeLevelItemList) {
        int count = this.purchaseBarcodeLevelHeadMapper.updateById((Object)purchaseBarcodeLevelHead);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
        this.purchaseBarcodeLevelItemMapper.deleteByMainId(purchaseBarcodeLevelHead.getId());
        this.insertData(purchaseBarcodeLevelHead, purchaseBarcodeLevelItemList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void publish(PurchaseBarcodeLevelHead purchaseBarcodeLevelHead, List<PurchaseBarcodeLevelItem> purchaseBarcodeLevelItemList) {
        purchaseBarcodeLevelHead.setLevelStatus(BarcodeLevelStatusEnum.FINAL.getValue());
        int count = this.purchaseBarcodeLevelHeadMapper.updateById((Object)purchaseBarcodeLevelHead);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
        this.purchaseBarcodeLevelItemMapper.deleteByMainId(purchaseBarcodeLevelHead.getId());
        this.insertData(purchaseBarcodeLevelHead, purchaseBarcodeLevelItemList);
        if (StrUtil.isNotBlank((CharSequence)purchaseBarcodeLevelHead.getToElsAccount())) {
            this.saleBarcodeLevelHeadService.addByPurchase(purchaseBarcodeLevelHead, purchaseBarcodeLevelItemList);
        }
    }

    private void insertData(PurchaseBarcodeLevelHead purchaseBarcodeLevelHead, List<PurchaseBarcodeLevelItem> purchaseBarcodeLevelItemList) {
        if (purchaseBarcodeLevelItemList != null && !purchaseBarcodeLevelItemList.isEmpty()) {
            for (PurchaseBarcodeLevelItem entity : purchaseBarcodeLevelItemList) {
                entity.setHeadId(purchaseBarcodeLevelHead.getId());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchaseBarcodeLevelHead);
            }
            this.purchaseBarcodeLevelItemService.saveBatch(purchaseBarcodeLevelItemList);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.purchaseBarcodeLevelItemMapper.deleteByMainId(id);
        this.purchaseBarcodeLevelHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.purchaseBarcodeLevelItemMapper.deleteByMainId(serializable.toString());
            this.purchaseBarcodeLevelHeadMapper.deleteById(serializable);
        }
    }

    @Override
    public boolean addBySale(SaleBarcodeLevelHead saleBarcodeLevelHead, List<SaleBarcodeLevelItem> saleBarcodeLevelItemList) {
        String saleEls = saleBarcodeLevelHead.getElsAccount();
        PurchaseBarcodeLevelHead purchaseBarcodeLevelHead = new PurchaseBarcodeLevelHead();
        BeanUtils.copyProperties((Object)((Object)saleBarcodeLevelHead), (Object)((Object)purchaseBarcodeLevelHead));
        purchaseBarcodeLevelHead.setId(null);
        purchaseBarcodeLevelHead.setElsAccount(saleBarcodeLevelHead.getToElsAccount());
        purchaseBarcodeLevelHead.setToElsAccount(saleEls);
        this.purchaseBarcodeLevelHeadMapper.insert((Object)purchaseBarcodeLevelHead);
        ArrayList<PurchaseBarcodeLevelItem> purchaseBarcodeLevelItemList = new ArrayList<PurchaseBarcodeLevelItem>();
        for (SaleBarcodeLevelItem item : saleBarcodeLevelItemList) {
            PurchaseBarcodeLevelItem purchaseBarcodeLevelItem = new PurchaseBarcodeLevelItem();
            BeanUtils.copyProperties((Object)((Object)item), (Object)((Object)purchaseBarcodeLevelItem));
            purchaseBarcodeLevelItem.setElsAccount(purchaseBarcodeLevelHead.getElsAccount());
            purchaseBarcodeLevelItem.setHeadId(purchaseBarcodeLevelHead.getId());
            purchaseBarcodeLevelItem.setId(null);
            purchaseBarcodeLevelItemList.add(purchaseBarcodeLevelItem);
        }
        return this.purchaseBarcodeLevelItemService.saveBatch(purchaseBarcodeLevelItemList);
    }
}

