/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.RoleDTO;
import com.els.modules.system.entity.Role;
import com.els.modules.system.entity.RolePermission;
import com.els.modules.system.entity.UserRole;
import com.els.modules.system.mapper.RoleMapper;
import com.els.modules.system.mapper.UserRoleMapper;
import com.els.modules.system.service.RolePermissionService;
import com.els.modules.system.service.RoleService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RoleServiceImpl
extends ServiceImpl<RoleMapper, Role>
implements RoleService {
    @Autowired
    private RolePermissionService rolePermissionService;
    @Autowired
    private UserRoleMapper userRoleMapper;

    @Override
    public void copy(Role role) {
        String suorceId = role.getId();
        List rolePermissionList = this.rolePermissionService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)TenantContext.getTenant())).eq((Object)"role_id", (Object)suorceId));
        Role newRole = new Role();
        BeanUtil.copyProperties((Object)((Object)role), (Object)((Object)newRole), (String[])new String[0]);
        newRole.setId(null);
        this.save((Object)newRole);
        ArrayList<RolePermission> permissionList = new ArrayList<RolePermission>();
        for (RolePermission permission : rolePermissionList) {
            RolePermission rolePermissionNew = new RolePermission();
            rolePermissionNew.setElsAccount(TenantContext.getTenant());
            rolePermissionNew.setRoleId(newRole.getId());
            rolePermissionNew.setPermissionId(permission.getPermissionId());
            rolePermissionNew.setId(IdWorker.getIdStr());
            permissionList.add(rolePermissionNew);
        }
        if (!permissionList.isEmpty()) {
            this.rolePermissionService.insertBatch(permissionList);
        }
    }

    @Override
    public List<RoleDTO> selectWithoutElsAccountOfAllRole(List<String> accountList) {
        List<Role> roleList = ((RoleMapper)this.baseMapper).selectWithoutElsAccountOfAllRole(accountList);
        if (!roleList.isEmpty() && roleList.size() > 0) {
            return SysUtil.copyProperties(roleList, RoleDTO.class);
        }
        return Collections.emptyList();
    }

    @Override
    public Map<String, String> loadAdminRole(List<String> toElsAccountList) {
        List<Role> roleList = ((RoleMapper)this.baseMapper).selectWithoutElsAccountOfAllAdminRole(toElsAccountList);
        return roleList.stream().collect(Collectors.toMap(BaseEntity::getElsAccount, BaseEntity::getId));
    }

    @Override
    public List<String> loadUserIdByElsAccountAndRoleCode(String elsAccount, List<String> roleCodes) {
        return ((RoleMapper)this.baseMapper).loadUserIdByElsAccountAndRoleCode(elsAccount, roleCodes);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteRole(String id) {
        LambdaUpdateWrapper wrapperRolePermission = Wrappers.lambdaUpdate();
        ((LambdaUpdateWrapper)wrapperRolePermission.eq(RolePermission::getElsAccount, (Object)TenantContext.getTenant())).eq(RolePermission::getRoleId, (Object)id);
        this.rolePermissionService.remove((Wrapper)wrapperRolePermission);
        ((RoleMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    private void checkRole(String roleId) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)wrapper.eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).eq(BaseEntity::getId, (Object)roleId);
        Integer count = ((RoleMapper)this.baseMapper).selectCount((Wrapper)wrapper);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_KyxMK_d29fc6bd", (String)"\u89d2\u8272\u4e0d\u5b58\u5728"));
        }
    }

    @Override
    public void addRoleUser(String userId, String roleId) {
        this.checkRole(roleId);
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)wrapper.eq(UserRole::getRoleId, (Object)roleId)).eq(UserRole::getUserId, (Object)userId);
        Integer count = this.userRoleMapper.selectCount((Wrapper)wrapper);
        if (count > 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_rjDIjjrKy_6088fd43", (String)"\u8be5\u7528\u6237\u5df2\u62e5\u6709\u8be5\u89d2\u8272"));
        }
        UserRole userRole = new UserRole();
        userRole.setRoleId(roleId);
        userRole.setUserId(userId);
        this.userRoleMapper.insert(userRole);
    }

    @Override
    public void removeRoleUser(String userId, String roleId) {
        this.checkRole(roleId);
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        ((LambdaUpdateWrapper)wrapper.eq(UserRole::getRoleId, (Object)roleId)).eq(UserRole::getUserId, (Object)userId);
        this.userRoleMapper.delete((Wrapper)wrapper);
    }

    @Override
    public Role getRoleByElsAccountAndSysCode(String elsAccount, String code) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(BaseEntity::getElsAccount, (Object)elsAccount)).eq(Role::getRoleCode, (Object)code);
        Role role = (Role)((Object)((RoleMapper)this.baseMapper).selectOne((Wrapper)wrapper));
        return role;
    }
}

