/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ai.mapping;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson2.JSONObject;
import com.els.common.exception.ELSBootException;
import com.els.common.util.SrmRpcUtil;
import com.els.modules.ai.dto.AiDictDto;
import com.els.modules.ai.dto.AiOrderCreationFiledSchemaDto;
import com.els.modules.ai.mapping.ConditionMapping;
import com.els.modules.ai.rpc.service.SrmAiDictRpcService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DictConditionMapping
implements ConditionMapping<JSONObject> {
    private static final Logger log = LoggerFactory.getLogger(DictConditionMapping.class);

    @Override
    public String type() {
        return "dictMapping";
    }

    @Override
    public JSONObject mapping(JSONObject condition, List<AiOrderCreationFiledSchemaDto> filedSchema) {
        Map filedMap = filedSchema.stream().collect(Collectors.toMap(AiOrderCreationFiledSchemaDto::getFieldCode, Function.identity(), (v1, v2) -> v2));
        JSONObject resultObject = new JSONObject();
        for (String key : condition.keySet()) {
            AiOrderCreationFiledSchemaDto dependent;
            AiOrderCreationFiledSchemaDto schemaDTO = (AiOrderCreationFiledSchemaDto)filedMap.get(key);
            if (null == schemaDTO) {
                resultObject.put((Object)key, condition.get(key));
                continue;
            }
            if (CharSequenceUtil.isEmpty((CharSequence)schemaDTO.getFieldDictCode())) {
                resultObject.put((Object)key, condition.get(key));
                continue;
            }
            schemaDTO.setMappered(Boolean.valueOf(false));
            String filter = "";
            if (CharSequenceUtil.isNotEmpty((CharSequence)schemaDTO.getDependentFiled()) && null != (dependent = (AiOrderCreationFiledSchemaDto)filedMap.get(schemaDTO.getDependentFiled()))) {
                String dependentValue = condition.getString(schemaDTO.getDependentFiled());
                JSONObject con = new JSONObject();
                con.put((Object)dependent.getFieldCode(), (Object)dependentValue);
                dependent.setMappered(Boolean.valueOf(false));
                ArrayList temSchema = Lists.newArrayList((Object[])new AiOrderCreationFiledSchemaDto[]{dependent});
                DictConditionMapping dictConditionMapping = new DictConditionMapping();
                JSONObject jSONObject = dictConditionMapping.mapping(con, (List<AiOrderCreationFiledSchemaDto>)temSchema);
                String v = jSONObject.getString(dependent.getFieldCode());
                List list = Arrays.stream(v.split(",")).collect(Collectors.toList());
                if (CollectionUtil.isNotEmpty(list)) {
                    String sb = "('" + String.join((CharSequence)"','", list) + "')";
                    filter = String.format(schemaDTO.getDependentSqlFilter(), sb);
                }
            }
            Object o = condition.get(key);
            String value = ObjectUtil.toString((Object)o);
            List<Object> listValue = new ArrayList<String>();
            if (null != value && value.contains(",")) {
                listValue = Arrays.stream(value.split(",")).collect(Collectors.toList());
            } else {
                listValue.add(value);
            }
            HashSet<String> result = new HashSet<String>();
            for (String string : listValue) {
                AiDictDto dictDto = new AiDictDto();
                dictDto.setDictText(string);
                dictDto.setDictCode(schemaDTO.getFieldDictCode());
                dictDto.setFilterText(filter);
                String dictValue = ((SrmAiDictRpcService)SrmRpcUtil.getExecuteServiceImpl((String)"srmAiDictRpcServiceImpl", SrmAiDictRpcService.class)).queryDictValueByText(dictDto);
                if (CharSequenceUtil.isEmpty((CharSequence)string)) {
                    throw new ELSBootException(string + "\u4e0d\u5b58\u5728\u4e8e\u5b57\u5178\u4e2d\uff0c\u8bf7\u66f4\u6539\u5185\u5bb9\u540e\u518d\u64cd\u4f5c");
                }
                String associationSplit = schemaDTO.getAssociationSplit();
                String associationColumn = schemaDTO.getAssociationColumn();
                if (CharSequenceUtil.isNotEmpty((CharSequence)associationSplit) && CharSequenceUtil.isNotEmpty((CharSequence)associationColumn)) {
                    List columnList = Arrays.stream(associationColumn.split(",")).distinct().collect(Collectors.toCollection(ArrayList::new));
                    columnList.add(0, key);
                    List splitDictValue = Arrays.stream(dictValue.split(associationSplit)).collect(Collectors.toCollection(ArrayList::new));
                    if (dictValue.endsWith(associationSplit)) {
                        splitDictValue.add("");
                    }
                    if (columnList.size() != splitDictValue.size()) {
                        throw new ELSBootException("\u7528\u6237\u8f93\u5165[" + String.join((CharSequence)",", splitDictValue) + "]\u4e0d\u662f\u6709\u6548\u7684[" + schemaDTO.getFieldName() + "](\u82e5\u6a21\u578b\u914d\u7f6e\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u91cd\u65b0\u64cd\u4f5c)\uff01");
                    }
                    if (listValue.size() > 1) {
                        throw new ELSBootException("\u5217:" + schemaDTO.getFieldName() + "\uff0c:\u503c:" + String.join((CharSequence)",", listValue) + "\uff0c\u914d\u7f6e\u6709\u5b57\u5178\u5e26\u51fa\u5217\u7684\u5b57\u5178\u6570\u636e\u5339\u914d\u53ea\u5141\u8bb8\u5355\u6761\u6570\u636e\u5339\u914d\uff0c\u8bf7\u51cf\u5c11\u5339\u914d\u503c\u6761\u4ef6\u518d\u64cd\u4f5c\uff01");
                    }
                    result.add((String)splitDictValue.get(0));
                    for (int index = columnList.size() - 1; index > 0; --index) {
                        resultObject.put((Object)((String)columnList.get(index)), splitDictValue.get(index));
                    }
                    continue;
                }
                result.add(dictValue);
            }
            String lastValue = String.join((CharSequence)",", result);
            resultObject.put((Object)key, (Object)lastValue);
            schemaDTO.setMappered(Boolean.valueOf(true));
        }
        return resultObject;
    }
}

