/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.barcode.service.impl;

import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.SysUtil;
import com.els.modules.barcode.entity.ElsBarcodeTemplateHead;
import com.els.modules.barcode.entity.ElsBarcodeTemplateItem;
import com.els.modules.barcode.mapper.ElsBarcodeTemplateHeadMapper;
import com.els.modules.barcode.mapper.ElsBarcodeTemplateItemMapper;
import com.els.modules.barcode.service.ElsBarcodeTemplateHeadService;
import com.els.modules.barcode.service.ElsBarcodeTemplateItemService;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ElsBarcodeTemplateHeadServiceImpl
extends BaseServiceImpl<ElsBarcodeTemplateHeadMapper, ElsBarcodeTemplateHead>
implements ElsBarcodeTemplateHeadService {
    @Autowired
    private ElsBarcodeTemplateHeadMapper elsBarcodeTemplateHeadMapper;
    @Autowired
    private ElsBarcodeTemplateItemMapper elsBarcodeTemplateItemMapper;
    @Resource
    private ElsBarcodeTemplateItemService elsBarcodeTemplateItemService;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(ElsBarcodeTemplateHead elsBarcodeTemplateHead, List<ElsBarcodeTemplateItem> elsBarcodeTemplateItemList) {
        this.elsBarcodeTemplateHeadMapper.insert((Object)elsBarcodeTemplateHead);
        this.insertData(elsBarcodeTemplateHead, elsBarcodeTemplateItemList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(ElsBarcodeTemplateHead elsBarcodeTemplateHead, List<ElsBarcodeTemplateItem> elsBarcodeTemplateItemList) {
        this.elsBarcodeTemplateHeadMapper.updateById((Object)elsBarcodeTemplateHead);
        this.elsBarcodeTemplateItemMapper.deleteByMainId(elsBarcodeTemplateHead.getId());
        this.insertData(elsBarcodeTemplateHead, elsBarcodeTemplateItemList);
    }

    private void insertData(ElsBarcodeTemplateHead elsBarcodeTemplateHead, List<ElsBarcodeTemplateItem> elsBarcodeTemplateItemList) {
        if (elsBarcodeTemplateItemList != null && !elsBarcodeTemplateItemList.isEmpty()) {
            for (ElsBarcodeTemplateItem entity : elsBarcodeTemplateItemList) {
                entity.setHeadId(elsBarcodeTemplateHead.getId());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)elsBarcodeTemplateHead);
            }
            this.elsBarcodeTemplateItemService.saveBatch(elsBarcodeTemplateItemList);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.elsBarcodeTemplateItemMapper.deleteByMainId(id);
        this.elsBarcodeTemplateHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.elsBarcodeTemplateItemMapper.deleteByMainId(serializable.toString());
            this.elsBarcodeTemplateHeadMapper.deleteById(serializable);
        }
    }
}

