/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.language.excel;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.excel.service.BaseExportService;
import com.els.common.system.base.entity.BaseEntity;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.service.ExportDataLoaderService;
import com.els.modules.language.entity.I18n;
import com.els.modules.language.mapper.I18nMapper;
import com.els.modules.language.vo.I18nVO;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;

@RpcService(value="i18nExportExcelDataBatchQueryLoader")
public class I18nExportServiceImpl
extends BaseExportService<I18n, I18nVO, I18nVO>
implements ExportDataLoaderService {
    @Autowired
    private I18nMapper baseMapper;

    public List<I18nVO> queryExportData(QueryWrapper<I18n> queryWrapper, I18nVO i18n, Map<String, String[]> paramMap) {
        List chineseList = new ArrayList();
        i18n.setElsAccount(TenantContext.getTenant());
        i18n.setFromIndex(0);
        queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        if (StrUtil.isBlank((CharSequence)i18n.getChinese())) {
            objectPage = new Page();
            objectPage.setCurrent(1L);
            objectPage.setSize(100L);
            i18nIPage = this.baseMapper.selectPageList((Page<I18n>)objectPage, queryWrapper, TenantContext.getTenant());
            chineseList = i18nIPage.getRecords();
        } else {
            objectPage = new Page();
            objectPage.setCurrent(1L);
            objectPage.setSize(100L);
            queryWrapper.lambda().eq(I18n::getLanguage, (Object)"zh");
            queryWrapper.lambda().eq(I18n::getI18nValue, (Object)i18n.getChinese());
            i18nIPage = this.baseMapper.selectPageList((Page<I18n>)objectPage, queryWrapper, TenantContext.getTenant());
            chineseList = i18nIPage.getRecords();
        }
        List<String> i18nKeyList = chineseList.stream().map(I18n::getI18nKey).distinct().collect(Collectors.toList());
        ArrayList<I18nVO> list = new ArrayList<I18nVO>(chineseList.size());
        if (CollUtil.isNotEmpty(i18nKeyList)) {
            List<I18n> englishList = this.baseMapper.findPageEnglish(i18nKeyList, i18n.getElsAccount());
            Map<String, String> englishMap = englishList.stream().collect(Collectors.toMap(I18n::getI18nKey, I18n::getI18nValue));
            List<I18n> chtList = this.baseMapper.findPageCht(i18nKeyList, i18n.getElsAccount());
            Map<String, String> chtMap = chtList.stream().collect(Collectors.toMap(I18n::getI18nKey, I18n::getI18nValue));
            List<I18n> fraList = this.baseMapper.findPageFra(i18nKeyList, i18n.getElsAccount());
            Map<String, String> fraMap = fraList.stream().collect(Collectors.toMap(I18n::getI18nKey, I18n::getI18nValue));
            List<I18n> vieList = this.baseMapper.findPageVie(i18nKeyList, i18n.getElsAccount());
            Map<String, String> vieMap = vieList.stream().collect(Collectors.toMap(I18n::getI18nKey, I18n::getI18nValue));
            List<I18n> germanList = this.baseMapper.findPageGerman(i18nKeyList, i18n.getElsAccount());
            Map<String, String> germanMap = germanList.stream().collect(Collectors.toMap(I18n::getI18nKey, I18n::getI18nValue));
            for (I18n n : chineseList) {
                I18nVO vo = new I18nVO();
                vo.setChinese(n.getI18nValue());
                vo.setI18nKey(n.getI18nKey());
                if (englishMap.containsKey(n.getI18nKey())) {
                    vo.setEnglish(englishMap.get(n.getI18nKey()));
                }
                if (fraMap.containsKey(n.getI18nKey())) {
                    vo.setFrench(fraMap.get(n.getI18nKey()));
                }
                if (chtMap.containsKey(n.getI18nKey())) {
                    vo.setTraditionalChinese(chtMap.get(n.getI18nKey()));
                }
                if (vieMap.containsKey(n.getI18nKey())) {
                    vo.setVietnamese(vieMap.get(n.getI18nKey()));
                }
                if (germanMap.containsKey(n.getI18nKey())) {
                    vo.setGerman(germanMap.get(n.getI18nKey()));
                }
                list.add(vo);
            }
            return list;
        }
        return Lists.newArrayList();
    }

    public long queryExportDataCount(QueryWrapper<I18n> queryWrapper, I18nVO i18n, Map<String, String[]> paramMap) {
        i18n.setElsAccount(TenantContext.getTenant());
        queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        if (StrUtil.isBlank((CharSequence)i18n.getChinese())) {
            Page objectPage = new Page();
            objectPage.setCurrent(1L);
            objectPage.setSize(Integer.MAX_VALUE);
            IPage<I18n> i18nIPage = this.baseMapper.selectPageList((Page<I18n>)objectPage, queryWrapper, TenantContext.getTenant());
            return i18nIPage.getTotal();
        }
        Page objectPage = new Page();
        objectPage.setCurrent(1L);
        objectPage.setSize(Integer.MAX_VALUE);
        if (!StrUtil.isBlank((CharSequence)i18n.getChinese())) {
            queryWrapper.lambda().eq(I18n::getLanguage, (Object)"zh");
            queryWrapper.lambda().like(I18n::getI18nValue, (Object)i18n.getChinese());
        } else if (!StrUtil.isBlank((CharSequence)i18n.getI18nKey())) {
            queryWrapper.lambda().eq(I18n::getI18nValue, (Object)i18n.getI18nKey());
        }
        IPage<I18n> i18nIPage = this.baseMapper.selectPageList((Page<I18n>)objectPage, queryWrapper, TenantContext.getTenant());
        return i18nIPage.getTotal();
    }

    public String getBusinessType() {
        return "I18n";
    }

    public String getBeanName() {
        return "i18nExportExcelDataBatchQueryLoader";
    }

    protected boolean doQueryWrapperFiler() {
        return false;
    }

    public String loadData(Integer pageNumber, Integer pageSize, Map<String, Object> entityMap, Map<String, String[]> requestParamMap) {
        List chineseList;
        I18nVO i18n = (I18nVO)JSON.parseObject((String)JSON.toJSONString(entityMap), I18nVO.class);
        i18n.setElsAccount(TenantContext.getTenant());
        i18n.setFromIndex(pageNumber - 1);
        i18n.setPageSize(pageSize);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        Page objectPage = new Page();
        objectPage.setCurrent((long)pageNumber.intValue());
        objectPage.setSize((long)pageSize.intValue());
        if (StrUtil.isBlank((CharSequence)i18n.getChinese())) {
            i18nIPage = this.baseMapper.selectPageList((Page<I18n>)objectPage, (QueryWrapper<I18n>)queryWrapper, TenantContext.getTenant());
            chineseList = i18nIPage.getRecords();
        } else {
            if (!StrUtil.isBlank((CharSequence)i18n.getChinese())) {
                queryWrapper.lambda().eq(I18n::getLanguage, (Object)"zh");
                queryWrapper.lambda().like(I18n::getI18nValue, (Object)i18n.getChinese());
            } else if (!StrUtil.isBlank((CharSequence)i18n.getI18nKey())) {
                queryWrapper.lambda().eq(I18n::getI18nValue, (Object)i18n.getI18nKey());
            }
            i18nIPage = this.baseMapper.selectPageList((Page<I18n>)objectPage, (QueryWrapper<I18n>)queryWrapper, TenantContext.getTenant());
            chineseList = i18nIPage.getRecords();
        }
        List<String> i18nKeyList = chineseList.stream().map(I18n::getI18nKey).distinct().collect(Collectors.toList());
        ArrayList<I18nVO> list = new ArrayList<I18nVO>(chineseList.size());
        if (CollUtil.isNotEmpty(i18nKeyList)) {
            List<I18n> englishList = this.baseMapper.findPageEnglish(i18nKeyList, i18n.getElsAccount());
            Map<String, String> englishMap = englishList.stream().collect(Collectors.toMap(I18n::getI18nKey, I18n::getI18nValue));
            List<I18n> chtList = this.baseMapper.findPageCht(i18nKeyList, i18n.getElsAccount());
            Map<String, String> chtMap = chtList.stream().collect(Collectors.toMap(I18n::getI18nKey, I18n::getI18nValue));
            List<I18n> fraList = this.baseMapper.findPageFra(i18nKeyList, i18n.getElsAccount());
            Map<String, String> fraMap = fraList.stream().collect(Collectors.toMap(I18n::getI18nKey, I18n::getI18nValue));
            List<I18n> vieList = this.baseMapper.findPageVie(i18nKeyList, i18n.getElsAccount());
            Map<String, String> vieMap = vieList.stream().collect(Collectors.toMap(I18n::getI18nKey, I18n::getI18nValue));
            List<I18n> germanList = this.baseMapper.findPageGerman(i18nKeyList, i18n.getElsAccount());
            Map<String, String> germanMap = germanList.stream().collect(Collectors.toMap(I18n::getI18nKey, I18n::getI18nValue));
            for (I18n n : chineseList) {
                I18nVO vo = new I18nVO();
                vo.setChinese(n.getI18nValue());
                vo.setI18nKey(n.getI18nKey());
                if (englishMap.containsKey(n.getI18nKey())) {
                    vo.setEnglish(englishMap.get(n.getI18nKey()));
                }
                if (fraMap.containsKey(n.getI18nKey())) {
                    vo.setFrench(fraMap.get(n.getI18nKey()));
                }
                if (chtMap.containsKey(n.getI18nKey())) {
                    vo.setTraditionalChinese(chtMap.get(n.getI18nKey()));
                }
                if (vieMap.containsKey(n.getI18nKey())) {
                    vo.setVietnamese(vieMap.get(n.getI18nKey()));
                }
                if (germanMap.containsKey(n.getI18nKey())) {
                    vo.setGerman(germanMap.get(n.getI18nKey()));
                }
                list.add(vo);
            }
            return JSON.toJSONString(list);
        }
        return "[]";
    }
}

