/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.linereport.util;

import cn.hutool.core.util.StrUtil;
import com.alibaba.excel.metadata.CellData;
import com.alibaba.excel.metadata.Head;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import com.alibaba.excel.write.metadata.holder.WriteTableHolder;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.springframework.util.ObjectUtils;

public class QuoteTemplateStyleWriteHandler
extends LongestMatchColumnWidthStyleStrategy {
    private List<Integer> columnIndexList = new ArrayList<Integer>();
    private List<String> allowEditCodeList = new ArrayList<String>(){
        private static final long serialVersionUID = -3259644886608449146L;
        {
            this.add("intervalRatioPrice1");
            this.add("intervalRatioPrice2");
            this.add("intervalRatioPrice3");
            this.add("intervalRatioPrice4");
            this.add("toDoorTonsPrice");
            this.add("toDoorTonsDate");
            this.add("toStationPrice");
            this.add("toSta");
            this.add("toDoorPrice");
            this.add("toDoorDate");
        }
    };
    private Map<Integer, Integer> columnIndexMaxLength = new HashMap<Integer, Integer>();
    private Map cellStyleMap = new HashMap();

    public void afterCellCreate(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, Cell cell, Head head, Integer relativeRowIndex, Boolean isHead) {
    }

    private void contentStyle(Cell cell) {
        if (this.columnIndexList.contains(cell.getColumnIndex())) {
            if (!this.cellStyleMap.containsKey(cell.getColumnIndex())) {
                CellStyle cellStyle = cell.getSheet().getWorkbook().createCellStyle();
                cellStyle.setLocked(false);
                cell.setCellStyle(cellStyle);
                this.cellStyleMap.put(cell.getColumnIndex(), cellStyle);
            } else {
                cell.setCellStyle((CellStyle)this.cellStyleMap.get(cell.getColumnIndex()));
            }
        }
        try {
            if (!StrUtil.isBlank((CharSequence)cell.getStringCellValue())) {
                Integer maxLength = this.columnIndexMaxLength.get(cell.getColumnIndex());
                int currentLength = cell.getStringCellValue().getBytes(StandardCharsets.UTF_16BE).length;
                if (ObjectUtils.isEmpty((Object)maxLength)) {
                    this.columnIndexMaxLength.put(cell.getColumnIndex(), currentLength);
                } else if (maxLength < currentLength) {
                    this.columnIndexMaxLength.put(cell.getColumnIndex(), currentLength);
                }
                cell.getSheet().setColumnWidth(cell.getColumnIndex(), this.columnIndexMaxLength.get(cell.getColumnIndex()) * 250);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void headerStyle(Cell cell) {
        if (!StrUtil.isBlank((CharSequence)cell.getStringCellValue()) && this.allowEditCodeList.contains(cell.getStringCellValue()) && !this.columnIndexList.contains(cell.getColumnIndex())) {
            this.columnIndexList.add(cell.getColumnIndex());
        }
        if (!StrUtil.isBlank((CharSequence)cell.getStringCellValue())) {
            Integer maxLength = this.columnIndexMaxLength.get(cell.getColumnIndex());
            int currentLength = cell.getStringCellValue().getBytes(StandardCharsets.UTF_16BE).length;
            if (ObjectUtils.isEmpty((Object)maxLength)) {
                this.columnIndexMaxLength.put(cell.getColumnIndex(), currentLength);
            } else if (maxLength < currentLength) {
                this.columnIndexMaxLength.put(cell.getColumnIndex(), currentLength);
            }
            cell.getSheet().setColumnWidth(cell.getColumnIndex(), this.columnIndexMaxLength.get(cell.getColumnIndex()) * 250);
        }
    }

    public void afterCellDispose(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, List<CellData> cellDataList, Cell cell, Head head, Integer relativeRowIndex, Boolean isHead) {
        super.afterCellDispose(writeSheetHolder, writeTableHolder, cellDataList, cell, head, relativeRowIndex, isHead);
        if (isHead.booleanValue()) {
            this.headerStyle(cell);
        } else {
            this.contentStyle(cell);
        }
    }
}

