/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.survey.adapter;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.aspect.param.DictTranslateAspectParam;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.service.DictTranslateService;
import com.els.common.system.vo.MsgParamsVO;
import com.els.common.util.MqUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.survey.entity.PurchaseSurveyAnswer;
import com.els.modules.survey.entity.PurchaseSurveyHead;
import com.els.modules.survey.entity.PurchaseSurveyItem;
import com.els.modules.survey.entity.PurchaseSurveyLibrary;
import com.els.modules.survey.service.PurchaseSurveyAnswerService;
import com.els.modules.survey.service.PurchaseSurveyHeadService;
import com.els.modules.survey.service.PurchaseSurveyItemService;
import com.els.modules.survey.service.PurchaseSurveyLibraryService;
import com.els.modules.survey.vo.PurchaseSurveyHeadVO;
import com.els.modules.workflow.dto.AuditInputParamDTO;
import com.els.modules.workflow.dto.AuditOutputParamDTO;
import com.els.modules.workflow.enums.WorkFlowType;
import com.els.modules.workflow.rpc.service.AuditOptCallBackService;
import com.els.rpc.service.InvokeAccountRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@RpcService(value="publishSurveyAuditAdapter")
public class PublishSurveyAdapter
implements AuditOptCallBackService {
    @Autowired
    private PurchaseSurveyHeadService purchaseSurveyHeadService;
    @Autowired
    private PurchaseSurveyItemService purchaseSurveyItemService;
    @Autowired
    private PurchaseSurveyLibraryService purchaseSurveyLibraryService;
    @Autowired
    private PurchaseSurveyAnswerService purchaseSurveyAnswerService;
    @Autowired
    private InvokeAccountRpcService invokeAccountRpcService;

    public void startCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        String param = StrUtil.isBlank((CharSequence)inputParamVO.getParams()) ? "{}" : inputParamVO.getParams();
        PurchaseSurveyHeadVO headVO = (PurchaseSurveyHeadVO)((Object)JSONObject.parseObject((String)param, PurchaseSurveyHeadVO.class));
        this.purchaseSurveyHeadService.updateMain(headVO, new ArrayList<PurchaseSurveyLibrary>(), new ArrayList<PurchaseSurveyItem>(), headVO.getPurchaseSurveyAnswerList());
        this.updateAuditStatus(inputParamVO, outputParamVO);
        Object operataion = "submitAudit";
        if (WorkFlowType.BPMN.getValue().equals(outputParamVO.getBpmnType())) {
            operataion = outputParamVO.getBpmnType() + "_submitAudit";
        }
        this.sendMsg(inputParamVO, outputParamVO, (String)operataion);
    }

    public void completeCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateAuditStatus(inputParamVO, outputParamVO);
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus())) {
            this.sendMsg(inputParamVO, outputParamVO, "auditPass");
        } else {
            Object operataion = "submitAudit";
            if (WorkFlowType.BPMN.getValue().equals(outputParamVO.getBpmnType())) {
                operataion = outputParamVO.getBpmnType() + "_submitAudit";
            }
            this.sendMsg(inputParamVO, outputParamVO, (String)operataion);
        }
    }

    public void rejectCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateAuditStatus(inputParamVO, outputParamVO);
        this.sendMsg(inputParamVO, outputParamVO, "auditReject");
    }

    public void cancelCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateAuditStatus(inputParamVO, outputParamVO);
    }

    public JSONObject getDataById(String id) {
        PurchaseSurveyHead head = (PurchaseSurveyHead)((Object)this.purchaseSurveyHeadService.getById((Serializable)((Object)id)));
        if (head != null) {
            Result result = Result.ok((Object)((Object)head));
            JSONObject jsonObject = ((DictTranslateService)SpringContextUtils.getBean(DictTranslateService.class)).parseJson((Object)head, new DictTranslateAspectParam());
            return jsonObject;
        }
        return null;
    }

    private void updateAuditStatus(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus())) {
            PurchaseSurveyHeadVO headVO = new PurchaseSurveyHeadVO();
            String id = inputParamVO.getBusinessId();
            PurchaseSurveyHead dbHead = (PurchaseSurveyHead)((Object)this.purchaseSurveyHeadService.getById((Serializable)((Object)id)));
            BeanUtils.copyProperties((Object)((Object)dbHead), (Object)((Object)headVO));
            List<PurchaseSurveyItem> itemList = this.purchaseSurveyItemService.selectByMainId(id);
            List<PurchaseSurveyLibrary> libraryList = this.purchaseSurveyLibraryService.selectByMainId(id);
            List<PurchaseSurveyAnswer> answerList = this.purchaseSurveyAnswerService.selectByMainId(id);
            this.purchaseSurveyHeadService.publish(headVO, libraryList, answerList);
        }
        PurchaseSurveyHeadVO updateHead = new PurchaseSurveyHeadVO();
        updateHead.setId(inputParamVO.getBusinessId());
        updateHead.setFlowId(outputParamVO.getProcessRootId());
        updateHead.setAuditStatus(outputParamVO.getAuditStatus());
        this.purchaseSurveyHeadService.updateById((Object)updateHead);
    }

    private void sendMsg(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO, String optType) {
        String elsAccount = TenantContext.getTenant();
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus()) || AuditStatusEnum.AUDIT_REJECT.getValue().equals(outputParamVO.getAuditStatus())) {
            MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, outputParamVO.getSubmitUser());
            MqUtil.sendBusMsg((String)elsAccount, (String)"survey", (String)optType, (MsgParamsVO)msgParamsVO);
        } else {
            List accountList = outputParamVO.getNextAuditUserList();
            for (String account : accountList) {
                MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, account);
                MqUtil.sendBusMsg((String)elsAccount, (String)"survey", (String)optType, (MsgParamsVO)msgParamsVO);
            }
        }
    }

    private MsgParamsVO parameterAssemble(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO, String account) {
        MsgParamsVO msgParamsVO = new MsgParamsVO();
        ArrayList<ElsSubAccountDTO> accountList = new ArrayList<ElsSubAccountDTO>();
        HashMap<String, ArrayList<ElsSubAccountDTO>> receiverMap = new HashMap<String, ArrayList<ElsSubAccountDTO>>();
        ElsSubAccountDTO subAccount = this.invokeAccountRpcService.getAccount(TenantContext.getTenant(), account.split("_")[1]);
        accountList.add(subAccount);
        receiverMap.put(TenantContext.getTenant(), accountList);
        String businessType = inputParamVO.getBusinessType();
        String flowId = outputParamVO.getProcessRootId();
        String headId = inputParamVO.getBusinessId();
        String outAuditPassUrl = SysUtil.getOutAuditPassUrl((ElsSubAccountDTO)subAccount, (String)flowId, (String)businessType, (String)headId);
        String outAuditRejectUrl = SysUtil.getOutAuditRejectUrl((ElsSubAccountDTO)subAccount, (String)flowId, (String)businessType, (String)headId);
        PurchaseSurveyHead head = (PurchaseSurveyHead)((Object)this.purchaseSurveyHeadService.getById((Serializable)((Object)headId)));
        PurchaseSurveyHeadVO headVO = new PurchaseSurveyHeadVO();
        BeanUtils.copyProperties((Object)((Object)head), (Object)((Object)headVO));
        JSONObject jsonObject = ((DictTranslateService)SpringContextUtils.getBean(DictTranslateService.class)).parseJson((Object)headVO, new DictTranslateAspectParam());
        Map paramMap = (Map)JSON.parse((String)jsonObject.toString());
        paramMap.put("userName", subAccount.getRealname());
        paramMap.put("outAuditPassUrl", outAuditPassUrl);
        paramMap.put("outAuditRejectUrl", outAuditRejectUrl);
        msgParamsVO.setParams((Object)paramMap);
        HashMap<String, JSONObject> receiveParamMap = new HashMap<String, JSONObject>();
        JSONObject paramObj = new JSONObject();
        paramObj.put("businessId", (Object)inputParamVO.getBusinessId());
        paramObj.put("businessType", (Object)inputParamVO.getBusinessType());
        if (account.split("_").length > 2) {
            paramObj.put("taskId", (Object)account.split("_")[2]);
        }
        if (account.split("_").length > 3) {
            paramObj.put("processInstanceId", (Object)account.split("_")[3]);
        }
        receiveParamMap.put(TenantContext.getTenant(), paramObj);
        msgParamsVO.setReceiveParamMap(receiveParamMap);
        return msgParamsVO;
    }
}

