/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.excel;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.excel.service.BaseExportService;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.service.ExportDataLoaderService;
import com.els.modules.system.entity.Dict;
import com.els.modules.system.mapper.DictMapper;
import com.els.modules.system.vo.DictExportModelVo;
import com.els.modules.system.vo.DictExportVo;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;

@RpcService(value="dictItemExportExcelDataBatchQueryLoader")
public class DictItemExportServiceImpl
extends BaseExportService<Dict, DictExportModelVo, Dict>
implements ExportDataLoaderService {
    @Autowired
    private DictMapper dictMapper;

    public List<DictExportModelVo> queryExportData(QueryWrapper<Dict> queryWrapper, Dict map, Map<String, String[]> paramMap) {
        List<DictExportVo> list = this.dictMapper.exportList(queryWrapper, TenantContext.getTenant());
        return list.stream().map(x -> {
            DictExportModelVo vo = (DictExportModelVo)Convert.convert(DictExportModelVo.class, (Object)x);
            vo.setDictSourceType(x.getSourceType());
            vo.setDictSourceId(x.getSourceId());
            vo.setDictSourceSystem(x.getSourceSystem());
            vo.setDictDescription(x.getDescription());
            vo.setDescription(x.getItemDescription());
            return vo;
        }).collect(Collectors.toList());
    }

    public long queryExportDataCount(QueryWrapper<Dict> queryWrapper, Dict map, Map<String, String[]> paramMap) {
        return this.dictMapper.exportListCount(queryWrapper, TenantContext.getTenant());
    }

    public String getBusinessType() {
        return "DictItem";
    }

    public String getBeanName() {
        return "dictItemExportExcelDataBatchQueryLoader";
    }

    public String loadData(Integer pageNumber, Integer pageSize, Map<String, Object> entityMap, Map<String, String[]> requestParamMap) {
        Page page = new Page((long)pageNumber.intValue(), (long)pageSize.intValue());
        QueryWrapper queryWrapper = this.builderWrapper(entityMap, requestParamMap);
        List list = this.dictMapper.exportPage((Page<DictExportVo>)page, (QueryWrapper<Dict>)queryWrapper, TenantContext.getTenant()).getRecords();
        return JSON.toJSONString(list.stream().map(x -> {
            DictExportModelVo vo = (DictExportModelVo)Convert.convert(DictExportModelVo.class, (Object)x);
            vo.setDictSourceType(x.getSourceType());
            vo.setDictSourceId(x.getSourceId());
            vo.setDictSourceSystem(x.getSourceSystem());
            vo.setDictDescription(x.getDescription());
            vo.setDescription(x.getItemDescription());
            return vo;
        }).collect(Collectors.toList()));
    }
}

