/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ai.mapping;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson2.JSONObject;
import com.els.common.exception.ELSBootException;
import com.els.common.util.SrmRpcUtil;
import com.els.modules.ai.dto.AiDictDto;
import com.els.modules.ai.dto.AiOrderCreationFiledSchemaDto;
import com.els.modules.ai.mapping.ConditionMapping;
import com.els.modules.ai.service.SrmAiDictRpcService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DictConditionMapping
implements ConditionMapping<JSONObject> {
    private static final Logger log = LoggerFactory.getLogger(DictConditionMapping.class);

    @Override
    public String type() {
        return "dictMapping";
    }

    @Override
    public JSONObject mapping(JSONObject condition, List<AiOrderCreationFiledSchemaDto> filedSchema) {
        Map filedMap = filedSchema.stream().collect(Collectors.toMap(AiOrderCreationFiledSchemaDto::getFieldCode, Function.identity(), (v1, v2) -> v2));
        JSONObject resultObject = new JSONObject();
        for (String key : condition.keySet()) {
            AiOrderCreationFiledSchemaDto schemaDTO = (AiOrderCreationFiledSchemaDto)filedMap.get(key);
            if (null == schemaDTO) {
                resultObject.put((Object)key, condition.get(key));
                continue;
            }
            if (CharSequenceUtil.isEmpty((CharSequence)schemaDTO.getFieldDictCode())) {
                resultObject.put((Object)key, condition.get(key));
                continue;
            }
            schemaDTO.setMappered(Boolean.valueOf(false));
            JSONObject filterParamObj = new JSONObject();
            if (CharSequenceUtil.isNotEmpty((CharSequence)schemaDTO.getDependentFiled())) {
                String[] dependentFiledArray = schemaDTO.getDependentFiled().split(",");
                for (int i = 0; i < dependentFiledArray.length; ++i) {
                    String[] dependentFiledSplit = dependentFiledArray[i].split("#");
                    if (dependentFiledSplit.length != 2) {
                        throw new ELSBootException(schemaDTO.getFieldName() + "\u6a21\u578b\u5217\u914d\u7f6e\u683c\u5f0f\u6709\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e");
                    }
                    String dependentFiled = dependentFiledSplit[0];
                    String dependentFiledCondition = dependentFiledSplit[1];
                    AiOrderCreationFiledSchemaDto dependent = (AiOrderCreationFiledSchemaDto)filedMap.get(dependentFiled);
                    if (null == dependent) continue;
                    String dependentValue = condition.getString(schemaDTO.getDependentFiled());
                    JSONObject con = new JSONObject();
                    con.put((Object)dependent.getFieldCode(), (Object)dependentValue);
                    dependent.setMappered(Boolean.valueOf(false));
                    ArrayList temSchema = Lists.newArrayList((Object[])new AiOrderCreationFiledSchemaDto[]{dependent});
                    DictConditionMapping dictConditionMapping = new DictConditionMapping();
                    JSONObject mappingValue = dictConditionMapping.mapping(con, (List<AiOrderCreationFiledSchemaDto>)temSchema);
                    String v = mappingValue.getString(dependent.getFieldCode());
                    List list = Arrays.stream(v.split(",")).collect(Collectors.toList());
                    if (!CollectionUtil.isNotEmpty(list)) continue;
                    filterParamObj.put((Object)dependentFiledCondition, list);
                }
            }
            Object o = condition.get(key);
            String value = ObjectUtil.toString((Object)o);
            List<String> listValue = new ArrayList<String>();
            if (null != value && value.contains(",")) {
                listValue = Arrays.stream(value.split(",")).collect(Collectors.toList());
            } else {
                listValue.add(value);
            }
            TreeSet<String> result = new TreeSet<String>();
            for (String text : listValue) {
                AiDictDto dictDto = new AiDictDto();
                dictDto.setDictText(text);
                dictDto.setDictCode(schemaDTO.getFieldDictCode());
                dictDto.setFilterParamObj(filterParamObj);
                dictDto.setModelFileDictType(schemaDTO.getModelFileDictType());
                String associationSplit = schemaDTO.getAssociationSplit();
                String associationColumn = schemaDTO.getAssociationColumn();
                dictDto.setAssociationSplit(associationSplit);
                dictDto.setAssociationColumn(associationColumn);
                dictDto.setBringValue(schemaDTO.getBringValue());
                dictDto.setDictFuzzySegmentation(schemaDTO.getDictFuzzySegmentation());
                dictDto.setFiledGroup(schemaDTO.getFiledGroup());
                String dictValue = ((SrmAiDictRpcService)SrmRpcUtil.getExecuteServiceImpl((String)"srmAiDictRpcServiceImpl", SrmAiDictRpcService.class)).queryDictValueByText(dictDto);
                if (CharSequenceUtil.isEmpty((CharSequence)text)) {
                    throw new ELSBootException(text + "\u4e0d\u5b58\u5728\u4e8e\u5b57\u5178\u4e2d\uff0c\u8bf7\u66f4\u6539\u5185\u5bb9\u540e\u518d\u64cd\u4f5c");
                }
                if (CharSequenceUtil.isNotEmpty((CharSequence)associationSplit) && CharSequenceUtil.isNotEmpty((CharSequence)associationColumn)) {
                    List columnList = Arrays.stream(associationColumn.split(",")).distinct().collect(Collectors.toCollection(ArrayList::new));
                    columnList.add(0, key);
                    List splitDictValue = Arrays.stream(dictValue.split(associationSplit)).collect(Collectors.toCollection(ArrayList::new));
                    if (dictValue.endsWith(associationSplit)) {
                        splitDictValue.add("");
                    }
                    if (columnList.size() != splitDictValue.size()) {
                        throw new ELSBootException("\u7528\u6237\u8f93\u5165[" + String.join((CharSequence)",", splitDictValue) + "]\u4e0d\u662f\u6709\u6548\u7684[" + schemaDTO.getFieldName() + "](\u82e5\u6a21\u578b\u914d\u7f6e\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u91cd\u65b0\u64cd\u4f5c)\uff01");
                    }
                    result.add((String)splitDictValue.get(0));
                    for (int index = columnList.size() - 1; index > 0; --index) {
                        Object oldValue = resultObject.getString((String)columnList.get(index));
                        oldValue = CharSequenceUtil.isNotEmpty((CharSequence)oldValue) ? (String)oldValue + "," + (String)splitDictValue.get(index) : (String)splitDictValue.get(index);
                        resultObject.put((Object)((String)columnList.get(index)), oldValue);
                    }
                    continue;
                }
                result.add(dictValue);
            }
            String lastValue = String.join((CharSequence)",", result);
            resultObject.put((Object)key, (Object)lastValue);
            schemaDTO.setMappered(Boolean.valueOf(true));
        }
        return resultObject;
    }
}

