/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.third.xc;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.common.aspect.annotation.RpcService;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.service.InterfaceCustomExtendRpcService;
import com.els.modules.system.entity.DictItem;
import com.els.modules.system.service.DictService;
import com.els.modules.third.base.enums.ThirdTypeEnum;
import com.els.modules.third.jdyxc.enums.DictCodeEnum;
import com.els.modules.third.jdyxc.service.XcSysBusinessManager;
import com.els.modules.third.jdyxc.util.BeanConvertorUtil;
import com.els.modules.third.jdyxc.util.XcUtil;
import com.els.modules.third.xc.vo.CurrencyVO;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@RpcService
public class GetCurrencyFromXcDbImpl
extends XcSysBusinessManager
implements InterfaceCustomExtendRpcService {
    private static final Logger log = LoggerFactory.getLogger(GetCurrencyFromXcDbImpl.class);
    private static final String CURRENCY_LIST = "/jdy/v2/bd/currency";
    @Autowired
    private DictService dictService;

    public JSONObject before(JSONObject obj, Object custom) {
        return this.getSendJSON(obj, custom, CURRENCY_LIST);
    }

    public JSONObject after(JSONObject obj, JSONObject paramObj, Object custom) {
        JSONObject result = (JSONObject)custom;
        String elsAccount = result.getString("bus_account");
        TenantContext.setTenant((String)elsAccount);
        log.info(JSON.toJSONString((Object)obj));
        JSONObject jsonResult = XcUtil.getResult((JSONObject)obj, (String)elsAccount);
        List deptVOs = JSON.parseArray((String)jsonResult.getString("rows"), CurrencyVO.class);
        ArrayList<DictItem> dicts = new ArrayList<DictItem>();
        for (CurrencyVO currencyVO : deptVOs) {
            DictItem dictDto = new DictItem();
            BeanConvertorUtil.convertor((Object)currencyVO, (Object)dictDto);
            dictDto.setThirdType(ThirdTypeEnum.THIRD_JD_XC.getValue());
            dicts.add(dictDto);
        }
        this.dictService.batchSaveMain(elsAccount, DictCodeEnum.SRM_CURRENCY.getCode(), DictCodeEnum.SRM_CURRENCY.getValue(), dicts);
        this.getPageInfo(obj, custom);
        return jsonResult;
    }
}

