/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.enterprise.api.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.SysUtil;
import com.els.modules.enterprise.api.dto.ElsEnterpriseInfoDTO;
import com.els.modules.enterprise.api.dto.ElsEnterpriseInfoRecordDTO;
import com.els.modules.enterprise.api.dto.ElsEnterpriseInfoRelationDTO;
import com.els.modules.enterprise.api.dto.SupplierMasterDataDTO;
import com.els.modules.enterprise.api.service.ElsEnterpriseInfoRpcService;
import com.els.modules.enterprise.entity.ElsEnterpriseInfo;
import com.els.modules.enterprise.entity.ElsEnterpriseInfoRecord;
import com.els.modules.enterprise.entity.ElsEnterpriseInfoRelation;
import com.els.modules.enterprise.service.ElsEnterpriseInfoRecordService;
import com.els.modules.enterprise.service.ElsEnterpriseInfoRelationService;
import com.els.modules.enterprise.service.ElsEnterpriseInfoService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

@RpcService
public class ElsEnterpriseInfoBeanServiceImpl
implements ElsEnterpriseInfoRpcService {
    @Autowired(required=false)
    private ElsEnterpriseInfoService elsEnterpriseInfoService;
    @Autowired(required=false)
    private ElsEnterpriseInfoRelationService elsEnterpriseInfoRelationService;
    @Autowired(required=false)
    private ElsEnterpriseInfoRecordService elsEnterpriseInfoRecordService;

    public ElsEnterpriseInfoDTO getByElsAccount(String elsAccount) {
        ElsEnterpriseInfo enterpriseInfo = this.elsEnterpriseInfoService.getByElsAccount(elsAccount);
        if (enterpriseInfo != null) {
            return (ElsEnterpriseInfoDTO)SysUtil.copyProperties((Object)((Object)enterpriseInfo), ElsEnterpriseInfoDTO.class);
        }
        return null;
    }

    public ElsEnterpriseInfoRelationDTO getByElsAccountAndToelsAccount(String elsAccount, String toElsAccount) {
        ElsEnterpriseInfoRelation elsEnterpriseInfoRelation = this.elsEnterpriseInfoRelationService.getByElsAccountAndToelsAccount(elsAccount, toElsAccount);
        if (elsEnterpriseInfoRelation != null) {
            elsEnterpriseInfoRelation.setToElsAccount("");
            elsEnterpriseInfoRelation.setElsAccount(toElsAccount);
            return (ElsEnterpriseInfoRelationDTO)SysUtil.copyProperties((Object)((Object)elsEnterpriseInfoRelation), ElsEnterpriseInfoRelationDTO.class);
        }
        return null;
    }

    public ElsEnterpriseInfoRecordDTO getEnterpriseInfoRecordById(String id) {
        ElsEnterpriseInfoRecord record = (ElsEnterpriseInfoRecord)((Object)this.elsEnterpriseInfoRecordService.getById((Serializable)((Object)id)));
        if (record != null) {
            return (ElsEnterpriseInfoRecordDTO)SysUtil.copyProperties((Object)((Object)record), ElsEnterpriseInfoRecordDTO.class);
        }
        return null;
    }

    public int getMaxVersion(String elsAccount, String toElsAccount) {
        return this.elsEnterpriseInfoRecordService.getMaxVersion(elsAccount, toElsAccount);
    }

    public void insert(ElsEnterpriseInfoRecordDTO enterpriseInfoRecordDTO) {
        ElsEnterpriseInfoRecord enterpriseInfoRecord = (ElsEnterpriseInfoRecord)((Object)SysUtil.copyProperties((Object)enterpriseInfoRecordDTO, ElsEnterpriseInfoRecord.class));
        this.elsEnterpriseInfoRecordService.save((Object)enterpriseInfoRecord);
    }

    public void updateById(ElsEnterpriseInfoDTO enterpriseInfoDTO) {
        ElsEnterpriseInfo elsEnterpriseInfo = (ElsEnterpriseInfo)((Object)SysUtil.copyProperties((Object)enterpriseInfoDTO, ElsEnterpriseInfo.class));
        this.elsEnterpriseInfoService.updateById((Object)elsEnterpriseInfo);
    }

    public void inserElsEnterpriseInfoRelation(ElsEnterpriseInfoRelationDTO relationDTO) {
        this.elsEnterpriseInfoRelationService.save((Object)((ElsEnterpriseInfoRelation)((Object)SysUtil.copyProperties((Object)relationDTO, ElsEnterpriseInfoRelation.class))));
    }

    public void inserBatchElsEnterpriseInfoRelation(List<ElsEnterpriseInfoRelationDTO> list) {
        List infoRelationList = Convert.toList(ElsEnterpriseInfoRelation.class, list);
        this.elsEnterpriseInfoRelationService.saveBatch(infoRelationList, 2000);
    }

    public void updateElsEnterpriseInfoRelation(ElsEnterpriseInfoRelationDTO relationDTO) {
        this.elsEnterpriseInfoRelationService.updateByElsAccountAndToElsAccount((ElsEnterpriseInfoRelation)((Object)SysUtil.copyProperties((Object)relationDTO, ElsEnterpriseInfoRelation.class)));
    }

    public void updateBatchElsEnterpriseInfoRelation(List<ElsEnterpriseInfoRelationDTO> list) {
        List infoRelationList = Convert.toList(ElsEnterpriseInfoRelation.class, list);
        this.elsEnterpriseInfoRelationService.updateBatchById(infoRelationList, 2000);
    }

    public void insert(ElsEnterpriseInfoDTO enterpriseInfoDTO) {
        ElsEnterpriseInfo elsEnterpriseInfo = (ElsEnterpriseInfo)((Object)SysUtil.copyProperties((Object)enterpriseInfoDTO, ElsEnterpriseInfo.class));
        this.elsEnterpriseInfoService.save((Object)elsEnterpriseInfo);
    }

    public List<ElsEnterpriseInfoDTO> selectList(String companyName, String isPerson) {
        List enterpriseInfos;
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"name", (Object)companyName);
        if (StrUtil.isBlank((CharSequence)isPerson) || "0".equals(isPerson)) {
            queryWrapper.and(q -> ((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)q.eq(StrUtil.isNotBlank((CharSequence)isPerson), (Object)"is_person", (Object)isPerson)).or()).isNull((Object)"is_person")).or()).eq((Object)"is_person", (Object)""));
        }
        if ("1".equals(isPerson)) {
            queryWrapper.eq((Object)"is_person", (Object)isPerson);
        }
        if ((enterpriseInfos = this.elsEnterpriseInfoService.list((Wrapper)queryWrapper)) != null) {
            return SysUtil.copyProperties((List)enterpriseInfos, ElsEnterpriseInfoDTO.class);
        }
        return null;
    }

    public ElsEnterpriseInfoDTO getById(String id) {
        ElsEnterpriseInfo enterpriseInfo = (ElsEnterpriseInfo)((Object)this.elsEnterpriseInfoService.getById((Serializable)((Object)id)));
        if (enterpriseInfo != null) {
            return (ElsEnterpriseInfoDTO)SysUtil.copyProperties((Object)((Object)enterpriseInfo), ElsEnterpriseInfoDTO.class);
        }
        return null;
    }

    public List<ElsEnterpriseInfoDTO> queryByElsAccountList(List<String> accountList) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.in(BaseEntity::getElsAccount, accountList);
        List list = this.elsEnterpriseInfoService.list((Wrapper)wrapper);
        return Convert.toList(ElsEnterpriseInfoDTO.class, (Object)list);
    }

    public List<ElsEnterpriseInfoDTO> selectWithoutElsAccountByElsAccountList(List<String> elsAccountList) {
        List<ElsEnterpriseInfo> list = this.elsEnterpriseInfoService.selectWithoutElsAccountByElsAccountList(elsAccountList);
        return Convert.toList(ElsEnterpriseInfoDTO.class, list);
    }

    public List<ElsEnterpriseInfoRecordDTO> getEnterpriseInfoRecordByIdList(List<String> enterpriseInfoRecordIdList) {
        List<ElsEnterpriseInfoRecord> recordList = this.elsEnterpriseInfoRecordService.getEnterpriseInfoRecordByIdList(enterpriseInfoRecordIdList);
        if (recordList != null) {
            return SysUtil.copyProperties(recordList, ElsEnterpriseInfoRecordDTO.class);
        }
        return null;
    }

    public List<ElsEnterpriseInfoDTO> getListAll() {
        List list = this.elsEnterpriseInfoService.list();
        return Convert.toList(ElsEnterpriseInfoDTO.class, (Object)list);
    }

    public List<ElsEnterpriseInfoRelationDTO> getListRelationAll() {
        List list = this.elsEnterpriseInfoRelationService.list();
        return Convert.toList(ElsEnterpriseInfoRelationDTO.class, (Object)list);
    }

    public void saveBatchRelation(List<ElsEnterpriseInfoRelationDTO> dtoList) {
        List elsEnterpriseInfoRelations = Convert.toList(ElsEnterpriseInfoRelation.class, dtoList);
        this.elsEnterpriseInfoRelationService.saveBatch(elsEnterpriseInfoRelations, 2000);
    }

    public List<ElsEnterpriseInfoDTO> getElsEnterpriseInfoDTOs(List<SupplierMasterDataDTO> datas) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        datas.forEach(i -> ((LambdaQueryWrapper)wrapper.or()).and(w -> ((LambdaQueryWrapper)w.eq(ElsEnterpriseInfo::getName, (Object)i.getSupplierName())).eq("1".equals(i.getIsPerson()), ElsEnterpriseInfo::getPhoneNumber, (Object)i.getPhoneNumber())));
        List list = this.elsEnterpriseInfoService.list((Wrapper)wrapper);
        if (CollectionUtil.isEmpty((Collection)list)) {
            return new ArrayList<ElsEnterpriseInfoDTO>();
        }
        return SysUtil.copyProperties((List)list, ElsEnterpriseInfoDTO.class);
    }
}

