/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.excel;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.constant.CommonConstant;
import com.els.common.excel.service.ErrorExcelHandlerService;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.ExcelImportDTO;
import com.els.modules.base.api.service.ExcelImportRpcService;
import com.els.modules.system.entity.Dict;
import com.els.modules.system.service.DictService;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@RpcService(value="dictHeadImportRpcImpl")
public class DictHeadImportImpl
extends ErrorExcelHandlerService
implements ExcelImportRpcService {
    private static final Logger log = LoggerFactory.getLogger(DictHeadImportImpl.class);
    @Autowired
    private DictService dictService;

    public List<Map<String, Object>> importExcel(ExcelImportDTO excelImportDTO) {
        List dataList = excelImportDTO.getDataList();
        int totalCount = 0 == excelImportDTO.getTotalCount() ? dataList.size() : excelImportDTO.getTotalCount();
        ArrayList<String> dictCodeList = new ArrayList<String>();
        Iterator iterator = dataList.iterator();
        while (iterator.hasNext()) {
            String msg;
            Map data = (Map)iterator.next();
            String dictCode = (String)data.get("dictCode");
            if (CharSequenceUtil.isEmpty((CharSequence)dictCode)) {
                String msg2 = I18nUtil.translate((String)"i18n_alert_JCAoxOLV_9aa1ee7c", (String)"\u5b57\u5178\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                this.errorAdd(excelImportDTO, msg2, data);
                iterator.remove();
                continue;
            }
            String itemValue = (String)data.get("dictName");
            if (CharSequenceUtil.isEmpty((CharSequence)itemValue)) {
                msg = I18nUtil.translate((String)"i18n_alert_JCRLxOLV_46230e54", (String)"\u5b57\u5178\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
                this.errorAdd(excelImportDTO, msg, data);
                iterator.remove();
                continue;
            }
            if (dictCodeList.contains(dictCode)) {
                msg = I18nUtil.translate((String)"i18n_alert_JCAoVB_951a964c", (String)"\u5b57\u5178\u7f16\u7801\u91cd\u590d");
                this.errorAdd(excelImportDTO, msg, data);
                iterator.remove();
                continue;
            }
            if (dictCodeList.contains(dictCode)) continue;
            dictCodeList.add(dictCode);
        }
        if (CollUtil.isEmpty(dictCodeList)) {
            this.errorHandle(true, excelImportDTO, TenantContext.getTenant(), totalCount);
            return dataList;
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.select(new SFunction[]{BaseEntity::getId, Dict::getDictCode});
        ((LambdaQueryWrapper)wrapper.in(Dict::getDictCode, dictCodeList)).eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        List dictList = this.dictService.list((Wrapper)wrapper);
        Map<String, String> dictIdMap = dictList.stream().collect(Collectors.toMap(Dict::getDictCode, BaseEntity::getId, (v1, v2) -> v2));
        iterator = dataList.iterator();
        ArrayList<Dict> newDictList = new ArrayList<Dict>();
        ArrayList<Dict> updateDictList = new ArrayList<Dict>();
        ArrayList<String> updateDictIdList = new ArrayList<String>();
        HashSet i18NameList = Sets.newHashSet();
        while (iterator.hasNext()) {
            String msg;
            Map data = (Map)iterator.next();
            String dictCode = (String)data.get("dictCode");
            String dictName = (String)data.get("dictName");
            String id = (String)data.get("id");
            if (!dictIdMap.containsKey(dictCode) && CharSequenceUtil.isEmpty((CharSequence)id)) {
                Dict dict = (Dict)((Object)JSON.parseObject((String)JSON.toJSONString((Object)data), Dict.class));
                dict.setDictType(CharSequenceUtil.blankToDefault((CharSequence)dict.getDictType(), (String)"user"));
                dict.setAllowAddToCompany(CharSequenceUtil.blankToDefault((CharSequence)dict.getAllowAddToCompany(), (String)"0"));
                dict.setElsAccount(TenantContext.getTenant());
                dict.setId(IdWorker.getIdStr());
                dict.setDeleted(CommonConstant.NO_0);
                newDictList.add(dict);
                i18NameList.add(dictName);
                continue;
            }
            String dictId = dictIdMap.get(dictCode);
            if (!CharSequenceUtil.equals((CharSequence)id, (CharSequence)dictId)) {
                msg = dictCode + I18nUtil.translate((String)"i18n_alert_ID0IdjJCAoIMKAPWFxkHV_da9c6301", (String)"ID${0}\u5bf9\u5e94\u7684\u5b57\u5178\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u5f53\u524d\u6570\u636e\u4e0d\u505a\u66f4\u65b0", (String[])new String[]{id});
                this.errorAdd(excelImportDTO, msg, data);
                iterator.remove();
                continue;
            }
            if (updateDictIdList.contains(id)) {
                msg = dictCode + I18nUtil.translate((String)"i18n_alert_ID0IdjJCVBAPWFxkHV_ad9090c2", (String)"ID${0}\u5bf9\u5e94\u7684\u5b57\u5178\u91cd\u590d\uff0c\u5f53\u524d\u6570\u636e\u4e0d\u505a\u66f4\u65b0", (String[])new String[]{id});
                this.errorAdd(excelImportDTO, msg, data);
                iterator.remove();
                continue;
            }
            updateDictIdList.add(id);
            Dict dict = (Dict)((Object)JSON.parseObject((String)JSON.toJSONString((Object)data), Dict.class));
            dict.setDictType(CharSequenceUtil.blankToDefault((CharSequence)dict.getDictType(), (String)"user"));
            dict.setAllowAddToCompany(CharSequenceUtil.blankToDefault((CharSequence)dict.getAllowAddToCompany(), (String)"0"));
            dict.setDeleted(CommonConstant.NO_0);
            dict.setElsAccount(TenantContext.getTenant());
            updateDictList.add(dict);
        }
        if (CollUtil.isEmpty(newDictList) && CollUtil.isEmpty(updateDictList)) {
            this.errorHandle(true, excelImportDTO, TenantContext.getTenant(), totalCount);
            return dataList;
        }
        if (CollUtil.isNotEmpty(newDictList)) {
            this.dictService.saveBatch(newDictList);
        }
        if (CollUtil.isNotEmpty(updateDictList)) {
            this.dictService.updateBatchById(updateDictList);
        }
        this.errorHandle(true, excelImportDTO, TenantContext.getTenant(), totalCount);
        return dataList;
    }
}

