/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.enumerate.DeployWayEnum;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.AdminFlagUtil;
import com.els.common.util.ConfigUtil;
import com.els.common.util.ConvertUtils;
import com.els.common.util.I18nUtil;
import com.els.common.util.MD5Util;
import com.els.common.util.RedisKeyUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SysUtil;
import com.els.common.util.TemplateParseUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.account.api.dto.PermissionDTO;
import com.els.modules.system.entity.Permission;
import com.els.modules.system.mapper.PermissionMapper;
import com.els.modules.system.service.PermissionExtendService;
import com.els.modules.system.vo.MenuVO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PermissionExtendServiceImpl
extends ServiceImpl<PermissionMapper, Permission>
implements PermissionExtendService {
    private static final Logger log = LoggerFactory.getLogger(PermissionExtendServiceImpl.class);
    @Autowired
    private RedisUtil redisUtil;
    private static Map<String, String> cacheMap = new ConcurrentHashMap<String, String>();

    @Override
    public void createOrUpdate(String customId, List<PermissionDTO> permissionList) {
        ((PermissionMapper)this.baseMapper).deleteByCustomBusinessId(customId);
        if (permissionList != null && !permissionList.isEmpty()) {
            ArrayList insertList = SysUtil.copyProperties(permissionList, Permission.class);
            this.saveBatch(insertList);
            List idList = insertList.stream().filter(vo -> StrUtil.isNotBlank((CharSequence)vo.getParentId())).map(Permission::getParentId).distinct().collect(Collectors.toList());
            for (String id : idList) {
                ((PermissionMapper)this.baseMapper).setMenuLeaf(id, 0);
            }
        }
    }

    @Override
    public List<String> getPermissonCodeListByAccountId(String elsAccount, String accountId) {
        List<Permission> resourceList = this.getByAccountId(elsAccount, accountId);
        ArrayList<String> resultList = new ArrayList<String>();
        for (Permission vo : resourceList) {
            String permissonCode;
            if ("0".equals(vo.getStatus()) || !StrUtil.isNotBlank((CharSequence)(permissonCode = vo.getPerms()))) continue;
            if (permissonCode.contains(";")) {
                resultList.addAll(Arrays.asList(permissonCode.split(";")));
                continue;
            }
            resultList.add(permissonCode);
        }
        return resultList;
    }

    @Override
    public List<Permission> getByAccountId(String elsAccount, String accountId) {
        String adminFlag = AdminFlagUtil.getAdminFlag();
        if ("0".equals(adminFlag) && CharSequenceUtil.isNotEmpty((CharSequence)accountId)) {
            return ((PermissionMapper)this.baseMapper).getRoleResourceByAccountId(elsAccount, accountId);
        }
        String deployWay = ConfigUtil.getDeployWay();
        String purchaseAccount = ConfigUtil.getPurchaseAccount();
        if (DeployWayEnum.SAAS.getValue().equals(deployWay)) {
            if (purchaseAccount.equals(elsAccount) && "1".equals(adminFlag)) {
                return ((PermissionMapper)this.baseMapper).getAllResourceList();
            }
            String tenantAttribute = "";
            List<Permission> resourceList = ((PermissionMapper)this.baseMapper).getTenantResourceList(elsAccount);
            if (StrUtil.isNotBlank((CharSequence)tenantAttribute) && tenantAttribute.contains("supplier")) {
                List<Permission> allList = ((PermissionMapper)this.baseMapper).getAllResourceList();
                List waitAddList = allList.stream().filter(o -> "2".equals(o.getMenuAttribute()) || "3".equals(o.getMenuAttribute())).collect(Collectors.toList());
                List<String> existIdList = resourceList.stream().map(BaseEntity::getId).toList();
                for (Permission resource : waitAddList) {
                    if (existIdList.contains(resource.getId())) continue;
                    resourceList.add(resource);
                }
            }
            return resourceList;
        }
        List<Permission> list = ((PermissionMapper)this.baseMapper).getAllResourceList();
        if (elsAccount.equals(purchaseAccount)) {
            return list.stream().filter(o -> !"2".equals(o.getMenuAttribute())).collect(Collectors.toList());
        }
        List<Permission> authList = ((PermissionMapper)this.baseMapper).getLocalTenantResourceListBySupplierGroup(purchaseAccount, elsAccount);
        if (!authList.isEmpty()) {
            return authList;
        }
        return list.stream().filter(o -> "2".equals(o.getMenuAttribute()) || "3".equals(o.getMenuAttribute())).collect(Collectors.toList());
    }

    @Override
    public JSONObject queryByCurrentAccount() {
        LoginUserDTO user = SysUtil.getLoginUser();
        String redisKey = RedisKeyUtil.getPermissionMenuRedisKey((String)user.getElsAccount(), (String)user.getSubAccount());
        JSONObject result = (JSONObject)this.redisUtil.get(redisKey);
        if (result != null) {
            return result;
        }
        List<Permission> resourceList = this.getByAccountId(user.getElsAccount(), user.getId());
        result = new JSONObject();
        ArrayList<MenuVO> menuTree = new ArrayList<MenuVO>();
        this.buildMeunTree(menuTree, resourceList);
        result.put("menu", menuTree);
        JSONArray authjsonArray = new JSONArray();
        this.getAuthJsonArray(authjsonArray, resourceList);
        result.put("auth", (Object)authjsonArray);
        JSONArray docArray = new JSONArray();
        this.getDocArray(docArray, resourceList);
        result.put("doc", (Object)docArray);
        List<Permission> allList = ((PermissionMapper)this.baseMapper).getAllResourceList();
        JSONArray allauthjsonArray = new JSONArray();
        this.getAllAuthJsonArray(allauthjsonArray, allList);
        result.put("allAuth", (Object)allauthjsonArray);
        if (!menuTree.isEmpty()) {
            this.redisUtil.set(redisKey, (Object)result);
        }
        return result;
    }

    private void buildMeunTree(List<MenuVO> menuTree, List<Permission> resourceList) {
        List<Permission> list = resourceList.stream().filter(item -> item.getMenuType() != null).filter(item -> item.getMenuType() != 2 && "1".equals(item.getStatus())).toList();
        HashMap menuMap = new HashMap();
        long beginTime = System.currentTimeMillis();
        list.stream().forEach(resource -> {
            MenuVO menu = this.getMenuVO((Permission)((Object)resource));
            menuMap.put(menu.getId(), menu);
        });
        log.info("build_map_costTime:" + (System.currentTimeMillis() - beginTime));
        for (Permission resource2 : list) {
            MenuVO menu = (MenuVO)menuMap.get(resource2.getId());
            if (StrUtil.isBlank((CharSequence)resource2.getParentId()) || !menuMap.containsKey(resource2.getParentId())) {
                menuTree.add(menu);
                continue;
            }
            MenuVO parentMenu = (MenuVO)menuMap.get(resource2.getParentId());
            parentMenu.getChildren().add(menu);
        }
    }

    private void getAuthJsonArray(JSONArray jsonArray, List<Permission> resourceList) {
        for (Permission resource : resourceList) {
            JSONObject json;
            if (StrUtil.isEmpty((CharSequence)resource.getPerms()) || "0".equals(resource.getStatus())) continue;
            if (resource.getPerms().contains(";")) {
                String[] array;
                for (String str : array = resource.getPerms().split(";")) {
                    json = new JSONObject();
                    json.put("action", (Object)str);
                    json.put("describe", (Object)resource.getName());
                    jsonArray.add((Object)json);
                }
                continue;
            }
            json = new JSONObject();
            json.put("action", (Object)resource.getPerms());
            json.put("describe", (Object)resource.getName());
            jsonArray.add((Object)json);
        }
    }

    JSONArray getDocArray(JSONArray docArray, List<Permission> metaList) {
        for (Permission vo : metaList) {
            if (StrUtil.isBlank((CharSequence)vo.getUrl())) continue;
            JSONObject object = new JSONObject();
            object.put("path", (Object)vo.getUrl());
            if (StrUtil.isBlank((CharSequence)vo.getHelpDesc())) {
                object.put("hasDoc", (Object)"0");
            } else {
                object.put("hasDoc", (Object)"1");
            }
            docArray.add((Object)object);
        }
        return docArray;
    }

    private void getAllAuthJsonArray(JSONArray jsonArray, List<Permission> allList) {
        for (Permission permission : allList) {
            if (StrUtil.isBlank((CharSequence)permission.getPerms())) continue;
            JSONObject json = new JSONObject();
            if (!"1".equals(permission.getStatus())) continue;
            if (permission.getPerms().contains(";")) {
                for (String str : permission.getPerms().split(";")) {
                    json = new JSONObject();
                    json.put("action", (Object)str);
                    json.put("type", (Object)permission.getPermsType());
                    json.put("status", (Object)permission.getStatus());
                    json.put("describe", (Object)permission.getName());
                    jsonArray.add((Object)json);
                }
                continue;
            }
            json = new JSONObject();
            json.put("action", (Object)permission.getPerms());
            json.put("type", (Object)permission.getPermsType());
            json.put("status", (Object)permission.getStatus());
            json.put("describe", (Object)permission.getName());
            jsonArray.add((Object)json);
        }
    }

    private MenuVO getMenuVO(Permission resource) {
        MenuVO menu = new MenuVO();
        menu.setId(resource.getId());
        if (this.isWWWHttpUrl(resource.getUrl())) {
            menu.setPath(MD5Util.md5Encode((String)resource.getUrl(), (String)"utf-8"));
        } else {
            menu.setPath(resource.getUrl());
        }
        if (resource.isRoute()) {
            menu.setRoute("1");
        } else {
            menu.setRoute("0");
        }
        menu.setMobile(resource.isMobile());
        if (ConvertUtils.isNotEmpty((Object)resource.getComponentName())) {
            menu.setName(resource.getComponentName());
        } else {
            menu.setName(this.urlToRouteName(resource.getUrl()));
        }
        menu.setComponent(resource.getComponent());
        menu.setHidden(resource.isHidden());
        JSONObject meta = new JSONObject();
        meta.put("keepAlive", (Object)resource.isKeepAlive());
        meta.put("internalOrExternal", (Object)resource.isInternalOrExternal());
        meta.put("defaultAudit", (Object)resource.isDefaultAudit());
        meta.put("title", (Object)this.getI18nNameByCache(resource.getNameI18nKey(), resource.getName()));
        if (this.isWWWHttpUrl(resource.getUrl())) {
            String url = resource.getUrl();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("elsAccount", TenantContext.getTenant());
            url = TemplateParseUtil.getTemplateText(null, (String)url, map);
            meta.put("url", (Object)url);
        }
        if (StrUtil.isNotBlank((CharSequence)resource.getIcon())) {
            meta.put("icon", (Object)resource.getIcon());
        }
        if (StrUtil.isNotBlank((CharSequence)resource.getIconColor())) {
            meta.put("iconColor", (Object)resource.getIconColor());
        }
        meta.put("pageBusinessType", (Object)resource.getPageBusinessType());
        meta.put("pageColumnsCode", (Object)resource.getPageColumnsCode());
        meta.put("pagePattern", (Object)resource.getPagePattern());
        meta.put("pageBusinessUrl", (Object)resource.getPageBusinessUrl());
        meta.put("pageAuditSubject", (Object)resource.getPageAuditSubject());
        if (StrUtil.isNotBlank((CharSequence)resource.getHelpDocUrl())) {
            meta.put("helpDocUrl", (Object)resource.getHelpDocUrl());
        }
        menu.setMeta(meta);
        return menu;
    }

    private String getI18nNameByCache(String key, String defaultValue) {
        String language = I18nUtil.getCurrentLanguage();
        if (!"zh".equals(language)) {
            String cacheKey = key + language;
            if (cacheMap.containsKey(cacheKey)) {
                return cacheMap.get(cacheKey);
            }
            String i18nName = I18nUtil.translate((String)key, (String)defaultValue);
            cacheMap.put(cacheKey, i18nName);
            return i18nName;
        }
        return defaultValue;
    }

    private boolean isWWWHttpUrl(String url) {
        return url != null && (url.startsWith("http://") || url.startsWith("https://") || url.startsWith("{{"));
    }

    private String urlToRouteName(String url) {
        if (StrUtil.isNotEmpty((CharSequence)url)) {
            if (url.startsWith("/")) {
                url = url.substring(1);
            }
            url = url.replace("/", "-");
            url = url.replace(":", "@");
            return url;
        }
        return null;
    }

    @Override
    public List<Permission> getResourceTreeList() {
        ArrayList<Permission> resultTreeList = new ArrayList<Permission>();
        List resourceList = this.list((Wrapper)new LambdaQueryWrapper().orderByAsc(Permission::getSortNo));
        this.buildTree(resultTreeList, resourceList);
        return resultTreeList;
    }

    private void buildTree(List<Permission> resultTreeList, List<Permission> resourceList) {
        Map resourceMap = resourceList.parallelStream().collect(Collectors.toMap(BaseEntity::getId, Function.identity()));
        for (Permission resource : resourceList) {
            resource.setKey(resource.getId());
            if (StrUtil.isBlank((CharSequence)resource.getParentId()) || !resourceMap.containsKey(resource.getParentId())) {
                resultTreeList.add(resource);
                continue;
            }
            Permission parentResource = (Permission)((Object)resourceMap.get(resource.getParentId()));
            parentResource.getChildren().add(resource);
        }
    }
}

