/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ai.controller;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.els.common.exception.ELSBootException;
import com.els.common.trace.TraceIdHolder;
import com.els.common.trace.TraceIdUtil;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SrmUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.account.api.dto.ThirdAuthDTO;
import com.els.modules.ai.util.AiEncryptionUtil;
import com.els.rpc.service.InvokeAccountRpcService;
import java.net.URLEncoder;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/base/ai"})
public class SrmToAiApiController {
    private static final Logger log = LoggerFactory.getLogger(SrmToAiApiController.class);
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private InvokeAccountRpcService invokeAccountRpcService;
    private static final String AI_TRACE_ID_KEY = "ai:traceIdToken:";
    @Value(value="${els.config.ai.encryptPublicKey}")
    private String publicKey;

    @PostMapping(value={"/invokeAi/{interfaceCode}"})
    public Object invokeAi(@RequestBody JSONObject param, @PathVariable(value="interfaceCode") String interfaceCode, HttpServletRequest request) throws Exception {
        String srmToken;
        LoginUserDTO loginUser = SrmUtil.getLoginUser();
        LoginUserDTO newUser = new LoginUserDTO();
        newUser.setId(loginUser.getId());
        newUser.setElsAccount(loginUser.getElsAccount());
        newUser.setSubAccount(loginUser.getSubAccount());
        newUser.setCompanyName(loginUser.getCompanyName());
        newUser.setCompanyShortName(loginUser.getCompanyShortName());
        newUser.setRealname(loginUser.getRealname());
        newUser.setStatus(loginUser.getStatus());
        String traceId = TraceIdHolder.get();
        if (CharSequenceUtil.isEmpty((CharSequence)traceId)) {
            traceId = TraceIdUtil.generateOutTraceId();
        }
        if (CharSequenceUtil.isEmpty((CharSequence)(srmToken = request.getHeader("X-Access-Token")))) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"Token\u4e3a\u7a7a"));
        }
        ThirdAuthDTO authDTO = this.getAiAppToken(TenantContext.getTenant(), "srmAi");
        param.put((Object)"loginUser", (Object)JSON.toJSONString((Object)newUser));
        JSONObject encryptedParam = AiEncryptionUtil.buildEncryptObj((JSONObject)param, (String)traceId, (String)authDTO.getAppKey(), (String)authDTO.getAppSecret(), (String)this.publicKey);
        Map parameterMap = request.getParameterMap();
        StringBuilder urlBuilder = new StringBuilder(authDTO.getAppUrl());
        urlBuilder.append("/").append(interfaceCode);
        if (parameterMap != null && !parameterMap.isEmpty()) {
            urlBuilder.append("?");
            boolean isFirstParam = true;
            for (Map.Entry entry : parameterMap.entrySet()) {
                String paramName = (String)entry.getKey();
                String[] paramValues = (String[])entry.getValue();
                if (paramValues == null || paramValues.length <= 0) continue;
                for (String value : paramValues) {
                    if (!isFirstParam) {
                        urlBuilder.append("&");
                    }
                    try {
                        urlBuilder.append(URLEncoder.encode(paramName, "UTF-8")).append("=").append(URLEncoder.encode(value, "UTF-8"));
                        isFirstParam = false;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        this.redisUtil.set(AI_TRACE_ID_KEY + traceId, (Object)srmToken);
        String body = ((HttpRequest)((HttpRequest)((HttpRequest)HttpRequest.post((String)urlBuilder.toString()).header("key", authDTO.getAppKey())).header("secret", authDTO.getAppSecret())).header("x-request-id", traceId)).body(encryptedParam.toString()).execute().body();
        return JSON.parseObject((String)body);
    }

    public ThirdAuthDTO getAiAppToken(String elsAccount, String type) {
        ThirdAuthDTO authDTO = this.invokeAccountRpcService.getThirdAuthByType(elsAccount, type);
        if (null == authDTO || CharSequenceUtil.isEmpty((CharSequence)authDTO.getAppKey()) || CharSequenceUtil.isEmpty((CharSequence)authDTO.getAppSecret())) {
            throw new ELSBootException("AI\u63a5\u53e3\u51ed\u8bc1\u4e0d\u5b58\u5728");
        }
        return authDTO;
    }
}

