/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.base.api.service.impl;

import cn.hutool.core.util.StrUtil;
import com.els.common.api.service.InterfaceConverter;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.util.InterfaceConverterUtil;
import com.els.common.util.RedisUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.system.entity.DictItem;
import com.els.modules.system.service.DictService;
import com.google.common.base.Functions;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;

@RpcService(value="findColumnByDictConverter")
public class FindColumnByDictConverter
implements InterfaceConverter {
    private static final Logger log = LoggerFactory.getLogger(FindColumnByDictConverter.class);
    private static final String REDIS_PREFIX = "srm:getTaxConver";
    @Autowired
    private RedisUtil redisUtil;
    @Lazy
    @Resource
    private DictService dictService;

    public Object convertData(Object data, Object obj, String ... args) throws Exception {
        String searData = (String)data;
        String elsAccount = TenantContext.getTenant();
        String dictCode = args[0];
        String searColumn = args[1];
        String outColumn = args[2];
        if (StrUtil.isNotBlank((CharSequence)searData)) {
            List<DictItem> dbAccount = (List<DictItem>)this.redisUtil.get(REDIS_PREFIX + elsAccount + ":" + dictCode);
            Map<Object, Object> dbMap = new HashMap();
            if (CollectionUtils.isEmpty((Collection)dbAccount)) {
                dbAccount = this.dictService.findByDictCode(elsAccount, dictCode);
                if (CollectionUtils.isEmpty(dbAccount)) {
                    return "";
                }
                this.redisUtil.set(REDIS_PREFIX + elsAccount, dbAccount, 300L);
            }
            if ("itemValue".equals(searColumn)) {
                dbMap = dbAccount.stream().collect(Collectors.toMap(DictItem::getItemValue, Functions.identity()));
            } else if ("sourceId".equals(searColumn)) {
                dbMap = dbAccount.stream().collect(Collectors.toMap(DictItem::getThirdPartyId, Functions.identity()));
            }
            if (dbMap.containsKey(searData)) {
                if (outColumn.indexOf("_") > 0) {
                    String[] columns = outColumn.split("_");
                    StringBuilder sb = new StringBuilder();
                    for (int i = 0; i < columns.length; ++i) {
                        sb.append(InterfaceConverterUtil.findName((String)columns[i], (Object)dbMap.get(searData)));
                        if (i == columns.length) continue;
                        sb.append("_");
                    }
                    return InterfaceConverterUtil.findName((String)outColumn, (Object)sb.toString());
                }
                return InterfaceConverterUtil.findName((String)outColumn, (Object)dbMap.get(searData));
            }
            return "";
        }
        return searData;
    }
}

