/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.third.util;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.modules.third.vo.CreateJsonStructureVO;
import com.els.modules.third.vo.JSONConversionVO;
import java.util.ArrayList;
import java.util.List;

public class JSONParsingUtil {
    public static final String elsAccount = "2973985";
    public static final String configCode = "pushAdjustPriceData";

    private static void getObjectStruct(List<JSONConversionVO> itemList, JSONObject jsonObject, String parent, String nodeName, String srmInterfaceCode) {
        JSONConversionVO convertConfig = new JSONConversionVO();
        convertConfig.setNodeParent(parent);
        convertConfig.setNodeKey(nodeName);
        convertConfig.setSrmInterfaceCode(srmInterfaceCode);
        convertConfig.setNodeType("object");
        itemList.add(convertConfig);
        for (String key : jsonObject.keySet()) {
            Object child = jsonObject.get((Object)key);
            if (child instanceof JSONObject) {
                JSONObject childObject = (JSONObject)child;
                JSONParsingUtil.getObjectStruct(itemList, childObject, nodeName, key, srmInterfaceCode);
                continue;
            }
            if (child instanceof JSONArray) {
                JSONArray childArray = (JSONArray)child;
                JSONParsingUtil.getArrayStruct(itemList, childArray, nodeName, key, srmInterfaceCode);
                continue;
            }
            String str = String.valueOf(child);
            JSONConversionVO childConfig = new JSONConversionVO();
            childConfig.setNodeParent(nodeName);
            childConfig.setNodeKey(key);
            childConfig.setNodeValue(str);
            if (StrUtil.isNotBlank((CharSequence)str) && str.indexOf("$.") >= 0) {
                childConfig.setNodeType("string");
            } else {
                childConfig.setNodeType("const");
            }
            if (StrUtil.isNotBlank((CharSequence)str) && str.indexOf("|") >= 0) {
                String[] split = str.split("\\|");
                childConfig.setNodeName(split[0]);
                childConfig.setNodeValue(split[1]);
            }
            childConfig.setSort("100");
            itemList.add(childConfig);
        }
    }

    private static void getArrayStruct(List<JSONConversionVO> itemList, JSONArray jsonArray, String parent, String nodeName, String srmInterfaceCode) {
        JSONConversionVO arrayConfig = new JSONConversionVO();
        arrayConfig.setNodeParent(parent);
        arrayConfig.setNodeKey(nodeName);
        arrayConfig.setSrmInterfaceCode(srmInterfaceCode);
        arrayConfig.setNodeType("list");
        itemList.add(arrayConfig);
        if (!jsonArray.isEmpty() && jsonArray.get(0) instanceof JSONObject) {
            String objectNodeName = nodeName + "Object";
            JSONObject jsonObject = jsonArray.getJSONObject(0);
            JSONParsingUtil.getObjectStruct(itemList, jsonObject, nodeName, objectNodeName, srmInterfaceCode);
        }
    }

    public static List<JSONConversionVO> parsing(CreateJsonStructureVO structureVO) {
        String data = structureVO.getJsonString();
        String srmInterfaceCode = structureVO.getMappingGroupCode();
        ArrayList<JSONConversionVO> itemList = new ArrayList<JSONConversionVO>();
        if (data.trim().startsWith("{")) {
            JSONObject jsonObject = JSONObject.parseObject((String)data, (Feature[])new Feature[]{Feature.OrderedField});
            JSONParsingUtil.getObjectStruct(itemList, jsonObject, "[root]", "rootObject", srmInterfaceCode);
        } else if (data.trim().startsWith("[")) {
            JSONArray jsonArray = JSONArray.parseArray((String)data);
            JSONParsingUtil.getArrayStruct(itemList, jsonArray, "[root]", "rootArray", srmInterfaceCode);
        } else {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_VuNIdcWWWWWF_191dae89", (String)"\u8bf7\u5bfc\u5165\u6b63\u786e\u7684json\u6570\u636e"));
        }
        return itemList;
    }
}

