/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ai.mapping;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.els.common.exception.ELSBootException;
import com.els.common.util.SrmRpcUtil;
import com.els.modules.ai.dto.AiDictDto;
import com.els.modules.ai.dto.AiOrderCreationFiledSchemaDto;
import com.els.modules.ai.mapping.ConditionMapping;
import com.els.modules.ai.mapping.DictConditionMapping;
import com.els.modules.ai.service.SrmAiDictRpcService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class CorrectConditionMapping
implements ConditionMapping<JSONObject> {
    @Override
    public String type() {
        return "correctMapping";
    }

    @Override
    public JSONObject mapping(JSONObject condition, List<AiOrderCreationFiledSchemaDto> filedSchema) {
        Map filedMap = filedSchema.stream().filter(x -> CharSequenceUtil.isNotEmpty((CharSequence)x.getFieldDictCode()) && "1".equals(x.getDictFuzzySegmentation())).collect(Collectors.toMap(AiOrderCreationFiledSchemaDto::getFieldCode, Function.identity(), (v1, v2) -> v2));
        if (CollectionUtil.isEmpty(filedMap)) {
            return condition;
        }
        for (String key : condition.keySet()) {
            String dependentSqlFilter;
            AiOrderCreationFiledSchemaDto schemaDTO = (AiOrderCreationFiledSchemaDto)filedMap.get(key);
            if (null == schemaDTO) continue;
            JSONObject filterParamObj = new JSONObject();
            if (CharSequenceUtil.isNotEmpty((CharSequence)schemaDTO.getDependentFiled())) {
                String[] dependentFiledArray = schemaDTO.getDependentFiled().split(",");
                for (int i = 0; i < dependentFiledArray.length; ++i) {
                    String[] dependentFiledSplit = dependentFiledArray[i].split("#");
                    if (dependentFiledSplit.length != 2) {
                        throw new ELSBootException(schemaDTO.getFieldName() + "\u6a21\u578b\u5217\u914d\u7f6e\u683c\u5f0f\u6709\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e");
                    }
                    String dependentFiled = dependentFiledSplit[0];
                    String dependentFiledCondition = dependentFiledSplit[1];
                    AiOrderCreationFiledSchemaDto dependent = (AiOrderCreationFiledSchemaDto)filedMap.get(dependentFiled);
                    if (null == dependent) continue;
                    String dependentValue = condition.getString(dependentFiled);
                    JSONObject con = new JSONObject();
                    con.put((Object)dependent.getFieldCode(), (Object)dependentValue);
                    ArrayList temSchema = Lists.newArrayList((Object[])new AiOrderCreationFiledSchemaDto[]{dependent});
                    CorrectConditionMapping conditionMapping = new CorrectConditionMapping();
                    JSONObject conditionValue = conditionMapping.mapping(con, (List<AiOrderCreationFiledSchemaDto>)temSchema);
                    DictConditionMapping dictConditionMapping = new DictConditionMapping();
                    JSONObject mappingValue = dictConditionMapping.mapping(conditionValue, (List<AiOrderCreationFiledSchemaDto>)temSchema);
                    String v = mappingValue.getString(dependent.getFieldCode());
                    if (!CharSequenceUtil.isNotEmpty((CharSequence)v)) continue;
                    filterParamObj.put((Object)dependentFiledCondition, (Object)v);
                }
            }
            if (CharSequenceUtil.isNotEmpty((CharSequence)(dependentSqlFilter = schemaDTO.getDependentSqlFilter()))) {
                JSONObject filterObj = JSON.parseObject((String)dependentSqlFilter);
                for (String filedName : filterObj.keySet()) {
                    if (filterParamObj.containsKey(filedName)) continue;
                    filterParamObj.put((Object)filedName, filterObj.get(filedName));
                }
            }
            Object v = condition.get(key);
            String value = ObjectUtil.toString((Object)v);
            List<String> listValue = new ArrayList<String>();
            if (null != value && value.contains(",")) {
                listValue = Arrays.stream(value.split(",")).collect(Collectors.toList());
            } else {
                listValue.add(value);
            }
            ArrayList<AiDictDto> dictDtoList = new ArrayList<AiDictDto>();
            for (String text : listValue) {
                AiDictDto dictDto = new AiDictDto();
                dictDto.setDictCode(schemaDTO.getFieldDictCode());
                dictDto.setDictText(text);
                dictDto.setFilterParamObj(filterParamObj);
                dictDto.setModelFileDictType(schemaDTO.getModelFileDictType());
                String associationSplit = schemaDTO.getAssociationSplit();
                String associationColumn = schemaDTO.getAssociationColumn();
                dictDto.setAssociationSplit(associationSplit);
                dictDto.setAssociationColumn(associationColumn);
                dictDto.setBringValue(schemaDTO.getBringValue());
                dictDto.setDictFuzzySegmentation(schemaDTO.getDictFuzzySegmentation());
                dictDto.setFiledGroup(schemaDTO.getFiledGroup());
                dictDtoList.add(dictDto);
            }
            List<String> textResultList = ((SrmAiDictRpcService)SrmRpcUtil.getExecuteServiceImpl((String)"srmAiDictRpcServiceImpl", SrmAiDictRpcService.class)).queryDictTextByText(dictDtoList);
            condition.put((Object)key, (Object)String.join((CharSequence)",", new HashSet<String>(textResultList)));
        }
        return condition;
    }
}

