/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.dingtalk.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.dingtalkconference_1_0.models.CreateVideoConferenceResponseBody;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.dingtalk.entity.DingTalkMeetingReq;
import com.els.modules.dingtalk.entity.DingTalkMeetingResp;
import com.els.modules.dingtalk.rpc.service.MeetingElsAccountApiRpcService;
import com.els.modules.dingtalk.service.DingTalkMeetingService;
import com.els.modules.dingtalk.utils.DingTalkChatUtil;
import com.els.modules.dingtalk.utils.DingTalkMeetingUtil;
import com.els.modules.dingtalk.utils.DingTalkOauthUtil;
import com.els.modules.dingtalk.utils.DingTalkUserInfoUtil;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DingTalkMeetingServiceImpl
implements DingTalkMeetingService {
    private static final Logger log = LoggerFactory.getLogger(DingTalkMeetingServiceImpl.class);
    @Autowired
    private MeetingElsAccountApiRpcService elsAccountApiRpcService;

    @Override
    public DingTalkMeetingResp creatMeeting(DingTalkMeetingReq meetingReq) {
        CreateVideoConferenceResponseBody meeting;
        if (StrUtil.isBlank((CharSequence)meetingReq.getConfTitle())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_MIBDxOLVW_f1b3b3cc", (String)"\u4f1a\u8bae\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        String accesToken = "";
        ArrayList<String> unauthorizedSubAccounts = new ArrayList<String>();
        ArrayList<String> withoutPhoneSubAccounts = new ArrayList<String>();
        try {
            accesToken = DingTalkOauthUtil.getAccessToken();
        }
        catch (Exception e) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_SMIIWWWWWWWWWWKmW_25f06c04", (String)"\u83b7\u53d6\u9489\u9489accesToken\u5931\u8d25!"));
        }
        if (StrUtil.isBlank((CharSequence)accesToken)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_SMIIWWWWWWWWWWLVW_25c50018", (String)"\u83b7\u53d6\u9489\u9489accesToken\u4e3a\u7a7a!"));
        }
        ArrayList<String> unionIds = new ArrayList<String>();
        String createUserUnionId = this.checkCreateUserAuth(meetingReq.getCreateUserId(), accesToken);
        ArrayList<String> inviteUserMobileList = new ArrayList<String>();
        List<ElsSubAccountDTO> subAccountDTOList = this.elsAccountApiRpcService.searchSubAccountInfoByIds(meetingReq.getInviteUserIdList());
        if (subAccountDTOList != null && subAccountDTOList.size() > 0) {
            for (ElsSubAccountDTO dto : subAccountDTOList) {
                if (StrUtil.isNotBlank((CharSequence)dto.getPhone())) {
                    inviteUserMobileList.add(dto.getPhone());
                    continue;
                }
                withoutPhoneSubAccounts.add(dto.getSubAccount());
            }
        }
        for (ElsSubAccountDTO subAccountDTO : subAccountDTOList) {
            String mobile = subAccountDTO.getPhone();
            if (StrUtil.isBlank((CharSequence)mobile)) {
                withoutPhoneSubAccounts.add(subAccountDTO.getRealname());
                continue;
            }
            log.info("\u4f1a\u8bae\u53c2\u52a0\u4eba\u624b\u673a\u53f7\u7801[{}]", (Object)mobile);
            String userId = DingTalkUserInfoUtil.searchUserIdByMobile(mobile, accesToken);
            if (StrUtil.isBlank((CharSequence)userId)) {
                unauthorizedSubAccounts.add(subAccountDTO.getRealname());
                continue;
            }
            String unionId = DingTalkUserInfoUtil.searchUnionIdByUserId(userId, accesToken);
            log.info("\u9489\u9489\u89c6\u9891\u4f1a\u8bae\uff0c\u624b\u673a\u53f7[{}]\u83b7\u53d6\u5230\u7684unionId\u4e3a[{}]", (Object)mobile, (Object)unionId);
            unionIds.add(unionId);
        }
        try {
            meeting = DingTalkMeetingUtil.creatMeeting(meetingReq.getConfTitle(), createUserUnionId, unionIds, accesToken);
            log.info("\u9489\u9489\u89c6\u9891\u4f1a\u8bae\uff0c\u53d1\u8d77\u4f1a\u8bae\u8fd4\u56de\u7ed3\u679c\u6570\u636e\u4e3a[{}]", (Object)JSONObject.toJSONString((Object)meeting));
        }
        catch (Exception e) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_MIcIKmW_77c4e09a", (String)"\u4f1a\u8bae\u521b\u5efa\u5931\u8d25!"));
        }
        if (meeting == null) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_MIcIKmW_77c4e09a", (String)"\u4f1a\u8bae\u521b\u5efa\u5931\u8d25!"));
        }
        DingTalkMeetingResp resp = new DingTalkMeetingResp();
        resp.setExternalLinkUrl(meeting.getExternalLinkUrl());
        StringBuffer meetingMsgSb = new StringBuffer();
        meetingMsgSb.append("\u9489\u9489\u89c6\u9891\u4f1a\u8bae\u5165\u4f1a\u94fe\u63a5\u4e3a:").append("\r\n").append("a(").append(meeting.getExternalLinkUrl()).append(")[").append(meeting.getExternalLinkUrl()).append("]");
        if (unauthorizedSubAccounts.size() > 0) {
            resp.setUnauthorizedMobiles(unauthorizedSubAccounts);
            String unauthorizedStr = StrUtil.join((CharSequence)",", (Object[])unauthorizedSubAccounts.toArray());
            meetingMsgSb.append("\r\n").append("\u8d26\u53f7\u3010").append(unauthorizedStr).append("\u3011\u4e0d\u5b58\u5728\u5f53\u524d\u9489\u9489\u5e94\u7528\u4e2d\uff0c\u8bf7\u8054\u7cfb\u76f8\u5173\u9489\u9489\u7ba1\u7406\u5458!");
        }
        if (withoutPhoneSubAccounts.size() > 0) {
            resp.setWithoutPhoneSubAccounts(withoutPhoneSubAccounts);
            String withoutPhoneStr = StrUtil.join((CharSequence)",", (Object[])withoutPhoneSubAccounts.toArray());
            meetingMsgSb.append("\r\n").append("\u8d26\u53f7\u3010").append(withoutPhoneStr).append("\u3011\u8d26\u53f7\u672a\u5728SRM\u7cfb\u7edf\u7ed1\u5b9a\u624b\u673a\u53f7\u7801\uff0c\u9700\u8981\u7ed1\u5b9a\u540e\u624d\u80fd\u8fdb\u884c\u9489\u9489\u89c6\u9891\u4f1a\u8bae!");
        }
        resp.setMeetingMsg(meetingMsgSb.toString());
        return resp;
    }

    private String checkCreateUserAuth(String createUserId, String accesToken) {
        if (StrUtil.isBlank((CharSequence)createUserId)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_MIcILxOLVW_8efb446a", (String)"\u4f1a\u8bae\u521b\u5efa\u4eba\u4e0d\u80fd\u4e3a\u7a7a!"));
        }
        ArrayList<String> subAccountIds = new ArrayList<String>();
        subAccountIds.add(createUserId);
        List<ElsSubAccountDTO> subAccountDTOList = this.elsAccountApiRpcService.searchSubAccountInfoByIds(subAccountIds);
        if (subAccountDTOList == null || subAccountDTOList.size() == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_SMxuMIcILeyVHW_74975bbd", (String)"\u83b7\u53d6\u4e0d\u5230\u4f1a\u8bae\u521b\u5efa\u4eba\u8d26\u53f7\u4fe1\u606f\uff01"));
        }
        String phone = subAccountDTOList.get(0).getPhone();
        if (StrUtil.isBlank((CharSequence)phone)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_MIcILeyLKWWWHeyIltyoW_9d0611a3", (String)"\u4f1a\u8bae\u521b\u5efa\u4eba\u8d26\u53f7\u672a\u5728SRM\u7cfb\u7edf\u7ed1\u5b9a\u624b\u673a\u53f7\u7801\uff01"));
        }
        log.info("\u4f1a\u8bae\u521b\u5efa\u4eba\u624b\u673a\u53f7\u7801[{}]", (Object)phone);
        String userId = DingTalkUserInfoUtil.searchUserIdByMobile(phone, accesToken);
        if (StrUtil.isBlank((CharSequence)userId)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_MIcIL[0]xMKIIdjsVKHHeRvjlb_d9553937", (String)"\u4f1a\u8bae\u521b\u5efa\u4eba[${0}]\u4e0d\u5b58\u5728\u9489\u9489\u5e94\u7528\u4e2d\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u6388\u6743", (String[])new String[]{subAccountDTOList.get(0).getRealname()}));
        }
        String unionId = DingTalkUserInfoUtil.searchUnionIdByUserId(userId, accesToken);
        System.out.println("---------\u300b" + unionId);
        return unionId;
    }

    @Override
    public String creatChat(List<String> mobiles) {
        String accesToken = "";
        try {
            accesToken = DingTalkOauthUtil.getAccessToken();
            System.out.println("accesToken---------\u300b" + accesToken);
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        if (StrUtil.isNotBlank((CharSequence)accesToken)) {
            ArrayList<String> userIds = new ArrayList<String>();
            for (String mobile : mobiles) {
                String userId = DingTalkUserInfoUtil.searchUserIdByMobile(mobile, accesToken);
                System.out.println("mobile---------\u300b" + mobile);
                System.out.println("userId---------\u300b" + userId);
                userIds.add(userId);
            }
            try {
                String dingTalkChat = DingTalkChatUtil.createDingTalkChat("\u9489\u9489\u7fa4\u4f1a\u8bdd\u6d4b\u8bd53", (String)userIds.get(0), userIds, accesToken);
                System.out.println("---------\u300b" + dingTalkChat);
                return dingTalkChat;
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
        }
        return null;
    }
}

